import * as i0 from '@angular/core';
import { NgModule } from '@angular/core';
import * as i1 from '@ngx-formly/core';
import { ɵreverseDeepMerge as _reverseDeepMerge, FormlyConfig, FORMLY_CONFIG, FormlyModule } from '@ngx-formly/core';

class PresetSubstitutionExtension {
    constructor(formlyConfig) {
        this.formlyConfig = formlyConfig;
    }
    prePopulate(field) {
        if (!(typeof field.type === 'string') || field.type[0] !== '#') {
            return;
        }
        const configId = new RegExp(/^#(.+)$/).exec(field.type)?.[1];
        const preset = this.formlyConfig.presets[configId];
        const { type: _, ...fieldConfigWithoutType } = field;
        if (preset) {
            const merged = _reverseDeepMerge(fieldConfigWithoutType, 'getConfiguration' in preset ? preset.getConfiguration() : preset);
            Object.assign(field, merged);
        }
    }
}
function registerLibraryConfigReplacementExtension(formlyConfig) {
    return {
        extensions: [
            {
                name: 'libraryConfigReplacement',
                extension: new PresetSubstitutionExtension(formlyConfig),
                priority: -300,
            },
        ],
    };
}

function provideFormlyPreset() {
    return {
        provide: FORMLY_CONFIG,
        useFactory: registerLibraryConfigReplacementExtension,
        deps: [FormlyConfig],
        multi: true,
    };
}

class FormlyPresetModule {
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyPresetModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule }); }
    static { this.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "18.2.13", ngImport: i0, type: FormlyPresetModule, imports: [i1.FormlyModule] }); }
    static { this.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyPresetModule, providers: [provideFormlyPreset()], imports: [FormlyModule.forChild({})] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyPresetModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [FormlyModule.forChild({})],
                    providers: [provideFormlyPreset()],
                }]
        }] });

/**
 * Generated bundle index. Do not edit.
 */

export { FormlyPresetModule, provideFormlyPreset };
//# sourceMappingURL=ngx-formly-core-preset.mjs.map
