import { TestBed } from '@angular/core/testing';
import { Component } from '@angular/core';
import { FormlyModule, FormlyFormBuilder } from '@ngx-formly/core';
import { ReactiveFormsModule } from '@angular/forms';
import { By } from '@angular/platform-browser';
import * as i0 from "@angular/core";
import * as i1 from "@ngx-formly/core";
function setInputs(fixture, inputs, detectChanges = true) {
    Object.keys(inputs).forEach((input) => {
        fixture.componentInstance[input] = inputs[input];
    });
    if (detectChanges !== false) {
        fixture.detectChanges();
    }
}
export function createComponent({ template, inputs, config, detectChanges, imports, declarations, providers, }) {
    TestBed.configureTestingModule({
        declarations: [TestComponent, ...(declarations || [])],
        imports: [ReactiveFormsModule, FormlyModule.forRoot(config), ...(imports || [])],
        providers: providers || [],
        teardown: { destroyAfterEach: false },
    }).overrideComponent(TestComponent, {
        set: {
            template,
            inputs: Object.keys(inputs),
        },
    });
    const fixture = TestBed.createComponent(TestComponent);
    Object.keys(inputs).forEach((input) => {
        fixture.componentInstance[input] = inputs[input];
    });
    setInputs(fixture, inputs, detectChanges);
    const utils = {
        fixture,
        detectChanges: () => fixture.detectChanges(),
        setInputs: (props) => setInputs(fixture, props),
        query: (selector) => fixture.debugElement.query(By.css(selector)),
        queryAll: (selector) => fixture.debugElement.queryAll(By.css(selector)),
    };
    Object.keys(inputs).forEach((input) => {
        Object.defineProperty(utils, input, {
            get: () => fixture.componentInstance[input],
        });
    });
    return utils;
}
export function createFieldComponent(field, config = {}) {
    const model = field?.model || {};
    const options = field?.options || {};
    delete field?.model;
    delete field?.options;
    const utils = createComponent({
        template: '<formly-field [field]="field"></formly-field>',
        inputs: { field },
        ...config,
        detectChanges: false,
    });
    const builder = utils.fixture.componentRef.instance.builder;
    builder.build({ model, options, fieldGroup: [field] });
    utils.detectChanges();
    const setInputs = utils.setInputs;
    utils.setInputs = (props) => {
        if (props.field) {
            builder.build(props.field);
        }
        setInputs(props);
    };
    return utils;
}
class TestComponent {
    constructor(builder) {
        this.builder = builder;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: TestComponent, deps: [{ token: i1.FormlyFormBuilder }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.13", type: TestComponent, selector: "formly-test-component", providers: [FormlyFormBuilder], ngImport: i0, template: '', isInline: true }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: TestComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'formly-test-component',
                    template: '',
                    providers: [FormlyFormBuilder],
                    standalone: false,
                }]
        }], ctorParameters: () => [{ type: i1.FormlyFormBuilder }] });
//# sourceMappingURL=data:application/json;base64,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