import { Pipe } from '@angular/core';
import { BehaviorSubject, Observable } from 'rxjs';
import { filter, map, tap } from 'rxjs/operators';
import * as i0 from "@angular/core";
export class FormlySelectOptionsPipe {
    transform(options, field) {
        if (!(options instanceof Observable)) {
            options = this.observableOf(options, field);
        }
        else {
            this.dispose();
        }
        return options.pipe(map((value) => this.transformOptions(value, field)));
    }
    ngOnDestroy() {
        this.dispose();
    }
    transformOptions(options, field) {
        const to = this.transformSelectProps(field);
        const opts = [];
        const groups = {};
        options?.forEach((option) => {
            const o = this.transformOption(option, to);
            if (o.group) {
                const id = groups[o.label];
                if (id === undefined) {
                    groups[o.label] = opts.push(o) - 1;
                }
                else {
                    o.group.forEach((o) => opts[id].group.push(o));
                }
            }
            else {
                opts.push(o);
            }
        });
        return opts;
    }
    transformOption(option, props) {
        const group = props.groupProp(option);
        if (Array.isArray(group)) {
            return {
                label: props.labelProp(option),
                group: group.map((opt) => this.transformOption(opt, props)),
            };
        }
        option = {
            label: props.labelProp(option),
            value: props.valueProp(option),
            disabled: !!props.disabledProp(option),
        };
        if (group) {
            return { label: group, group: [option] };
        }
        return option;
    }
    transformSelectProps(field) {
        const props = field?.props || field?.templateOptions || {};
        const selectPropFn = (prop) => (typeof prop === 'function' ? prop : (o) => o[prop]);
        return {
            groupProp: selectPropFn(props.groupProp || 'group'),
            labelProp: selectPropFn(props.labelProp || 'label'),
            valueProp: selectPropFn(props.valueProp || 'value'),
            disabledProp: selectPropFn(props.disabledProp || 'disabled'),
        };
    }
    dispose() {
        if (this._options) {
            this._options.complete();
            this._options = null;
        }
        if (this._subscription) {
            this._subscription.unsubscribe();
            this._subscription = null;
        }
    }
    observableOf(options, f) {
        this.dispose();
        if (f && f.options && f.options.fieldChanges) {
            this._subscription = f.options.fieldChanges
                .pipe(filter(({ property, type, field }) => {
                return (type === 'expressionChanges' &&
                    (property.indexOf('templateOptions.options') === 0 || property.indexOf('props.options') === 0) &&
                    field === f &&
                    Array.isArray(field.props.options) &&
                    !!this._options);
            }), tap(() => this._options.next(f.props.options)))
                .subscribe();
        }
        this._options = new BehaviorSubject(options);
        return this._options.asObservable();
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlySelectOptionsPipe, deps: [], target: i0.ɵɵFactoryTarget.Pipe }); }
    static { this.ɵpipe = i0.ɵɵngDeclarePipe({ minVersion: "14.0.0", version: "18.2.13", ngImport: i0, type: FormlySelectOptionsPipe, isStandalone: true, name: "formlySelectOptions" }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlySelectOptionsPipe, decorators: [{
            type: Pipe,
            args: [{ name: 'formlySelectOptions', standalone: true }]
        }] });
export class LegacyFormlySelectOptionsPipe extends FormlySelectOptionsPipe {
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: LegacyFormlySelectOptionsPipe, deps: null, target: i0.ɵɵFactoryTarget.Pipe }); }
    static { this.ɵpipe = i0.ɵɵngDeclarePipe({ minVersion: "14.0.0", version: "18.2.13", ngImport: i0, type: LegacyFormlySelectOptionsPipe, name: "formlySelectOptions" }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: LegacyFormlySelectOptionsPipe, decorators: [{
            type: Pipe,
            args: [{ name: 'formlySelectOptions', standalone: false }]
        }] });
//# sourceMappingURL=data:application/json;base64,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