import { ɵreverseDeepMerge } from '@ngx-formly/core';
export class PresetSubstitutionExtension {
    constructor(formlyConfig) {
        this.formlyConfig = formlyConfig;
    }
    prePopulate(field) {
        if (!(typeof field.type === 'string') || field.type[0] !== '#') {
            return;
        }
        const configId = new RegExp(/^#(.+)$/).exec(field.type)?.[1];
        const preset = this.formlyConfig.presets[configId];
        const { type: _, ...fieldConfigWithoutType } = field;
        if (preset) {
            const merged = ɵreverseDeepMerge(fieldConfigWithoutType, 'getConfiguration' in preset ? preset.getConfiguration() : preset);
            Object.assign(field, merged);
        }
    }
}
export function registerLibraryConfigReplacementExtension(formlyConfig) {
    return {
        extensions: [
            {
                name: 'libraryConfigReplacement',
                extension: new PresetSubstitutionExtension(formlyConfig),
                priority: -300,
            },
        ],
    };
}
//# sourceMappingURL=data:application/json;base64,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