import { Component, Input, ChangeDetectionStrategy } from '@angular/core';
import { FORMLY_VALIDATORS, isObject } from '../utils';
import { isObservable, of } from 'rxjs';
import { merge } from 'rxjs';
import { startWith, switchMap, filter } from 'rxjs/operators';
import { AsyncPipe } from '@angular/common';
import * as i0 from "@angular/core";
import * as i1 from "../services/formly.config";
import * as i2 from "@angular/common";
/**
 * The `<formly-validation-message>` component renders the error message of a given `field`.
 */
export class FormlyValidationMessage {
    constructor(config) {
        this.config = config;
    }
    ngOnChanges() {
        const EXPR_VALIDATORS = FORMLY_VALIDATORS.map((v) => `templateOptions.${v}`);
        this.errorMessage$ = merge(this.field.formControl.statusChanges, !this.field.options
            ? of(null)
            : this.field.options.fieldChanges.pipe(filter(({ field, type, property }) => {
                return (field === this.field &&
                    type === 'expressionChanges' &&
                    (property.indexOf('validation') !== -1 || EXPR_VALIDATORS.indexOf(property) !== -1));
            }))).pipe(startWith(null), switchMap(() => (isObservable(this.errorMessage) ? this.errorMessage : of(this.errorMessage))));
    }
    get errorMessage() {
        const fieldForm = this.field.formControl;
        for (const error in fieldForm.errors) {
            if (fieldForm.errors.hasOwnProperty(error)) {
                let message = this.config.getValidatorMessage(error);
                if (isObject(fieldForm.errors[error])) {
                    if (fieldForm.errors[error].errorPath) {
                        return undefined;
                    }
                    if (fieldForm.errors[error].message) {
                        message = fieldForm.errors[error].message;
                    }
                }
                if (this.field.validation?.messages?.[error]) {
                    message = this.field.validation.messages[error];
                }
                if (this.field.validators?.[error]?.message) {
                    message = this.field.validators[error].message;
                }
                if (this.field.asyncValidators?.[error]?.message) {
                    message = this.field.asyncValidators[error].message;
                }
                if (typeof message === 'function') {
                    return message(fieldForm.errors[error], this.field);
                }
                return message;
            }
        }
        return undefined;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyValidationMessage, deps: [{ token: i1.FormlyConfig }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.13", type: FormlyValidationMessage, isStandalone: true, selector: "formly-validation-message", inputs: { field: "field" }, usesOnChanges: true, ngImport: i0, template: '{{ errorMessage$ | async }}', isInline: true, dependencies: [{ kind: "pipe", type: AsyncPipe, name: "async" }], changeDetection: i0.ChangeDetectionStrategy.OnPush }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyValidationMessage, decorators: [{
            type: Component,
            args: [{
                    selector: 'formly-validation-message',
                    template: '{{ errorMessage$ | async }}',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    standalone: true,
                    imports: [AsyncPipe],
                }]
        }], ctorParameters: () => [{ type: i1.FormlyConfig }], propDecorators: { field: [{
                type: Input
            }] } });
export class LegacyFormlyValidationMessage extends FormlyValidationMessage {
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: LegacyFormlyValidationMessage, deps: null, target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.13", type: LegacyFormlyValidationMessage, selector: "formly-validation-message", usesInheritance: true, ngImport: i0, template: '{{ errorMessage$ | async }}', isInline: true, dependencies: [{ kind: "pipe", type: i2.AsyncPipe, name: "async" }], changeDetection: i0.ChangeDetectionStrategy.OnPush }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: LegacyFormlyValidationMessage, decorators: [{
            type: Component,
            args: [{
                    selector: 'formly-validation-message',
                    template: '{{ errorMessage$ | async }}',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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