import { Input, Directive, ViewChildren } from '@angular/core';
import { NgControl } from '@angular/forms';
import * as i0 from "@angular/core";
export class FieldType {
    constructor() {
        this.field = {};
    }
    set _formlyControls(controls) {
        const f = this.field;
        f._localFields = controls
            .map((c) => c.control._fields || [])
            .flat()
            .filter((f) => f.formControl !== this.field.formControl);
    }
    get model() {
        return this.field.model;
    }
    get form() {
        return this.field.form;
    }
    get options() {
        return this.field.options;
    }
    get key() {
        return this.field.key;
    }
    get formControl() {
        return this.field.formControl;
    }
    get props() {
        return (this.field.props || {});
    }
    /** @deprecated Use `props` instead. */
    get to() {
        return this.props;
    }
    get showError() {
        return this.options.showError(this);
    }
    get id() {
        return this.field.id;
    }
    get formState() {
        return this.options?.formState || {};
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FieldType, deps: [], target: i0.ɵɵFactoryTarget.Directive }); }
    static { this.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "18.2.13", type: FieldType, inputs: { field: "field" }, viewQueries: [{ propertyName: "_formlyControls", predicate: NgControl, descendants: true }], ngImport: i0 }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FieldType, decorators: [{
            type: Directive
        }], propDecorators: { _formlyControls: [{
                type: ViewChildren,
                args: [NgControl]
            }], field: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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