import { Component, ChangeDetectionStrategy } from '@angular/core';
import { FieldType } from './field.type';
import * as i0 from "@angular/core";
import * as i1 from "@angular/platform-browser";
/** @ignore */
export class FormlyTemplateType extends FieldType {
    get template() {
        if (this.field && this.field.template !== this.innerHtml.template) {
            this.innerHtml = {
                template: this.field.template,
                content: this.props.safeHtml
                    ? this.sanitizer.bypassSecurityTrustHtml(this.field.template)
                    : this.field.template,
            };
        }
        return this.innerHtml.content;
    }
    constructor(sanitizer) {
        super();
        this.sanitizer = sanitizer;
        this.innerHtml = {};
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyTemplateType, deps: [{ token: i1.DomSanitizer }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.13", type: FormlyTemplateType, selector: "formly-template", usesInheritance: true, ngImport: i0, template: `<div [innerHtml]="template"></div>`, isInline: true, changeDetection: i0.ChangeDetectionStrategy.OnPush }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyTemplateType, decorators: [{
            type: Component,
            args: [{
                    selector: 'formly-template',
                    template: `<div [innerHtml]="template"></div>`,
                    changeDetection: ChangeDetectionStrategy.OnPush,
                }]
        }], ctorParameters: () => [{ type: i1.DomSanitizer }] });
//# sourceMappingURL=data:application/json;base64,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