import { Directive } from '@angular/core';
import { UntypedFormArray } from '@angular/forms';
import { FieldType } from './field.type';
import { clone, assignFieldValue, getFieldValue, hasKey } from '../utils';
import { registerControl, unregisterControl, findControl } from '../extensions/field-form/utils';
import * as i0 from "@angular/core";
export class FieldArrayType extends FieldType {
    onPopulate(field) {
        if (hasKey(field)) {
            const control = findControl(field);
            registerControl(field, control ? control : new UntypedFormArray([], { updateOn: field.modelOptions.updateOn }));
        }
        field.fieldGroup = field.fieldGroup || [];
        const length = Array.isArray(field.model) ? field.model.length : 0;
        if (field.fieldGroup.length > length) {
            for (let i = field.fieldGroup.length - 1; i >= length; --i) {
                unregisterControl(field.fieldGroup[i], true);
                field.fieldGroup.splice(i, 1);
            }
        }
        for (let i = field.fieldGroup.length; i < length; i++) {
            const f = { ...clone(typeof field.fieldArray === 'function' ? field.fieldArray(field) : field.fieldArray) };
            if (f.key !== null) {
                f.key = `${i}`;
            }
            field.fieldGroup.push(f);
        }
    }
    add(i, initialModel, { markAsDirty } = { markAsDirty: true }) {
        markAsDirty && this.formControl.markAsDirty();
        i = i == null ? this.field.fieldGroup.length : i;
        if (!this.model) {
            assignFieldValue(this.field, []);
        }
        this.model.splice(i, 0, initialModel ? clone(initialModel) : undefined);
        this.markFieldForCheck(this.field.fieldGroup[i]);
        this._build();
    }
    remove(i, { markAsDirty } = { markAsDirty: true }) {
        markAsDirty && this.formControl.markAsDirty();
        this.model.splice(i, 1);
        const field = this.field.fieldGroup[i];
        this.field.fieldGroup.splice(i, 1);
        this.field.fieldGroup.forEach((f, key) => this.updateArrayElementKey(f, `${key}`));
        unregisterControl(field, true);
        this._build();
    }
    _build() {
        const fields = this.field.formControl._fields ?? [this.field];
        fields.forEach((f) => this.options.build(f));
        this.options.fieldChanges.next({
            field: this.field,
            value: getFieldValue(this.field),
            type: 'valueChanges',
        });
    }
    updateArrayElementKey(f, newKey) {
        if (hasKey(f)) {
            f.key = newKey;
            return;
        }
        if (!f.fieldGroup?.length) {
            return;
        }
        for (let i = 0; i < f.fieldGroup.length; i++) {
            this.updateArrayElementKey(f.fieldGroup[i], newKey);
        }
    }
    markFieldForCheck(f) {
        if (!f) {
            return;
        }
        f.fieldGroup?.forEach((c) => this.markFieldForCheck(c));
        if (f.hide === false) {
            this.options._hiddenFieldsForCheck.push({ field: f });
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FieldArrayType, deps: null, target: i0.ɵɵFactoryTarget.Directive }); }
    static { this.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "18.2.13", type: FieldArrayType, usesInheritance: true, ngImport: i0 }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FieldArrayType, decorators: [{
            type: Directive
        }] });
//# sourceMappingURL=data:application/json;base64,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