import { Inject, Injectable, Optional } from '@angular/core';
import { UntypedFormGroup } from '@angular/forms';
import { defineHiddenProp, observe, disableTreeValidityCall, isHiddenField, isSignalRequired } from '../utils';
import { FORMLY_CONFIG } from '../core.config';
import * as i0 from "@angular/core";
import * as i1 from "./formly.config";
import * as i2 from "@angular/forms";
export class FormlyFormBuilder {
    constructor(config, injector, viewContainerRef, parentForm, configs = []) {
        this.config = config;
        this.injector = injector;
        this.viewContainerRef = viewContainerRef;
        this.parentForm = parentForm;
        if (configs) {
            configs.forEach((c) => config.addConfig(c));
        }
    }
    buildForm(form, fieldGroup = [], model, options) {
        this.build({ fieldGroup, model, form, options });
    }
    build(field) {
        if (!this.config.extensions.core) {
            throw new Error('NgxFormly: missing `forRoot()` call. use `forRoot()` when registering the `FormlyModule`.');
        }
        if (!field.parent) {
            this._setOptions(field);
        }
        disableTreeValidityCall(field.form, () => {
            this._build(field);
            // TODO: add test for https://github.com/ngx-formly/ngx-formly/issues/3910
            if (!field.parent || field.fieldArray) {
                // detect changes early to avoid reset value by hidden fields
                const options = field.options;
                if (field.parent && isHiddenField(field)) {
                    // when hide is used in expression set defaul value will not be set until detect hide changes
                    // which causes default value not set on new item is added
                    options._hiddenFieldsForCheck?.push({ field, default: false });
                }
                options.checkExpressions?.(field, true);
                options._detectChanges?.(field);
            }
        });
    }
    _build(field) {
        if (!field) {
            return;
        }
        const extensions = Object.values(this.config.extensions);
        extensions.forEach((extension) => extension.prePopulate?.(field));
        extensions.forEach((extension) => extension.onPopulate?.(field));
        field.fieldGroup?.forEach((f) => this._build(f));
        extensions.forEach((extension) => extension.postPopulate?.(field));
    }
    _setOptions(field) {
        field.form = field.form || new UntypedFormGroup({});
        field.model = field.model || {};
        field.options = field.options || {};
        const options = field.options;
        if (!options._viewContainerRef) {
            defineHiddenProp(options, '_viewContainerRef', this.viewContainerRef);
        }
        if (!options._injector) {
            defineHiddenProp(options, '_injector', this.injector);
        }
        if (!options.build) {
            options.build = (f = field) => {
                this.build(f);
                return f;
            };
        }
        if (!options.parentForm && this.parentForm) {
            defineHiddenProp(options, 'parentForm', this.parentForm);
            if (!isSignalRequired()) {
                observe(options, ['parentForm', 'submitted'], ({ firstChange }) => {
                    if (!firstChange) {
                        options.detectChanges(field);
                    }
                });
            }
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFormBuilder, deps: [{ token: i1.FormlyConfig }, { token: i0.Injector }, { token: i0.ViewContainerRef, optional: true }, { token: i2.FormGroupDirective, optional: true }, { token: FORMLY_CONFIG, optional: true }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFormBuilder, providedIn: 'root' }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyFormBuilder, decorators: [{
            type: Injectable,
            args: [{ providedIn: 'root' }]
        }], ctorParameters: () => [{ type: i1.FormlyConfig }, { type: i0.Injector }, { type: i0.ViewContainerRef, decorators: [{
                    type: Optional
                }] }, { type: i2.FormGroupDirective, decorators: [{
                    type: Optional
                }] }, { type: undefined, decorators: [{
                    type: Optional
                }, {
                    type: Inject,
                    args: [FORMLY_CONFIG]
                }] }] });
//# sourceMappingURL=data:application/json;base64,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