import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { LegacyFormlyForm } from './components/formly.form';
import { LegacyFormlyField } from './components/formly.field';
import { LegacyFormlyAttributes } from './templates/formly.attributes';
import { FormlyConfig } from './services/formly.config';
import { FormlyFormBuilder } from './services/formly.builder';
import { FormlyGroup } from './templates/formly.group';
import { LegacyFormlyValidationMessage } from './templates/formly.validation-message';
import { FormlyTemplateType } from './templates/field-template.type';
import { FormlyTemplate } from './components/formly.template';
import { FORMLY_CONFIG, withDefaultConfig } from './core.config';
import * as i0 from "@angular/core";
export class FormlyModule {
    static forRoot(config = {}) {
        return {
            ngModule: FormlyModule,
            providers: [
                { provide: FORMLY_CONFIG, multi: true, useFactory: withDefaultConfig, deps: [FormlyConfig] },
                { provide: FORMLY_CONFIG, useValue: config, multi: true },
                FormlyConfig,
                FormlyFormBuilder,
            ],
        };
    }
    static forChild(config = {}) {
        return {
            ngModule: FormlyModule,
            providers: [
                { provide: FORMLY_CONFIG, multi: true, useFactory: withDefaultConfig, deps: [FormlyConfig] },
                { provide: FORMLY_CONFIG, useValue: config, multi: true },
                FormlyFormBuilder,
            ],
        };
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule }); }
    static { this.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "18.2.13", ngImport: i0, type: FormlyModule, declarations: [FormlyTemplate,
            LegacyFormlyForm,
            LegacyFormlyField,
            LegacyFormlyAttributes,
            LegacyFormlyValidationMessage,
            FormlyGroup,
            FormlyTemplateType], imports: [CommonModule], exports: [FormlyTemplate,
            LegacyFormlyForm,
            LegacyFormlyField,
            LegacyFormlyAttributes,
            LegacyFormlyValidationMessage,
            FormlyGroup] }); }
    static { this.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyModule, imports: [CommonModule] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [
                        FormlyTemplate,
                        LegacyFormlyForm,
                        LegacyFormlyField,
                        LegacyFormlyAttributes,
                        LegacyFormlyValidationMessage,
                        FormlyGroup,
                        FormlyTemplateType,
                    ],
                    exports: [
                        FormlyTemplate,
                        LegacyFormlyForm,
                        LegacyFormlyField,
                        LegacyFormlyAttributes,
                        LegacyFormlyValidationMessage,
                        FormlyGroup,
                    ],
                    imports: [CommonModule],
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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