import { InjectionToken } from '@angular/core';
import { FieldExpressionExtension } from './extensions';
import { CoreExtension } from './extensions/core/core';
import { FieldFormExtension } from './extensions/field-form/field-form';
import { FieldValidationExtension } from './extensions/field-validation/field-validation';
import { FormlyTemplateType } from './templates/field-template.type';
import { FormlyGroup } from './templates/formly.group';
import { FormlyConfig } from './services/formly.config';
/**
 * An InjectionToken for registering additional formly config options (types, wrappers ...).
 */
export const FORMLY_CONFIG = new InjectionToken('FORMLY_CONFIG');
export function withDefaultConfig(config) {
    return {
        types: [
            { name: 'formly-group', component: FormlyGroup },
            { name: 'formly-template', component: FormlyTemplateType },
        ],
        extensions: [
            { name: 'core', extension: new CoreExtension(config), priority: -250 },
            { name: 'field-validation', extension: new FieldValidationExtension(config), priority: -200 },
            { name: 'field-form', extension: new FieldFormExtension(), priority: -150 },
            { name: 'field-expression', extension: new FieldExpressionExtension(), priority: -100 },
        ],
    };
}
export const provideFormlyCore = (configs = []) => {
    return [
        { provide: FORMLY_CONFIG, multi: true, useFactory: withDefaultConfig, deps: [FormlyConfig] },
        provideFormlyConfig(configs),
    ];
};
export const provideFormlyConfig = (configs = []) => {
    return [{ provide: FORMLY_CONFIG, multi: true, useValue: configs }];
};
//# sourceMappingURL=data:application/json;base64,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