import { Component, ChangeDetectionStrategy, Input, EventEmitter, Output, ContentChildren, } from '@angular/core';
import { FormlyFormBuilder } from '../services/formly.builder';
import { clone, hasKey, isNoopNgZone, isSignalRequired, observeDeep } from '../utils';
import { switchMap, filter, take } from 'rxjs/operators';
import { clearControl } from '../extensions/field-form/utils';
import { FormlyFieldTemplates, FormlyTemplate } from './formly.template';
import { of } from 'rxjs';
import { FormlyField } from './formly.field';
import * as i0 from "@angular/core";
import * as i1 from "../services/formly.builder";
import * as i2 from "../services/formly.config";
import * as i3 from "./formly.template";
import * as i4 from "./formly.field";
/**
 * The `<form-form>` component is the main container of the form,
 * which takes care of managing the form state
 * and delegates the rendering of each field to `<formly-field>` component.
 */
export class FormlyForm {
    /** The form instance which allow to track model value and validation status. */
    set form(form) {
        this.field.form = form;
    }
    get form() {
        return this.field.form;
    }
    /** The model to be represented by the form. */
    set model(model) {
        if (this.config.extras.immutable && this._modelChangeValue === model) {
            return;
        }
        this.setField({ model });
    }
    get model() {
        return this.field.model;
    }
    /** The field configurations for building the form. */
    set fields(fieldGroup) {
        this.setField({ fieldGroup });
    }
    get fields() {
        return this.field.fieldGroup;
    }
    /** Options for the form. */
    set options(options) {
        this.setField({ options });
    }
    get options() {
        return this.field.options;
    }
    set templates(templates) {
        this.fieldTemplates.templates = templates;
    }
    constructor(builder, config, ngZone, fieldTemplates) {
        this.builder = builder;
        this.config = config;
        this.ngZone = ngZone;
        this.fieldTemplates = fieldTemplates;
        /** Event that is emitted when the model value is changed */
        this.modelChange = new EventEmitter();
        this.field = { type: 'formly-group' };
        this._modelChangeValue = {};
        this.valueChangesUnsubscribe = () => { };
    }
    ngDoCheck() {
        if (this.config.extras.checkExpressionOn === 'changeDetectionCheck') {
            this.checkExpressionChange();
        }
    }
    ngOnChanges(changes) {
        if (changes.fields && this.form) {
            clearControl(this.form);
        }
        if (changes.fields || changes.form || (changes.model && this._modelChangeValue !== changes.model.currentValue)) {
            this.valueChangesUnsubscribe();
            this.builder.build(this.field);
            this.valueChangesUnsubscribe = this.valueChanges();
        }
    }
    ngOnDestroy() {
        this.valueChangesUnsubscribe();
        this.config.clearRefs();
    }
    checkExpressionChange() {
        this.field.options.checkExpressions?.(this.field);
    }
    valueChanges() {
        this.valueChangesUnsubscribe();
        let formEvents = null;
        if (isSignalRequired()) {
            let submitted = this.options?.parentForm?.submitted;
            formEvents = this.form.events.subscribe(() => {
                if (submitted !== this.options?.parentForm?.submitted) {
                    this.options.detectChanges(this.field);
                    submitted = this.options?.parentForm?.submitted;
                }
            });
        }
        const fieldChangesDetection = [
            observeDeep(this.field.options, ['formState'], () => this.field.options.detectChanges(this.field)),
        ];
        const valueChanges = this.field.options.fieldChanges
            .pipe(filter(({ field, type }) => hasKey(field) && type === 'valueChanges'), switchMap(() => (isNoopNgZone(this.ngZone) ? of(null) : this.ngZone.onStable.asObservable().pipe(take(1)))))
            .subscribe(() => this.ngZone.runGuarded(() => {
            // runGuarded is used to keep in sync the expression changes
            // https://github.com/ngx-formly/ngx-formly/issues/2095
            this.checkExpressionChange();
            this.modelChange.emit((this._modelChangeValue = clone(this.model)));
        }));
        return () => {
            fieldChangesDetection.forEach((fnc) => fnc());
            formEvents?.unsubscribe();
            valueChanges.unsubscribe();
        };
    }
    setField(field) {
        if (this.config.extras.immutable) {
            this.field = { ...this.field, ...clone(field) };
        }
        else {
            Object.keys(field).forEach((p) => (this.field[p] = field[p]));
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyForm, deps: [{ token: i1.FormlyFormBuilder }, { token: i2.FormlyConfig }, { token: i0.NgZone }, { token: i3.FormlyFieldTemplates }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.13", type: FormlyForm, isStandalone: true, selector: "formly-form", inputs: { form: "form", model: "model", fields: "fields", options: "options" }, outputs: { modelChange: "modelChange" }, providers: [FormlyFormBuilder, FormlyFieldTemplates], queries: [{ propertyName: "templates", predicate: FormlyTemplate }], usesOnChanges: true, ngImport: i0, template: '<formly-field [field]="field"></formly-field>', isInline: true, dependencies: [{ kind: "component", type: FormlyField, selector: "formly-field", inputs: ["field"] }], changeDetection: i0.ChangeDetectionStrategy.OnPush }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: FormlyForm, decorators: [{
            type: Component,
            args: [{
                    selector: 'formly-form',
                    template: '<formly-field [field]="field"></formly-field>',
                    providers: [FormlyFormBuilder, FormlyFieldTemplates],
                    imports: [FormlyField],
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    standalone: true,
                }]
        }], ctorParameters: () => [{ type: i1.FormlyFormBuilder }, { type: i2.FormlyConfig }, { type: i0.NgZone }, { type: i3.FormlyFieldTemplates }], propDecorators: { form: [{
                type: Input
            }], model: [{
                type: Input
            }], fields: [{
                type: Input
            }], options: [{
                type: Input
            }], modelChange: [{
                type: Output
            }], templates: [{
                type: ContentChildren,
                args: [FormlyTemplate]
            }] } });
export class LegacyFormlyForm extends FormlyForm {
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: LegacyFormlyForm, deps: null, target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.13", type: LegacyFormlyForm, selector: "formly-form", providers: [FormlyFormBuilder, FormlyFieldTemplates], usesInheritance: true, ngImport: i0, template: '<formly-field [field]="field"></formly-field>', isInline: true, dependencies: [{ kind: "component", type: i4.LegacyFormlyField, selector: "formly-field" }], changeDetection: i0.ChangeDetectionStrategy.OnPush }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.13", ngImport: i0, type: LegacyFormlyForm, decorators: [{
            type: Component,
            args: [{
                    selector: 'formly-form',
                    template: '<formly-field [field]="field"></formly-field>',
                    providers: [FormlyFormBuilder, FormlyFieldTemplates],
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    standalone: false,
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZm9ybWx5LmZvcm0uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9zcmMvY29yZS9zcmMvbGliL2NvbXBvbmVudHMvZm9ybWx5LmZvcm0udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUNMLFNBQVMsRUFDVCx1QkFBdUIsRUFHdkIsS0FBSyxFQUVMLFlBQVksRUFDWixNQUFNLEVBR04sZUFBZSxHQUVoQixNQUFNLGVBQWUsQ0FBQztBQUd2QixPQUFPLEVBQUUsaUJBQWlCLEVBQUUsTUFBTSw0QkFBNEIsQ0FBQztBQUUvRCxPQUFPLEVBQUUsS0FBSyxFQUFFLE1BQU0sRUFBRSxZQUFZLEVBQUUsZ0JBQWdCLEVBQUUsV0FBVyxFQUFFLE1BQU0sVUFBVSxDQUFDO0FBQ3RGLE9BQU8sRUFBRSxTQUFTLEVBQUUsTUFBTSxFQUFFLElBQUksRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBQ3pELE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSxnQ0FBZ0MsQ0FBQztBQUM5RCxPQUFPLEVBQUUsb0JBQW9CLEVBQUUsY0FBYyxFQUFFLE1BQU0sbUJBQW1CLENBQUM7QUFDekUsT0FBTyxFQUFFLEVBQUUsRUFBZ0IsTUFBTSxNQUFNLENBQUM7QUFDeEMsT0FBTyxFQUFFLFdBQVcsRUFBRSxNQUFNLGdCQUFnQixDQUFDOzs7Ozs7QUFFN0M7Ozs7R0FJRztBQVNILE1BQU0sT0FBTyxVQUFVO0lBQ3JCLGdGQUFnRjtJQUNoRixJQUNJLElBQUksQ0FBQyxJQUF5QztRQUNoRCxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksR0FBRyxJQUFJLENBQUM7SUFDekIsQ0FBQztJQUNELElBQUksSUFBSTtRQUNOLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUM7SUFDekIsQ0FBQztJQUVELCtDQUErQztJQUMvQyxJQUNJLEtBQUssQ0FBQyxLQUFVO1FBQ2xCLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxpQkFBaUIsS0FBSyxLQUFLLEVBQUUsQ0FBQztZQUNyRSxPQUFPO1FBQ1QsQ0FBQztRQUVELElBQUksQ0FBQyxRQUFRLENBQUMsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDO0lBQzNCLENBQUM7SUFDRCxJQUFJLEtBQUs7UUFDUCxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDO0lBQzFCLENBQUM7SUFFRCxzREFBc0Q7SUFDdEQsSUFDSSxNQUFNLENBQUMsVUFBK0I7UUFDeEMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxFQUFFLFVBQVUsRUFBRSxDQUFDLENBQUM7SUFDaEMsQ0FBQztJQUNELElBQUksTUFBTTtRQUNSLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUM7SUFDL0IsQ0FBQztJQUVELDRCQUE0QjtJQUM1QixJQUNJLE9BQU8sQ0FBQyxPQUEwQjtRQUNwQyxJQUFJLENBQUMsUUFBUSxDQUFDLEVBQUUsT0FBTyxFQUFFLENBQUMsQ0FBQztJQUM3QixDQUFDO0lBQ0QsSUFBSSxPQUFPO1FBQ1QsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQztJQUM1QixDQUFDO0lBSUQsSUFBcUMsU0FBUyxDQUFDLFNBQW9DO1FBQ2pGLElBQUksQ0FBQyxjQUFjLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM1QyxDQUFDO0lBTUQsWUFDVSxPQUEwQixFQUMxQixNQUFvQixFQUNwQixNQUFjLEVBQ2QsY0FBb0M7UUFIcEMsWUFBTyxHQUFQLE9BQU8sQ0FBbUI7UUFDMUIsV0FBTSxHQUFOLE1BQU0sQ0FBYztRQUNwQixXQUFNLEdBQU4sTUFBTSxDQUFRO1FBQ2QsbUJBQWMsR0FBZCxjQUFjLENBQXNCO1FBZDlDLDREQUE0RDtRQUNsRCxnQkFBVyxHQUFHLElBQUksWUFBWSxFQUFPLENBQUM7UUFLaEQsVUFBSyxHQUEyQixFQUFFLElBQUksRUFBRSxjQUFjLEVBQUUsQ0FBQztRQUNqRCxzQkFBaUIsR0FBUSxFQUFFLENBQUM7UUFDNUIsNEJBQXVCLEdBQUcsR0FBRyxFQUFFLEdBQUUsQ0FBQyxDQUFDO0lBT3hDLENBQUM7SUFFSixTQUFTO1FBQ1AsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxpQkFBaUIsS0FBSyxzQkFBc0IsRUFBRSxDQUFDO1lBQ3BFLElBQUksQ0FBQyxxQkFBcUIsRUFBRSxDQUFDO1FBQy9CLENBQUM7SUFDSCxDQUFDO0lBRUQsV0FBVyxDQUFDLE9BQXNCO1FBQ2hDLElBQUksT0FBTyxDQUFDLE1BQU0sSUFBSSxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7WUFDaEMsWUFBWSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMxQixDQUFDO1FBRUQsSUFBSSxPQUFPLENBQUMsTUFBTSxJQUFJLE9BQU8sQ0FBQyxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxJQUFJLElBQUksQ0FBQyxpQkFBaUIsS0FBSyxPQUFPLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQUM7WUFDL0csSUFBSSxDQUFDLHVCQUF1QixFQUFFLENBQUM7WUFDL0IsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQy9CLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7UUFDckQsQ0FBQztJQUNILENBQUM7SUFFRCxXQUFXO1FBQ1QsSUFBSSxDQUFDLHVCQUF1QixFQUFFLENBQUM7UUFDL0IsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLEVBQUUsQ0FBQztJQUMxQixDQUFDO0lBRU8scUJBQXFCO1FBQzNCLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLGdCQUFnQixFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFFTyxZQUFZO1FBQ2xCLElBQUksQ0FBQyx1QkFBdUIsRUFBRSxDQUFDO1FBRS9CLElBQUksVUFBVSxHQUF3QixJQUFJLENBQUM7UUFDM0MsSUFBSSxnQkFBZ0IsRUFBRSxFQUFFLENBQUM7WUFDdkIsSUFBSSxTQUFTLEdBQUcsSUFBSSxDQUFDLE9BQU8sRUFBRSxVQUFVLEVBQUUsU0FBUyxDQUFDO1lBQ3BELFVBQVUsR0FBSSxJQUFJLENBQUMsSUFBWSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsR0FBRyxFQUFFO2dCQUNwRCxJQUFJLFNBQVMsS0FBSyxJQUFJLENBQUMsT0FBTyxFQUFFLFVBQVUsRUFBRSxTQUFTLEVBQUUsQ0FBQztvQkFDdEQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUN2QyxTQUFTLEdBQUcsSUFBSSxDQUFDLE9BQU8sRUFBRSxVQUFVLEVBQUUsU0FBUyxDQUFDO2dCQUNsRCxDQUFDO1lBQ0gsQ0FBQyxDQUFDLENBQUM7UUFDTCxDQUFDO1FBRUQsTUFBTSxxQkFBcUIsR0FBVTtZQUNuQyxXQUFXLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLEVBQUUsQ0FBQyxXQUFXLENBQUMsRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1NBQ25HLENBQUM7UUFDRixNQUFNLFlBQVksR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxZQUFZO2FBQ2pELElBQUksQ0FDSCxNQUFNLENBQUMsQ0FBQyxFQUFFLEtBQUssRUFBRSxJQUFJLEVBQUUsRUFBRSxFQUFFLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxJQUFJLElBQUksS0FBSyxjQUFjLENBQUMsRUFDckUsU0FBUyxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxZQUFZLEVBQUUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUM1RzthQUNBLFNBQVMsQ0FBQyxHQUFHLEVBQUUsQ0FDZCxJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxHQUFHLEVBQUU7WUFDMUIsNERBQTREO1lBQzVELHVEQUF1RDtZQUN2RCxJQUFJLENBQUMscUJBQXFCLEVBQUUsQ0FBQztZQUM3QixJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUN0RSxDQUFDLENBQUMsQ0FDSCxDQUFDO1FBRUosT0FBTyxHQUFHLEVBQUU7WUFDVixxQkFBcUIsQ0FBQyxPQUFPLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUM7WUFDOUMsVUFBVSxFQUFFLFdBQVcsRUFBRSxDQUFDO1lBQzFCLFlBQVksQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUM3QixDQUFDLENBQUM7SUFDSixDQUFDO0lBRU8sUUFBUSxDQUFDLEtBQTZCO1FBQzVDLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsU0FBUyxFQUFFLENBQUM7WUFDakMsSUFBSSxDQUFDLEtBQUssR0FBRyxFQUFFLEdBQUcsSUFBSSxDQUFDLEtBQUssRUFBRSxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDO1FBQ2xELENBQUM7YUFBTSxDQUFDO1lBQ04sTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUUsSUFBSSxDQUFDLEtBQWEsQ0FBQyxDQUFDLENBQUMsR0FBSSxLQUFhLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ2xGLENBQUM7SUFDSCxDQUFDOytHQWpJVSxVQUFVO21HQUFWLFVBQVUsbUxBTFYsQ0FBQyxpQkFBaUIsRUFBRSxvQkFBb0IsQ0FBQyxvREFnRG5DLGNBQWMsa0RBakRyQiwrQ0FBK0MsNERBRS9DLFdBQVc7OzRGQUlWLFVBQVU7a0JBUnRCLFNBQVM7bUJBQUM7b0JBQ1QsUUFBUSxFQUFFLGFBQWE7b0JBQ3ZCLFFBQVEsRUFBRSwrQ0FBK0M7b0JBQ3pELFNBQVMsRUFBRSxDQUFDLGlCQUFpQixFQUFFLG9CQUFvQixDQUFDO29CQUNwRCxPQUFPLEVBQUUsQ0FBQyxXQUFXLENBQUM7b0JBQ3RCLGVBQWUsRUFBRSx1QkFBdUIsQ0FBQyxNQUFNO29CQUMvQyxVQUFVLEVBQUUsSUFBSTtpQkFDakI7eUtBSUssSUFBSTtzQkFEUCxLQUFLO2dCQVVGLEtBQUs7c0JBRFIsS0FBSztnQkFjRixNQUFNO3NCQURULEtBQUs7Z0JBVUYsT0FBTztzQkFEVixLQUFLO2dCQVNJLFdBQVc7c0JBQXBCLE1BQU07Z0JBQzhCLFNBQVM7c0JBQTdDLGVBQWU7dUJBQUMsY0FBYzs7QUFnR2pDLE1BQU0sT0FBTyxnQkFBaUIsU0FBUSxVQUFVOytHQUFuQyxnQkFBZ0I7bUdBQWhCLGdCQUFnQixzQ0FKaEIsQ0FBQyxpQkFBaUIsRUFBRSxvQkFBb0IsQ0FBQyxpREFEMUMsK0NBQStDOzs0RkFLOUMsZ0JBQWdCO2tCQVA1QixTQUFTO21CQUFDO29CQUNULFFBQVEsRUFBRSxhQUFhO29CQUN2QixRQUFRLEVBQUUsK0NBQStDO29CQUN6RCxTQUFTLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxvQkFBb0IsQ0FBQztvQkFDcEQsZUFBZSxFQUFFLHVCQUF1QixDQUFDLE1BQU07b0JBQy9DLFVBQVUsRUFBRSxLQUFLO2lCQUNsQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIENvbXBvbmVudCxcbiAgQ2hhbmdlRGV0ZWN0aW9uU3RyYXRlZ3ksXG4gIERvQ2hlY2ssXG4gIE9uQ2hhbmdlcyxcbiAgSW5wdXQsXG4gIFNpbXBsZUNoYW5nZXMsXG4gIEV2ZW50RW1pdHRlcixcbiAgT3V0cHV0LFxuICBPbkRlc3Ryb3ksXG4gIE5nWm9uZSxcbiAgQ29udGVudENoaWxkcmVuLFxuICBRdWVyeUxpc3QsXG59IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgVW50eXBlZEZvcm1Hcm91cCwgVW50eXBlZEZvcm1BcnJheSB9IGZyb20gJ0Bhbmd1bGFyL2Zvcm1zJztcbmltcG9ydCB7IEZvcm1seUZpZWxkQ29uZmlnLCBGb3JtbHlGb3JtT3B0aW9ucywgRm9ybWx5RmllbGRDb25maWdDYWNoZSB9IGZyb20gJy4uL21vZGVscyc7XG5pbXBvcnQgeyBGb3JtbHlGb3JtQnVpbGRlciB9IGZyb20gJy4uL3NlcnZpY2VzL2Zvcm1seS5idWlsZGVyJztcbmltcG9ydCB7IEZvcm1seUNvbmZpZyB9IGZyb20gJy4uL3NlcnZpY2VzL2Zvcm1seS5jb25maWcnO1xuaW1wb3J0IHsgY2xvbmUsIGhhc0tleSwgaXNOb29wTmdab25lLCBpc1NpZ25hbFJlcXVpcmVkLCBvYnNlcnZlRGVlcCB9IGZyb20gJy4uL3V0aWxzJztcbmltcG9ydCB7IHN3aXRjaE1hcCwgZmlsdGVyLCB0YWtlIH0gZnJvbSAncnhqcy9vcGVyYXRvcnMnO1xuaW1wb3J0IHsgY2xlYXJDb250cm9sIH0gZnJvbSAnLi4vZXh0ZW5zaW9ucy9maWVsZC1mb3JtL3V0aWxzJztcbmltcG9ydCB7IEZvcm1seUZpZWxkVGVtcGxhdGVzLCBGb3JtbHlUZW1wbGF0ZSB9IGZyb20gJy4vZm9ybWx5LnRlbXBsYXRlJztcbmltcG9ydCB7IG9mLCBTdWJzY3JpcHRpb24gfSBmcm9tICdyeGpzJztcbmltcG9ydCB7IEZvcm1seUZpZWxkIH0gZnJvbSAnLi9mb3JtbHkuZmllbGQnO1xuXG4vKipcbiAqIFRoZSBgPGZvcm0tZm9ybT5gIGNvbXBvbmVudCBpcyB0aGUgbWFpbiBjb250YWluZXIgb2YgdGhlIGZvcm0sXG4gKiB3aGljaCB0YWtlcyBjYXJlIG9mIG1hbmFnaW5nIHRoZSBmb3JtIHN0YXRlXG4gKiBhbmQgZGVsZWdhdGVzIHRoZSByZW5kZXJpbmcgb2YgZWFjaCBmaWVsZCB0byBgPGZvcm1seS1maWVsZD5gIGNvbXBvbmVudC5cbiAqL1xuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiAnZm9ybWx5LWZvcm0nLFxuICB0ZW1wbGF0ZTogJzxmb3JtbHktZmllbGQgW2ZpZWxkXT1cImZpZWxkXCI+PC9mb3JtbHktZmllbGQ+JyxcbiAgcHJvdmlkZXJzOiBbRm9ybWx5Rm9ybUJ1aWxkZXIsIEZvcm1seUZpZWxkVGVtcGxhdGVzXSxcbiAgaW1wb3J0czogW0Zvcm1seUZpZWxkXSxcbiAgY2hhbmdlRGV0ZWN0aW9uOiBDaGFuZ2VEZXRlY3Rpb25TdHJhdGVneS5PblB1c2gsXG4gIHN0YW5kYWxvbmU6IHRydWUsXG59KVxuZXhwb3J0IGNsYXNzIEZvcm1seUZvcm0gaW1wbGVtZW50cyBEb0NoZWNrLCBPbkNoYW5nZXMsIE9uRGVzdHJveSB7XG4gIC8qKiBUaGUgZm9ybSBpbnN0YW5jZSB3aGljaCBhbGxvdyB0byB0cmFjayBtb2RlbCB2YWx1ZSBhbmQgdmFsaWRhdGlvbiBzdGF0dXMuICovXG4gIEBJbnB1dCgpXG4gIHNldCBmb3JtKGZvcm06IFVudHlwZWRGb3JtR3JvdXAgfCBVbnR5cGVkRm9ybUFycmF5KSB7XG4gICAgdGhpcy5maWVsZC5mb3JtID0gZm9ybTtcbiAgfVxuICBnZXQgZm9ybSgpOiBVbnR5cGVkRm9ybUdyb3VwIHwgVW50eXBlZEZvcm1BcnJheSB7XG4gICAgcmV0dXJuIHRoaXMuZmllbGQuZm9ybTtcbiAgfVxuXG4gIC8qKiBUaGUgbW9kZWwgdG8gYmUgcmVwcmVzZW50ZWQgYnkgdGhlIGZvcm0uICovXG4gIEBJbnB1dCgpXG4gIHNldCBtb2RlbChtb2RlbDogYW55KSB7XG4gICAgaWYgKHRoaXMuY29uZmlnLmV4dHJhcy5pbW11dGFibGUgJiYgdGhpcy5fbW9kZWxDaGFuZ2VWYWx1ZSA9PT0gbW9kZWwpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICB0aGlzLnNldEZpZWxkKHsgbW9kZWwgfSk7XG4gIH1cbiAgZ2V0IG1vZGVsKCk6IGFueSB7XG4gICAgcmV0dXJuIHRoaXMuZmllbGQubW9kZWw7XG4gIH1cblxuICAvKiogVGhlIGZpZWxkIGNvbmZpZ3VyYXRpb25zIGZvciBidWlsZGluZyB0aGUgZm9ybS4gKi9cbiAgQElucHV0KClcbiAgc2V0IGZpZWxkcyhmaWVsZEdyb3VwOiBGb3JtbHlGaWVsZENvbmZpZ1tdKSB7XG4gICAgdGhpcy5zZXRGaWVsZCh7IGZpZWxkR3JvdXAgfSk7XG4gIH1cbiAgZ2V0IGZpZWxkcygpOiBGb3JtbHlGaWVsZENvbmZpZ1tdIHtcbiAgICByZXR1cm4gdGhpcy5maWVsZC5maWVsZEdyb3VwO1xuICB9XG5cbiAgLyoqIE9wdGlvbnMgZm9yIHRoZSBmb3JtLiAqL1xuICBASW5wdXQoKVxuICBzZXQgb3B0aW9ucyhvcHRpb25zOiBGb3JtbHlGb3JtT3B0aW9ucykge1xuICAgIHRoaXMuc2V0RmllbGQoeyBvcHRpb25zIH0pO1xuICB9XG4gIGdldCBvcHRpb25zKCk6IEZvcm1seUZvcm1PcHRpb25zIHtcbiAgICByZXR1cm4gdGhpcy5maWVsZC5vcHRpb25zO1xuICB9XG5cbiAgLyoqIEV2ZW50IHRoYXQgaXMgZW1pdHRlZCB3aGVuIHRoZSBtb2RlbCB2YWx1ZSBpcyBjaGFuZ2VkICovXG4gIEBPdXRwdXQoKSBtb2RlbENoYW5nZSA9IG5ldyBFdmVudEVtaXR0ZXI8YW55PigpO1xuICBAQ29udGVudENoaWxkcmVuKEZvcm1seVRlbXBsYXRlKSBzZXQgdGVtcGxhdGVzKHRlbXBsYXRlczogUXVlcnlMaXN0PEZvcm1seVRlbXBsYXRlPikge1xuICAgIHRoaXMuZmllbGRUZW1wbGF0ZXMudGVtcGxhdGVzID0gdGVtcGxhdGVzO1xuICB9XG5cbiAgZmllbGQ6IEZvcm1seUZpZWxkQ29uZmlnQ2FjaGUgPSB7IHR5cGU6ICdmb3JtbHktZ3JvdXAnIH07XG4gIHByaXZhdGUgX21vZGVsQ2hhbmdlVmFsdWU6IGFueSA9IHt9O1xuICBwcml2YXRlIHZhbHVlQ2hhbmdlc1Vuc3Vic2NyaWJlID0gKCkgPT4ge307XG5cbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSBidWlsZGVyOiBGb3JtbHlGb3JtQnVpbGRlcixcbiAgICBwcml2YXRlIGNvbmZpZzogRm9ybWx5Q29uZmlnLFxuICAgIHByaXZhdGUgbmdab25lOiBOZ1pvbmUsXG4gICAgcHJpdmF0ZSBmaWVsZFRlbXBsYXRlczogRm9ybWx5RmllbGRUZW1wbGF0ZXMsXG4gICkge31cblxuICBuZ0RvQ2hlY2soKSB7XG4gICAgaWYgKHRoaXMuY29uZmlnLmV4dHJhcy5jaGVja0V4cHJlc3Npb25PbiA9PT0gJ2NoYW5nZURldGVjdGlvbkNoZWNrJykge1xuICAgICAgdGhpcy5jaGVja0V4cHJlc3Npb25DaGFuZ2UoKTtcbiAgICB9XG4gIH1cblxuICBuZ09uQ2hhbmdlcyhjaGFuZ2VzOiBTaW1wbGVDaGFuZ2VzKSB7XG4gICAgaWYgKGNoYW5nZXMuZmllbGRzICYmIHRoaXMuZm9ybSkge1xuICAgICAgY2xlYXJDb250cm9sKHRoaXMuZm9ybSk7XG4gICAgfVxuXG4gICAgaWYgKGNoYW5nZXMuZmllbGRzIHx8IGNoYW5nZXMuZm9ybSB8fCAoY2hhbmdlcy5tb2RlbCAmJiB0aGlzLl9tb2RlbENoYW5nZVZhbHVlICE9PSBjaGFuZ2VzLm1vZGVsLmN1cnJlbnRWYWx1ZSkpIHtcbiAgICAgIHRoaXMudmFsdWVDaGFuZ2VzVW5zdWJzY3JpYmUoKTtcbiAgICAgIHRoaXMuYnVpbGRlci5idWlsZCh0aGlzLmZpZWxkKTtcbiAgICAgIHRoaXMudmFsdWVDaGFuZ2VzVW5zdWJzY3JpYmUgPSB0aGlzLnZhbHVlQ2hhbmdlcygpO1xuICAgIH1cbiAgfVxuXG4gIG5nT25EZXN0cm95KCkge1xuICAgIHRoaXMudmFsdWVDaGFuZ2VzVW5zdWJzY3JpYmUoKTtcbiAgICB0aGlzLmNvbmZpZy5jbGVhclJlZnMoKTtcbiAgfVxuXG4gIHByaXZhdGUgY2hlY2tFeHByZXNzaW9uQ2hhbmdlKCkge1xuICAgIHRoaXMuZmllbGQub3B0aW9ucy5jaGVja0V4cHJlc3Npb25zPy4odGhpcy5maWVsZCk7XG4gIH1cblxuICBwcml2YXRlIHZhbHVlQ2hhbmdlcygpIHtcbiAgICB0aGlzLnZhbHVlQ2hhbmdlc1Vuc3Vic2NyaWJlKCk7XG5cbiAgICBsZXQgZm9ybUV2ZW50czogU3Vic2NyaXB0aW9uIHwgbnVsbCA9IG51bGw7XG4gICAgaWYgKGlzU2lnbmFsUmVxdWlyZWQoKSkge1xuICAgICAgbGV0IHN1Ym1pdHRlZCA9IHRoaXMub3B0aW9ucz8ucGFyZW50Rm9ybT8uc3VibWl0dGVkO1xuICAgICAgZm9ybUV2ZW50cyA9ICh0aGlzLmZvcm0gYXMgYW55KS5ldmVudHMuc3Vic2NyaWJlKCgpID0+IHtcbiAgICAgICAgaWYgKHN1Ym1pdHRlZCAhPT0gdGhpcy5vcHRpb25zPy5wYXJlbnRGb3JtPy5zdWJtaXR0ZWQpIHtcbiAgICAgICAgICB0aGlzLm9wdGlvbnMuZGV0ZWN0Q2hhbmdlcyh0aGlzLmZpZWxkKTtcbiAgICAgICAgICBzdWJtaXR0ZWQgPSB0aGlzLm9wdGlvbnM/LnBhcmVudEZvcm0/LnN1Ym1pdHRlZDtcbiAgICAgICAgfVxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgY29uc3QgZmllbGRDaGFuZ2VzRGV0ZWN0aW9uOiBhbnlbXSA9IFtcbiAgICAgIG9ic2VydmVEZWVwKHRoaXMuZmllbGQub3B0aW9ucywgWydmb3JtU3RhdGUnXSwgKCkgPT4gdGhpcy5maWVsZC5vcHRpb25zLmRldGVjdENoYW5nZXModGhpcy5maWVsZCkpLFxuICAgIF07XG4gICAgY29uc3QgdmFsdWVDaGFuZ2VzID0gdGhpcy5maWVsZC5vcHRpb25zLmZpZWxkQ2hhbmdlc1xuICAgICAgLnBpcGUoXG4gICAgICAgIGZpbHRlcigoeyBmaWVsZCwgdHlwZSB9KSA9PiBoYXNLZXkoZmllbGQpICYmIHR5cGUgPT09ICd2YWx1ZUNoYW5nZXMnKSxcbiAgICAgICAgc3dpdGNoTWFwKCgpID0+IChpc05vb3BOZ1pvbmUodGhpcy5uZ1pvbmUpID8gb2YobnVsbCkgOiB0aGlzLm5nWm9uZS5vblN0YWJsZS5hc09ic2VydmFibGUoKS5waXBlKHRha2UoMSkpKSksXG4gICAgICApXG4gICAgICAuc3Vic2NyaWJlKCgpID0+XG4gICAgICAgIHRoaXMubmdab25lLnJ1bkd1YXJkZWQoKCkgPT4ge1xuICAgICAgICAgIC8vIHJ1bkd1YXJkZWQgaXMgdXNlZCB0byBrZWVwIGluIHN5bmMgdGhlIGV4cHJlc3Npb24gY2hhbmdlc1xuICAgICAgICAgIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9uZ3gtZm9ybWx5L25neC1mb3JtbHkvaXNzdWVzLzIwOTVcbiAgICAgICAgICB0aGlzLmNoZWNrRXhwcmVzc2lvbkNoYW5nZSgpO1xuICAgICAgICAgIHRoaXMubW9kZWxDaGFuZ2UuZW1pdCgodGhpcy5fbW9kZWxDaGFuZ2VWYWx1ZSA9IGNsb25lKHRoaXMubW9kZWwpKSk7XG4gICAgICAgIH0pLFxuICAgICAgKTtcblxuICAgIHJldHVybiAoKSA9PiB7XG4gICAgICBmaWVsZENoYW5nZXNEZXRlY3Rpb24uZm9yRWFjaCgoZm5jKSA9PiBmbmMoKSk7XG4gICAgICBmb3JtRXZlbnRzPy51bnN1YnNjcmliZSgpO1xuICAgICAgdmFsdWVDaGFuZ2VzLnVuc3Vic2NyaWJlKCk7XG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgc2V0RmllbGQoZmllbGQ6IEZvcm1seUZpZWxkQ29uZmlnQ2FjaGUpIHtcbiAgICBpZiAodGhpcy5jb25maWcuZXh0cmFzLmltbXV0YWJsZSkge1xuICAgICAgdGhpcy5maWVsZCA9IHsgLi4udGhpcy5maWVsZCwgLi4uY2xvbmUoZmllbGQpIH07XG4gICAgfSBlbHNlIHtcbiAgICAgIE9iamVjdC5rZXlzKGZpZWxkKS5mb3JFYWNoKChwKSA9PiAoKHRoaXMuZmllbGQgYXMgYW55KVtwXSA9IChmaWVsZCBhcyBhbnkpW3BdKSk7XG4gICAgfVxuICB9XG59XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ2Zvcm1seS1mb3JtJyxcbiAgdGVtcGxhdGU6ICc8Zm9ybWx5LWZpZWxkIFtmaWVsZF09XCJmaWVsZFwiPjwvZm9ybWx5LWZpZWxkPicsXG4gIHByb3ZpZGVyczogW0Zvcm1seUZvcm1CdWlsZGVyLCBGb3JtbHlGaWVsZFRlbXBsYXRlc10sXG4gIGNoYW5nZURldGVjdGlvbjogQ2hhbmdlRGV0ZWN0aW9uU3RyYXRlZ3kuT25QdXNoLFxuICBzdGFuZGFsb25lOiBmYWxzZSxcbn0pXG5leHBvcnQgY2xhc3MgTGVnYWN5Rm9ybWx5Rm9ybSBleHRlbmRzIEZvcm1seUZvcm0ge31cbiJdfQ==