<div align="center">
  <a href="https://formly.dev">
    <img width="200" src="https://raw.githubusercontent.com/ngx-formly/ngx-formly/v5/logo.svg?sanitize=true" />
  </a>
  <br />
  JSON powered / Dynamic forms in Angular
  <br /><br />

  [![Npm version](https://badge.fury.io/js/%40ngx-formly%2Fcore.svg)](https://npmjs.org/package/@ngx-formly/core)
  [![Downloads](https://img.shields.io/npm/dm/@ngx-formly/core.svg)](https://npmjs.org/package/@ngx-formly/core)
  [![Gitter](https://badges.gitter.im/formly-js/ng2-formly.svg)](https://gitter.im/formly-js/ng2-formly)
  [![Build Status](https://github.com/ngx-formly/ngx-formly/actions/workflows/ci.yml/badge.svg?branch=main)](https://github.com/ngx-formly/ngx-formly/actions/workflows/ci.yml/badge.svg?branch=main)
  [![Twitter](https://img.shields.io/badge/twitter-@formlydev-blue.svg)](https://twitter.com/formlydev)
  [![Gitpod ready-to-code](https://img.shields.io/badge/Gitpod-ready--to--code-blue?logo=gitpod)](https://gitpod.io/#https://github.com/ngx-formly/ngx-formly)
</div>

---

Formly is a dynamic (JSON powered) form library for Angular that brings unmatched maintainability to your application's forms.

## Features

- 🔥 Automatic forms generation
- 📝 Easy to extend with custom field types, validation, wrappers and extensions.
- ⚡️ Supports multiple schemas:
    - Formly Schema (core)
    - JSON Schema
- 😍 A bunch of themes, out of the box!
- 💪 Built on top of [Angular Reactive Forms](https://angular.dev/guide/forms/reactive-forms)
- 📹 [@eggheadio course](https://egghead.io/playlists/configuration-based-reactive-angular-forms-with-ngx-formly-465f) - 20 lessons & 78 minutes

## Docs

- [Get Started](https://formly.dev/guide)
- [Themes](https://formly.dev/ui)
- [Examples](https://formly.dev/examples)

## Resources

- [How to auto-generate advanced forms using Formly](https://symflower.com/en/company/blog/2022/how-to-auto-generate-forms-with-formly)
- [Build Fast, JSON-Powered Forms on Angular With Ngx Formly](https://medium.com/better-programming/build-fast-json-powered-forms-on-angular-with-ngx-formly-b7a00733e66e?source=friends_link&sk=34fc6bdc71dd15fd255af18fb3280763)
- [How to Build Fast, Advanced JSON-Powered Forms on Angular With ngx-formly](https://medium.com/better-programming/how-to-build-fast-advanced-json-powered-forms-on-angular-with-ngx-formly-77aeed406f73?source=friends_link&sk=8d4f332458a46557778a3438e8f63581)

#### **Supported UI libs**

| UI                                                |                                                              |                                                                   |
| ------------------------------------------------- | ------------------------------------------------------------ | ----------------------------------------------------------------- |
| [Bootstrap](https://getbootstrap.com)             | [Demo](https://formly.dev/ui/bootstrap) | [StackBlitz](https://stackblitz.com/edit/ngx-formly-ui-bootstrap) |
| [Material2](https://github.com/angular/material2) | [Demo](https://formly.dev/ui/material)  | [StackBlitz](https://stackblitz.com/edit/ngx-formly-ui-material)  |
| [Ionic](https://ionicframework.com)               | [Demo](https://formly.dev/ui/ionic)     | [StackBlitz](https://stackblitz.com/edit/ngx-formly-ui-ionic)     |
| [PrimeNG](http://primefaces.org/primeng/#/)       | [Demo](https://formly.dev/ui/primeng)   | [StackBlitz](https://stackblitz.com/edit/ngx-formly-ui-primeng)   |
| [Kendo](http://www.telerik.com/kendo-angular-ui)  | [Demo](https://formly.dev/ui/kendo)     | [StackBlitz](https://stackblitz.com/edit/ngx-formly-ui-kendo)     |
| [NG-ZORRO](http://ng.ant.design) |     | [StackBlitz](https://stackblitz.com/edit/ngx-formly-ui-ng-zorro-antd)     |
| [NativeScript](https://www.nativescript.org)      | ||

#### **Which Version to use?**

| Angular version | Formly version         |
| --------------- | ---------------------- |
| Angular >= 18   | `@ngx-formly/core@7.x` |
| Angular >= 13   | `@ngx-formly/core@6.x` |
| Angular >= 7    | `@ngx-formly/core@5.x` |
| Angular >= 6    | `@ngx-formly/core@4.x` |
| Angular >= 5    | `@ngx-formly/core@3.x` |
| Angular >= 4    | `@ngx-formly/core@2.x` |
| Angular >= 2    | `ng-formly@1.x`        |

## Core Team

<table>
  <tr>
    <td align="center">
      <a href="https://github.com/aitboudad">
        <img src="https://avatars.githubusercontent.com/u/1753742?v=3" width="100px;" />
        <br />
        <sub><b>Abdellatif Ait boudad</b></sub>
      </a>
    </td>
    <td align="center">
      <a href="https://juri.dev">
        <img src="https://avatars.githubusercontent.com/u/542458" width="100px;" />
        <br />
        <sub><b>Juri Strumpflohner</b></sub>
      </a>
    </td>
    <td align="center">
      <a href="https://github.com/mohammedzamakhan">
        <img src="https://avatars.githubusercontent.com/u/2327532" width="100px;" />
        <br />
        <sub><b>Mohammed Zama Khan</b></sub>
      </a>
    </td>
    <td align="center">
      <a href="https://github.com/beeman">
        <img src="https://avatars.githubusercontent.com/u/36491" width="100px;" />
        <br />
        <sub><b>Bram Borggreve</b></sub>
      </a>
    </td>
    <td align="center">
      <a href="https://github.com/kenisteward">
        <img src="https://avatars.githubusercontent.com/u/12831669" width="100px;" />
        <br />
        <sub><b>Keni Steward</b></sub>
      </a>
    </td>
    <td align="center">
      <a href="https://github.com/MaxKless">
        <img src="https://avatars.githubusercontent.com/u/34165455" width="100px;" />
        <br />
        <sub><b>Max Kless</b></sub>
      </a>
    </td>
  </tr>
</table>

## Contributors

Thanks goes to these wonderful people:

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
[<img alt="aitboudad" src="https://avatars.githubusercontent.com/u/1753742?v=4&s=80" width="80">](https://github.com/aitboudad)[<img alt="mohammedzamakhan" src="https://avatars.githubusercontent.com/u/2327532?v=4&s=80" width="80">](https://github.com/mohammedzamakhan)[<img alt="divyakumarjain" src="https://avatars.githubusercontent.com/u/2039134?v=4&s=80" width="80">](https://github.com/divyakumarjain)[<img alt="MaxKless" src="https://avatars.githubusercontent.com/u/34165455?v=4&s=80" width="80">](https://github.com/MaxKless)[<img alt="couzic" src="https://avatars.githubusercontent.com/u/1380322?v=4&s=80" width="80">](https://github.com/couzic)[<img alt="juristr" src="https://avatars.githubusercontent.com/u/542458?v=4&s=80" width="80">](https://github.com/juristr)[<img alt="franzeal" src="https://avatars.githubusercontent.com/u/7455769?v=4&s=80" width="80">](https://github.com/franzeal)[<img alt="beeman" src="https://avatars.githubusercontent.com/u/36491?v=4&s=80" width="80">](https://github.com/beeman)

[<img alt="kenisteward" src="https://avatars.githubusercontent.com/u/12831669?v=4&s=80" width="80">](https://github.com/kenisteward)[<img alt="thorgod" src="https://avatars.githubusercontent.com/u/13910170?v=4&s=80" width="80">](https://github.com/thorgod)[<img alt="samtsai" src="https://avatars.githubusercontent.com/u/225526?v=4&s=80" width="80">](https://github.com/samtsai)[<img alt="luizfbicalho" src="https://avatars.githubusercontent.com/u/16882855?v=4&s=80" width="80">](https://github.com/luizfbicalho)[<img alt="klemenoslaj" src="https://avatars.githubusercontent.com/u/7548247?v=4&s=80" width="80">](https://github.com/klemenoslaj)[<img alt="FritzHerbers" src="https://avatars.githubusercontent.com/u/10029682?v=4&s=80" width="80">](https://github.com/FritzHerbers)[<img alt="dev-kanishk" src="https://avatars.githubusercontent.com/u/48204976?v=4&s=80" width="80">](https://github.com/dev-kanishk)[<img alt="vstiebe" src="https://avatars.githubusercontent.com/u/13326475?v=4&s=80" width="80">](https://github.com/vstiebe)

[<img alt="rpw1" src="https://avatars.githubusercontent.com/u/47835461?v=4&s=80" width="80">](https://github.com/rpw1)[<img alt="Devqon" src="https://avatars.githubusercontent.com/u/9316480?v=4&s=80" width="80">](https://github.com/Devqon)[<img alt="ryanjerskine" src="https://avatars.githubusercontent.com/u/5464778?v=4&s=80" width="80">](https://github.com/ryanjerskine)[<img alt="rehleinBo" src="https://avatars.githubusercontent.com/u/7338819?v=4&s=80" width="80">](https://github.com/rehleinBo)[<img alt="MarcosEllys" src="https://avatars.githubusercontent.com/u/6751242?v=4&s=80" width="80">](https://github.com/MarcosEllys)[<img alt="manuelmeister" src="https://avatars.githubusercontent.com/u/3001985?v=4&s=80" width="80">](https://github.com/manuelmeister)[<img alt="dolphinigle" src="https://avatars.githubusercontent.com/u/7020472?v=4&s=80" width="80">](https://github.com/dolphinigle)[<img alt="Lehoczky" src="https://avatars.githubusercontent.com/u/31937175?v=4&s=80" width="80">](https://github.com/Lehoczky)

[<img alt="Krustie101" src="https://avatars.githubusercontent.com/u/1636728?v=4&s=80" width="80">](https://github.com/Krustie101)[<img alt="intellix" src="https://avatars.githubusercontent.com/u/1162531?v=4&s=80" width="80">](https://github.com/intellix)[<img alt="skrtheboss" src="https://avatars.githubusercontent.com/u/10209728?v=4&s=80" width="80">](https://github.com/skrtheboss)[<img alt="dwaldrum" src="https://avatars.githubusercontent.com/u/386721?v=4&s=80" width="80">](https://github.com/dwaldrum)[<img alt="json-derulo" src="https://avatars.githubusercontent.com/u/18580672?v=4&s=80" width="80">](https://github.com/json-derulo)[<img alt="atsjo" src="https://avatars.githubusercontent.com/u/16601899?v=4&s=80" width="80">](https://github.com/atsjo)[<img alt="Cselt" src="https://avatars.githubusercontent.com/u/11027521?v=4&s=80" width="80">](https://github.com/Cselt)[<img alt="blowsie" src="https://avatars.githubusercontent.com/u/308572?v=4&s=80" width="80">](https://github.com/blowsie)

[<img alt="roshan-sama" src="https://avatars.githubusercontent.com/u/31125563?v=4&s=80" width="80">](https://github.com/roshan-sama)[<img alt="rternavskyi" src="https://avatars.githubusercontent.com/u/26190424?v=4&s=80" width="80">](https://github.com/rternavskyi)[<img alt="milasevicius" src="https://avatars.githubusercontent.com/u/1790265?v=4&s=80" width="80">](https://github.com/milasevicius)[<img alt="13dante04" src="https://avatars.githubusercontent.com/u/25120620?v=4&s=80" width="80">](https://github.com/13dante04)[<img alt="Riron" src="https://avatars.githubusercontent.com/u/5145523?v=4&s=80" width="80">](https://github.com/Riron)[<img alt="rbalet" src="https://avatars.githubusercontent.com/u/44493964?v=4&s=80" width="80">](https://github.com/rbalet)[<img alt="rafaelss95" src="https://avatars.githubusercontent.com/u/11965907?v=4&s=80" width="80">](https://github.com/rafaelss95)[<img alt="rammba" src="https://avatars.githubusercontent.com/u/40705899?v=4&s=80" width="80">](https://github.com/rammba)

[<img alt="Pouja" src="https://avatars.githubusercontent.com/u/2385144?v=4&s=80" width="80">](https://github.com/Pouja)[<img alt="OmkarJ13" src="https://avatars.githubusercontent.com/u/65808188?v=4&s=80" width="80">](https://github.com/OmkarJ13)[<img alt="NanFengCheong" src="https://avatars.githubusercontent.com/u/7321833?v=4&s=80" width="80">](https://github.com/NanFengCheong)[<img alt="Tom-V" src="https://avatars.githubusercontent.com/u/322654?v=4&s=80" width="80">](https://github.com/Tom-V)[<img alt="VyacheslavPritykin" src="https://avatars.githubusercontent.com/u/819457?v=4&s=80" width="80">](https://github.com/VyacheslavPritykin)[<img alt="akamyshanov" src="https://avatars.githubusercontent.com/u/1358330?v=4&s=80" width="80">](https://github.com/akamyshanov)[<img alt="danielcrisp" src="https://avatars.githubusercontent.com/u/1104814?v=4&s=80" width="80">](https://github.com/danielcrisp)[<img alt="francisco-sanchez-molina" src="https://avatars.githubusercontent.com/u/9049706?v=4&s=80" width="80">](https://github.com/francisco-sanchez-molina)

[<img alt="jazpearson" src="https://avatars.githubusercontent.com/u/7648154?v=4&s=80" width="80">](https://github.com/jazpearson)[<img alt="kapsiR" src="https://avatars.githubusercontent.com/u/7165033?v=4&s=80" width="80">](https://github.com/kapsiR)[<img alt="marfer" src="https://avatars.githubusercontent.com/u/1127166?v=4&s=80" width="80">](https://github.com/marfer)[<img alt="mburger81" src="https://avatars.githubusercontent.com/u/3778892?v=4&s=80" width="80">](https://github.com/mburger81)[<img alt="n3xus" src="https://avatars.githubusercontent.com/u/510213?v=4&s=80" width="80">](https://github.com/n3xus)[<img alt="neminovno" src="https://avatars.githubusercontent.com/u/1468887?v=4&s=80" width="80">](https://github.com/neminovno)[<img alt="sesidhar01" src="https://avatars.githubusercontent.com/u/61068911?v=4&s=80" width="80">](https://github.com/sesidhar01)[<img alt="vezzoo" src="https://avatars.githubusercontent.com/u/28898894?v=4&s=80" width="80">](https://github.com/vezzoo)

[<img alt="wenqi73" src="https://avatars.githubusercontent.com/u/23337087?v=4&s=80" width="80">](https://github.com/wenqi73)[<img alt="yoni333" src="https://avatars.githubusercontent.com/u/19931760?v=4&s=80" width="80">](https://github.com/yoni333)[<img alt="AlexTalcura" src="https://avatars.githubusercontent.com/u/20095773?v=4&s=80" width="80">](https://github.com/AlexTalcura)[<img alt="alex-novikov-1990" src="https://avatars.githubusercontent.com/u/6377930?v=4&s=80" width="80">](https://github.com/alex-novikov-1990)[<img alt="alvarolb" src="https://avatars.githubusercontent.com/u/1141353?v=4&s=80" width="80">](https://github.com/alvarolb)[<img alt="andmoredev" src="https://avatars.githubusercontent.com/u/33256364?v=4&s=80" width="80">](https://github.com/andmoredev)[<img alt="vitale232" src="https://avatars.githubusercontent.com/u/8504254?v=4&s=80" width="80">](https://github.com/vitale232)[<img alt="AmGarera" src="https://avatars.githubusercontent.com/u/6021169?v=4&s=80" width="80">](https://github.com/AmGarera)

[<img alt="atsjo" src="https://avatars.githubusercontent.com/u/16601899?v=4&s=80" width="80">](https://github.com/atsjo)[<img alt="bhaidar" src="https://avatars.githubusercontent.com/u/1163421?v=4&s=80" width="80">](https://github.com/bhaidar)[<img alt="cyrilletuzi" src="https://avatars.githubusercontent.com/u/555867?v=4&s=80" width="80">](https://github.com/cyrilletuzi)[<img alt="json-derulo" src="https://avatars.githubusercontent.com/u/18580672?v=4&s=80" width="80">](https://github.com/json-derulo)[<img alt="Dayvisson" src="https://avatars.githubusercontent.com/u/12189515?v=4&s=80" width="80">](https://github.com/Dayvisson)[<img alt="dereekb" src="https://avatars.githubusercontent.com/u/3586580?v=4&s=80" width="80">](https://github.com/dereekb)[<img alt="eduardoRoth" src="https://avatars.githubusercontent.com/u/5419161?v=4&s=80" width="80">](https://github.com/eduardoRoth)[<img alt="enricouniurb" src="https://avatars.githubusercontent.com/u/38656571?v=4&s=80" width="80">](https://github.com/enricouniurb)

[<img alt="erikvdv1" src="https://avatars.githubusercontent.com/u/2014802?v=4&s=80" width="80">](https://github.com/erikvdv1)[<img alt="fynnfeldpausch" src="https://avatars.githubusercontent.com/u/1246913?v=4&s=80" width="80">](https://github.com/fynnfeldpausch)[<img alt="jrgleason" src="https://avatars.githubusercontent.com/u/1319151?v=4&s=80" width="80">](https://github.com/jrgleason)[<img alt="johannesjo" src="https://avatars.githubusercontent.com/u/1456265?v=4&s=80" width="80">](https://github.com/johannesjo)[<img alt="johndbell" src="https://avatars.githubusercontent.com/u/1931322?v=4&s=80" width="80">](https://github.com/johndbell)[<img alt="jdpnielsen" src="https://avatars.githubusercontent.com/u/8746698?v=4&s=80" width="80">](https://github.com/jdpnielsen)[<img alt="TheMcMurder" src="https://avatars.githubusercontent.com/u/3059715?v=4&s=80" width="80">](https://github.com/TheMcMurder)[<img alt="LennardWesterveld" src="https://avatars.githubusercontent.com/u/1076589?v=4&s=80" width="80">](https://github.com/LennardWesterveld)

[<img alt="logvinoleg89" src="https://avatars.githubusercontent.com/u/12018303?v=4&s=80" width="80">](https://github.com/logvinoleg89)[<img alt="LucasJAlba" src="https://avatars.githubusercontent.com/u/2780076?v=4&s=80" width="80">](https://github.com/LucasJAlba)[<img alt="lucienbertin" src="https://avatars.githubusercontent.com/u/10089239?v=4&s=80" width="80">](https://github.com/lucienbertin)[<img alt="luizbicalhoagl" src="https://avatars.githubusercontent.com/u/93284446?v=4&s=80" width="80">](https://github.com/luizbicalhoagl)[<img alt="waffle-iron" src="https://avatars.githubusercontent.com/u/6912981?v=4&s=80" width="80">](https://github.com/waffle-iron)[<img alt="mathijshoogland" src="https://avatars.githubusercontent.com/u/7372934?v=4&s=80" width="80">](https://github.com/mathijshoogland)[<img alt="mrbusche" src="https://avatars.githubusercontent.com/u/792378?v=4&s=80" width="80">](https://github.com/mrbusche)[<img alt="mehranmb78" src="https://avatars.githubusercontent.com/u/144687844?v=4&s=80" width="80">](https://github.com/mehranmb78)
<!-- ALL-CONTRIBUTORS-LIST:END -->
