import { ErrorHandler, OnDestroy } from '@angular/core';
import { Action, ActionsSubject, ReducerObservable, ScannedActionsSubject, StateObservable } from '@ngrx/store';
import { Observable, Observer } from 'rxjs';
import { StoreDevtoolsConfig } from './config';
import { DevtoolsExtension } from './extension';
import { LiftedState } from './reducer';
import { DevtoolsDispatcher } from './devtools-dispatcher';
import * as i0 from "@angular/core";
export declare class StoreDevtools implements Observer<any>, OnDestroy {
    private liftedStateSubscription;
    private extensionStartSubscription;
    dispatcher: ActionsSubject;
    liftedState: Observable<LiftedState>;
    state: StateObservable;
    constructor(dispatcher: DevtoolsDispatcher, actions$: ActionsSubject, reducers$: ReducerObservable, extension: DevtoolsExtension, scannedActions: ScannedActionsSubject, errorHandler: ErrorHandler, initialState: any, config: StoreDevtoolsConfig);
    ngOnDestroy(): void;
    dispatch(action: Action): void;
    next(action: any): void;
    error(error: any): void;
    complete(): void;
    performAction(action: any): void;
    refresh(): void;
    reset(): void;
    rollback(): void;
    commit(): void;
    sweep(): void;
    toggleAction(id: number): void;
    jumpToAction(actionId: number): void;
    jumpToState(index: number): void;
    importState(nextLiftedState: any): void;
    lockChanges(status: boolean): void;
    pauseRecording(status: boolean): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<StoreDevtools, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<StoreDevtools>;
}
