"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.findRootPath = findRootPath;
const findUp = __importStar(require("find-up"));
const fs_1 = require("fs");
const path = __importStar(require("path"));
/**
 * Return root `turbo.json` file path if found, else return original input.
 *
 * @param turboPath existing turbo.json file path.
 * @throws {Error} if `turboPath` is not exist.
 */
function findTurboRootPath(turboPath) {
    // test if file content has `"extends": ["//"]`
    const isSubProject = (0, fs_1.readFileSync)(turboPath, "utf8").includes('"extends"');
    if (isSubProject) {
        const parent = path.dirname(path.dirname(turboPath));
        const rootPath = findUp.sync("turbo.json", { cwd: parent });
        if (rootPath)
            return rootPath;
    }
    return turboPath;
}
function findRootPath() {
    if (process.env.NX_WORKSPACE_ROOT) {
        return process.env.NX_WORKSPACE_ROOT;
    }
    let p = findUp.sync([
        "turbo.json",
        "turbo.jsonc",
        "nx.json", // Just in case NX_WORKSPACE_ROOT is not set
        "lerna.json",
        "pnpm-workspace.yaml",
    ]);
    if (p && p.endsWith("turbo.json")) {
        p = findTurboRootPath(p);
    }
    if (!p)
        p = findUp.sync(["package.json"]);
    return p ? path.dirname(p) : process.cwd();
}
//# sourceMappingURL=root.js.map