"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.plugin = void 0;
exports.env = env;
const chalk_1 = __importDefault(require("chalk"));
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const build_js_1 = require("./build.js");
const expand_js_1 = require("./expand.js");
const utils_js_1 = require("./utils.js");
const root_js_1 = require("./root.js");
function print(options, envPaths, values) {
    console.log("---------------------------------");
    if (options.root) {
        console.log(`${chalk_1.default.green("-")} Root directory: `, options.root);
    }
    if (options.runtime) {
        console.log(`${chalk_1.default.green("-")} Runtime: ✅`);
    }
    if (options.cwd) {
        console.log(`${chalk_1.default.green("-")} Working directory: `, options.cwd);
    }
    if (options.files) {
        console.log(`${chalk_1.default.green("-")} Files:`, options.files.join(", "));
    }
    console.log(`${chalk_1.default.green("-")} Environment:`, options.environment ? options.environment : chalk_1.default.red("none"));
    if (envPaths.length === 0) {
        console.log(`${chalk_1.default.green("-")} Environment files: ${chalk_1.default.red("none")}`);
    }
    else {
        console.log(`${chalk_1.default.green("-")} Environment files: `);
        envPaths.forEach((envPath) => {
            console.log(`${chalk_1.default.green(" ✔")} ${envPath}`);
        });
    }
    if (Object.keys(values).length > 0 && options.prefix) {
        console.log(`${chalk_1.default.green("-")} Environment variables: ${chalk_1.default.yellow(options.prefix) ?? ""} ${options.unsecure ? chalk_1.default.red("(Unsecure Mode)") : ""}`);
        for (const key in values) {
            if (options.unsecure) {
                console.log(`${chalk_1.default.green(" ✔")} ${chalk_1.default.yellow(key)} ${values[key]}`);
            }
            else {
                console.log(`${chalk_1.default.green(" ✔")} ${chalk_1.default.yellow(key)}`);
            }
        }
    }
    console.log("---------------------------------\n");
}
function filter(env, prefix, nodeEnv) {
    return Object.keys(env)
        .filter((key) => env[key] !== undefined &&
        ((nodeEnv && key === "NODE_ENV") || prefix.test(key)))
        .sort() // sort keys to make output more deterministic
        .reduce((env, key) => {
        env[key] = process.env[key];
        return env;
    }, {});
}
function buildEnvFiles(environment, envPath) {
    return [
        environment !== "test" && `${envPath}.${environment}.local`, // .env.development.local, .env.test.local, .env.production.local
        // Don't include `.env.local` for `test` environment
        // since normally you expect tests to produce the same
        // results for everyone
        environment && `${envPath}.${environment}`, // .env.development, .env.test, .env.production
        environment !== "test" && `${envPath}.local`, // .env.local
        envPath, // .env
    ].filter(Boolean);
}
function paths({ environment, root, cwd, files }) {
    let envFiles = Array.isArray(files) ? files : [files];
    let _root = root;
    if (root) {
        _root = (0, utils_js_1.getAbsoluteEnvPath)(root, cwd);
        const envPaths = (0, utils_js_1.isSubfolder)(_root, cwd)
            ? [_root]
            : (0, utils_js_1.getPathsDownTo)(_root, cwd);
        const uniqueEnvFiles = Array.from(new Set(envFiles));
        envFiles = envPaths.flatMap((envPath) => uniqueEnvFiles.map((envFile) => path.join(envPath, envFile)));
    }
    const _files = envFiles
        .map((envPath) => path.resolve(cwd, envPath))
        .flatMap((envPath) => buildEnvFiles(environment, envPath))
        .filter((envPath) => fs.existsSync(envPath));
    return {
        root: _root,
        files: _files,
    };
}
function env({ cwd = process.cwd(), environment = process.env.NODE_ENV, files = [".env"], dotenv, prefix, verbose, nodeEnv = true, builtIn = {}, runtime = false, define, global = "__env__", unsecure, root, } = {}) {
    const options = {
        cwd,
        environment,
        files,
        dotenv,
        prefix,
        verbose,
        nodeEnv,
        unsecure,
        root: root ?? (0, root_js_1.findRootPath)(),
    };
    const { root: _root, files: envPaths } = paths(options);
    (0, expand_js_1.expand)(envPaths, dotenv);
    const processEnv = process.env;
    const values = prefix
        ? filter(processEnv, typeof prefix === "string" ? new RegExp(prefix, "i") : prefix, nodeEnv)
        : processEnv;
    const allValues = { ...values, ...builtIn };
    if (verbose) {
        print({ ...options, root: _root }, envPaths, allValues);
    }
    return (0, build_js_1.build)(allValues, runtime, global, define);
}
exports.plugin = env;
//# sourceMappingURL=env.js.map