"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RULE_NAME = void 0;
const utils_1 = require("@angular-eslint/utils");
const create_eslint_rule_1 = require("../utils/create-eslint-rule");
exports.RULE_NAME = 'prefer-host-metadata-property';
exports.default = (0, create_eslint_rule_1.createESLintRule)({
    name: exports.RULE_NAME,
    meta: {
        type: 'suggestion',
        docs: {
            description: 'Use `host` metadata property instead of `@HostBinding` and `HostListener`',
        },
        schema: [],
        messages: {
            preferHostMetadataPropertyForBinding: 'Prefer using the `host` metadata property in the `@Component` decorator for host bindings instead of the `@HostBinding` decorator.',
            preferHostMetadataPropertyForListener: 'Prefer using the `host` metadata property in the `@Component` decorator for host listeners instead of the `@HostListener` decorator.',
        },
    },
    defaultOptions: [],
    create(context) {
        return {
            [utils_1.Selectors.HOST_BINDING_DECORATOR]: (node) => {
                context.report({
                    node,
                    messageId: 'preferHostMetadataPropertyForBinding',
                });
            },
            [utils_1.Selectors.HOST_LISTENER_DECORATOR]: (node) => {
                context.report({
                    node,
                    messageId: 'preferHostMetadataPropertyForListener',
                });
            },
        };
    },
});
