class m{constructor(t){this.rules=[],this.saveQueue=Promise.resolve(),this.initError=null,this.plugin=t,this.initPromise=this.loadRules()}async loadRules(){try{const t=await this.plugin.loadSyncedData();if(t){let e;try{e=JSON.parse(t)}catch{this.initError=new Error("Corrupted JSON in automation rules"),this.plugin.log.warn("Corrupted JSON in automation rules, resetting.")}if(e){const i=this.validateRules(e);if(i){this.rules=i;return}this.initError=new Error("Persisted automation rules are invalid"),this.plugin.log.warn("Persisted automation rules are invalid, resetting to defaults.")}}this.initDefaultRules(),await this.saveRules()}catch(t){this.initError=t instanceof Error?t:new Error(String(t)),this.plugin.log.error("Failed to load rules",t),this.initDefaultRules(),await this.saveRules()}}initDefaultRules(){this.rules=[]}getInitializationError(){return this.initError}validateRules(t){if(!Array.isArray(t))return null;const e=new Set(["taskCompleted","taskCreated","taskUpdated","timeBased"]),i=new Set(["titleContains","projectIs","hasTag","weekdayIs"]),a=new Set(["createTask","addTag","displaySnack","displayDialog","webhook"]),r=n=>n&&typeof n=="object"&&typeof n.type=="string"&&i.has(n.type)&&typeof n.value=="string",c=n=>n&&typeof n=="object"&&typeof n.type=="string"&&a.has(n.type)&&typeof n.value=="string";for(const n of t){if(!n||typeof n!="object")return null;const l=n;if(typeof l.id!="string"||typeof l.name!="string"||typeof l.isEnabled!="boolean"||!l.trigger||typeof l.trigger!="object"||!e.has(l.trigger.type)||!Array.isArray(l.conditions)||l.conditions.some(h=>!r(h))||!Array.isArray(l.actions)||l.actions.some(h=>!c(h)))return null}return t}async saveRules(){this.saveQueue=this.saveQueue.then(async()=>{try{await this.plugin.persistDataSynced(JSON.stringify(this.rules))}catch(t){this.plugin.log.error("Failed to save rules",t)}}).catch(()=>{this.plugin.log.error("Critical error in save queue")}),await this.saveQueue}async getRules(){return await this.initPromise,this.rules}async getEnabledRules(){return await this.initPromise,this.rules.filter(t=>t.isEnabled)}async addOrUpdateRule(t){await this.initPromise,this.saveQueue=this.saveQueue.then(async()=>{const e=this.rules.findIndex(i=>i.id===t.id);e!==-1?this.rules[e]=t:this.rules.push(t);try{await this.plugin.persistDataSynced(JSON.stringify(this.rules))}catch(i){this.plugin.log.error("Failed to save rules",i)}}),await this.saveQueue}async deleteRule(t){await this.initPromise,this.saveQueue=this.saveQueue.then(async()=>{this.rules=this.rules.filter(e=>e.id!==t);try{await this.plugin.persistDataSynced(JSON.stringify(this.rules))}catch(e){this.plugin.log.error("Failed to save rules",e)}}),await this.saveQueue}async toggleRuleStatus(t,e){await this.initPromise,this.saveQueue=this.saveQueue.then(async()=>{const i=this.rules.find(a=>a.id===t);if(i){i.isEnabled=e;try{await this.plugin.persistDataSynced(JSON.stringify(this.rules))}catch(a){this.plugin.log.error("Failed to save rules",a)}}}),await this.saveQueue}}class f{constructor(t,e,i){this.plugin=t,this.registry=e,this.dataCache=i}async allConditionsMatch(t,e){for(const i of t)if(!await this.checkCondition(i,e))return!1;return!0}async checkCondition(t,e){const i=this.registry.getCondition(t.type);if(!i)return!1;const a={plugin:this.plugin,dataCache:this.dataCache};return i.check(a,e,t.value)}}class k{constructor(t,e,i){this.plugin=t,this.registry=e,this.dataCache=i}async executeAll(t,e){for(const i of t)await this.executeAction(i,e)}async executeAction(t,e){const i=this.registry.getAction(t.type);if(!i){this.plugin.log.warn(`[Automation] Unknown action type: ${t.type}`);return}const a={plugin:this.plugin,dataCache:this.dataCache};try{await i.execute(a,e,t.value)}catch(r){this.plugin.log.error(`[Automation] Action ${t.type} failed: ${r}`)}}}const w=(s,t)=>{let e;const i=()=>{e=setTimeout(i,t),s.call(null)};return e=setTimeout(i,t),()=>{clearTimeout(e)}};class C{constructor(t=5,e=1e3){this.executions=new Map,this.limit=t,this.windowMs=e}check(t){const e=Date.now(),a=(this.executions.get(t)||[]).filter(r=>e-r<this.windowMs);return a.length>=this.limit?!1:(a.push(e),this.executions.set(t,a),!0)}reset(t){this.executions.delete(t)}}class T{constructor(){this.triggers=new Map,this.conditions=new Map,this.actions=new Map}registerTrigger(t){this.triggers.set(t.id,t)}getTrigger(t){return this.triggers.get(t)}getTriggers(){return Array.from(this.triggers.values())}registerCondition(t){this.conditions.set(t.id,t)}getCondition(t){return this.conditions.get(t)}getConditions(){return Array.from(this.conditions.values())}registerAction(t){this.actions.set(t.id,t)}getAction(t){return this.actions.get(t)}getActions(){return Array.from(this.actions.values())}}const o=new T,A={id:"taskCompleted",name:"Task Completed",matches:s=>s.type==="taskCompleted"},R={id:"taskCreated",name:"Task Created",matches:s=>s.type==="taskCreated"},E={id:"taskUpdated",name:"Task Updated",matches:s=>s.type==="taskUpdated"},S={id:"timeBased",name:"Time Based",matches:s=>s.type==="timeBased"},I={id:"titleContains",name:"Title contains",check:async(s,t,e)=>!t.task||!e?!1:t.task.title.toLowerCase().includes(e.toLowerCase())},D={id:"projectIs",name:"Project is",check:async(s,t,e)=>{if(!t.task||!t.task.projectId||!e)return!1;const a=(await s.dataCache.getProjects()).find(r=>r.id===t.task?.projectId);return a?a.title===e:!1}},v={id:"hasTag",name:"Has tag",check:async(s,t,e)=>{if(!t.task||!t.task.tagIds||!e)return!1;const a=(await s.dataCache.getTags()).find(r=>r.title===e);return a?t.task.tagIds.includes(a.id):!1}},b={id:"weekdayIs",name:"Weekday is",description:'Checks if the current day is one of the specified days (e.g. "Monday", "Mon,Tue")',check:async(s,t,e)=>{if(!e)return!1;const i=["sunday","monday","tuesday","wednesday","thursday","friday","saturday"],a=new Date().getDay(),r=i[a];return e.toLowerCase().split(",").map(n=>n.trim()).some(n=>n.length<3?!1:n===r||r.startsWith(n)&&n.length===3)}},j={id:"createTask",name:"Create Task",execute:async(s,t,e)=>{e&&(await s.plugin.addTask({title:e,projectId:t.task?.projectId}),s.plugin.log.info(`[Automation] Action: Created task "${e}"`))}},M={id:"addTag",name:"Add Tag",execute:async(s,t,e)=>{if(!t.task||!e){s.plugin.log.warn(`[Automation] Cannot add tag "${e}" without task context.`);return}let a=(await s.dataCache.getTags()).find(r=>r.title===e)?.id;if(!a){s.plugin.log.warn(`[Automation] Tag "${e}" not found.`);return}t.task.tagIds.includes(a)||(await s.plugin.updateTask(t.task.id,{tagIds:[...t.task.tagIds,a]}),s.plugin.log.info(`[Automation] Action: Added tag "${e}"`))}},$={id:"displaySnack",name:"Display Snack",execute:async(s,t,e)=>{e&&(s.plugin.showSnack({msg:e,type:"SUCCESS"}),s.plugin.log.info(`[Automation] Action: Displayed snack "${e}"`))}},x={id:"displayDialog",name:"Display Dialog",execute:async(s,t,e)=>{if(!e)return;const i=e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;");await s.plugin.openDialog({htmlContent:`<p>${i}</p>`,buttons:[{label:"OK",onClick:()=>{}}]}),s.plugin.log.info(`[Automation] Action: Displayed dialog "${e}"`)}},L={id:"webhook",name:"Webhook",execute:async(s,t,e)=>{if(!e)return;if(!e.startsWith("http://")&&!e.startsWith("https://")){s.plugin.log.warn(`[Automation] Invalid webhook URL: "${e}". Must start with http:// or https://`);return}const i={type:t.type,task:t.task?{id:t.task.id,title:t.task.title,projectId:t.task.projectId,isDone:t.task.isDone,tagIds:t.task.tagIds}:void 0};try{const a=new AbortController,r=setTimeout(()=>a.abort(),5e3);await fetch(e,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(i),signal:a.signal}),clearTimeout(r),s.plugin.log.info(`[Automation] Action: Webhook sent to "${e}"`)}catch(a){s.plugin.log.error(`[Automation] Webhook failed: ${a}`)}}},d=class d{constructor(t){this.plugin=t,this.projectsCache=null,this.tagsCache=null}async getProjects(){const t=Date.now();if(this.projectsCache&&t-this.projectsCache.timestamp<d.CACHE_TTL_MS)return this.projectsCache.data;const e=await this.plugin.getAllProjects();return this.projectsCache={data:e,timestamp:t},e}async getTags(){const t=Date.now();if(this.tagsCache&&t-this.tagsCache.timestamp<d.CACHE_TTL_MS)return this.tagsCache.data;const e=await this.plugin.getAllTags();return this.tagsCache={data:e,timestamp:t},e}invalidate(){this.projectsCache=null,this.tagsCache=null}};d.CACHE_TTL_MS=6e4;let p=d;const u=class u{constructor(t){this.plugin=t,this.pendingDialogs=new Set,this.lastExecutionTimes=new Map,this.registerDefaults(),this.dataCache=new p(t),this.ruleRegistry=new m(t),this.conditionEvaluator=new f(t,o,this.dataCache),this.actionExecutor=new k(t,o,this.dataCache),this.rateLimiter=new C(u.RATE_LIMIT_MAX,u.RATE_LIMIT_WINDOW_MS),this.initTimeCheck()}registerDefaults(){o.registerTrigger(A),o.registerTrigger(R),o.registerTrigger(E),o.registerTrigger(S),o.registerCondition(I),o.registerCondition(D),o.registerCondition(v),o.registerCondition(b),o.registerAction(j),o.registerAction(M),o.registerAction($),o.registerAction(x),o.registerAction(L)}initTimeCheck(){this.clearTimeCheck=w(()=>{this.checkTimeBasedRules()},u.CHECK_INTERVAL_MS)}destroy(){this.clearTimeCheck&&(this.clearTimeCheck(),this.clearTimeCheck=void 0)}async checkTimeBasedRules(){try{const t=await this.ruleRegistry.getEnabledRules();this.syncExecutionTimes(t.map(c=>c.id));const e=new Date,i=e.getHours(),a=e.getMinutes(),r=`${i.toString().padStart(2,"0")}:${a.toString().padStart(2,"0")}`;for(const c of t)try{if(c.trigger.type!=="timeBased"||!c.trigger.value)continue;if(c.trigger.value===r){const n=this.lastExecutionTimes.get(c.id)||0;if(e.getTime()-n<u.TIME_RULE_COOLDOWN_MS)continue;const l={type:"timeBased",task:void 0};if(!await this.conditionEvaluator.allConditionsMatch(c.conditions,l))continue;this.lastExecutionTimes.set(c.id,e.getTime()),this.plugin.log.info(`[Automation] Time-based rule matched: ${c.name}`),await this.actionExecutor.executeAll(c.actions,{type:"timeBased"})}}catch(n){this.plugin.log.error(`[Automation] Error processing time-based rule ${c.name}: ${n}`)}}catch(t){this.plugin.log.error(`[Automation] Error in checkTimeBasedRules: ${t}`)}}syncExecutionTimes(t){const e=new Set(t);for(const i of this.lastExecutionTimes.keys())e.has(i)||this.lastExecutionTimes.delete(i)}async onTaskEvent(t){if(!t.task){this.plugin.log.warn(`[Automation] Event ${t.type} received without task data`);return}this.plugin.log.info(`[Automation] Event received: ${t.type}`,t.task.title);try{const e=await this.ruleRegistry.getEnabledRules();for(const i of e)try{const a=o.getTrigger(i.trigger.type);if(!a||!a.matches(t,i.trigger.value)||!await this.conditionEvaluator.allConditionsMatch(i.conditions,t))continue;if(!this.rateLimiter.check(i.id)){if(this.plugin.log.warn(`[Automation] Rate limit exceeded for rule: ${i.name}`),!this.pendingDialogs.has(i.id)){this.pendingDialogs.add(i.id);const c={htmlContent:`
              <h3>High Automation Activity Detected</h3>
              <p>The rule <strong>"${this.escapeHtml(i.name)}"</strong> is triggering too frequently (infinite loop protection).</p>
              <p>Do you want to disable this rule or continue execution?</p>
            `,buttons:[{label:"Disable Rule",color:"warn",onClick:async()=>{await this.ruleRegistry.toggleRuleStatus(i.id,!1),this.plugin.showSnack({msg:`Rule "${i.name}" disabled`,type:"INFO"}),this.pendingDialogs.delete(i.id)}},{label:"Continue",color:"primary",onClick:()=>{this.rateLimiter.reset(i.id),this.pendingDialogs.delete(i.id)}}]};await this.plugin.openDialog(c)}continue}this.plugin.log.info(`[Automation] Rule matched: ${i.name}`),await this.actionExecutor.executeAll(i.actions,t)}catch(a){this.plugin.log.error(`[Automation] Error processing rule ${i.name}: ${a}`)}}catch(e){this.plugin.log.error(`[Automation] Error in onTaskEvent: ${e}`)}}escapeHtml(t){return t.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")}getRegistry(){return this.ruleRegistry}};u.RATE_LIMIT_MAX=5,u.RATE_LIMIT_WINDOW_MS=1e3,u.CHECK_INTERVAL_MS=1e4,u.TIME_RULE_COOLDOWN_MS=6e4;let y=u;plugin.log.info("Automation plugin initialized");const g=new y(plugin);plugin.registerHook("taskCreated",s=>{if(!s.task){plugin.log.warn("Received taskCreated hook without task data");return}g.onTaskEvent({type:"taskCreated",task:s.task})});plugin.registerHook("taskComplete",s=>{if(!s.task){plugin.log.warn("Received taskComplete hook without task data");return}g.onTaskEvent({type:"taskCompleted",task:s.task})});plugin.registerHook("taskUpdate",s=>{if(!s.task){plugin.log.warn("Received taskUpdate hook without task data");return}g.onTaskEvent({type:"taskUpdated",task:s.task,previousTaskState:void 0})});plugin.onMessage&&plugin.onMessage(async s=>{switch(s?.type){case"getRules":return await g.getRegistry().getRules();case"getDefinitions":return{triggers:o.getTriggers().map(t=>({id:t.id,name:t.name,description:t.description})),conditions:o.getConditions().map(t=>({id:t.id,name:t.name,description:t.description})),actions:o.getActions().map(t=>({id:t.id,name:t.name,description:t.description}))};case"saveRule":return await g.getRegistry().addOrUpdateRule(s.payload),{success:!0};case"deleteRule":return await g.getRegistry().deleteRule(s.payload.id),{success:!0};case"toggleRuleStatus":return await g.getRegistry().toggleRuleStatus(s.payload.id,s.payload.isEnabled),{success:!0};case"getProjects":return await plugin.getAllProjects();case"getTags":return await plugin.getAllTags();case"downloadFile":return await plugin.downloadFile(s.payload.filename,s.payload.data),{success:!0};default:return{error:"Unknown message type"}}});
