'use strict';

var _url = require('url');
var absolutify = require('../absolutify');

var baseUrl = 'http://demo.com';
var content = '<a href="../../blog/demo-interview">check out</a></p>';


function resolveUrls (baseUrl, content) {
  return absolutify(content, function (url, attrName) {
    if (attrName === 'href') {
      console.log('resolving', _url.resolve(baseUrl, url), baseUrl, url);
      return _url.resolve(baseUrl, url);
    }

    return url;
  });
}


console.log('default: ', absolutify(content, baseUrl))
console.log('function: ', absolutify(content, function(url, attr) {
  return baseUrl + '/' + url
}))
console.log('resolveUrls', resolveUrls(baseUrl, content));




var content = '<a href="#demo">demo</a></p>'
console.log('ANCHOR: ', absolutify(content, baseUrl))