function(
   r       // Given HTML string to replace
  ,u       // URL to prepend to all relative ones
  ){
  return r.replace(
    // The following regex looks for the patterns of:
    //
    // `attr='/*'`
    // `attr="/*"`
    // `attr="../*"`
    //
    // And negates any with the pattern of:
    //
    // `attr="//"`
    //
    // Capture groups:
    //
    //  $1 - (attr=")
    //  $2 - (attr)
    //  $3 - ignored
    //  $4 - (url)
    /((href|src|action|formaction)=["'])(([.]+\/)|(?:\/))(?!\/)/g

  , "$1"    // First capture group, `attr="`, rebuild the start of the matched string
    + u     // Place the given url at begging of value
    + "/$4" // Append relative URL, rebuilding the end of the matched string
  )
}
