import { AutoReviewSectionConfig } from "../../types";
export type Output = {
    tag: string;
    isRequired: boolean;
};
export type OutputsMapping = Record<string, Output>;
type ExtractedType<M extends OutputsMapping> = {
    [K in keyof M]: M[K]["isRequired"] extends true ? string : string | "";
};
declare const BASE_AUTOPILOT_STEP: {
    screenDescription: {
        tag: string;
        isRequired: boolean;
    };
    thoughts: {
        tag: string;
        isRequired: boolean;
    };
    action: {
        tag: string;
        isRequired: boolean;
    };
    goalSummary: {
        tag: string;
        isRequired: boolean;
    };
};
declare const AUTOPILOT_REVIEW_SECTION: {
    summary: {
        tag: string;
        isRequired: boolean;
    };
    findings: {
        tag: string;
        isRequired: boolean;
    };
    score: {
        tag: string;
        isRequired: boolean;
    };
};
/**
 * Extracts review outputs (summary, findings, score) from text with review tags
 */
export declare function extractAutoPilotReviewOutputs(text: string): ExtractedType<typeof AUTOPILOT_REVIEW_SECTION>;
/**
 * Extracts autopilot step outputs including dynamic review sections
 */
export declare function extractAutoPilotStepOutputs(text: string, reviewTypes?: AutoReviewSectionConfig[]): ExtractedType<typeof BASE_AUTOPILOT_STEP> & Record<string, string | undefined>;
export declare function extractPilotOutputs(text: string): {
    code: string;
    cacheValidationMatcher: string;
};
export {};
