/**
 * Ensures minimum staleTime and cacheTime values when suspense is enabled.
 * Despite the name, this function guards both staleTime and cacheTime to prevent
 * infinite re-render loops with synchronous queries.
 *
 * @deprecated in v5 - replaced by ensureSuspenseTimers
 */
const ensureStaleTime = defaultedOptions => {
  if (defaultedOptions.suspense) {
    // Always set stale time when using suspense to prevent
    // fetching again when directly mounting after suspending
    if (typeof defaultedOptions.staleTime !== 'number') {
      defaultedOptions.staleTime = 1000;
    }

    if (typeof defaultedOptions.cacheTime === 'number') {
      defaultedOptions.cacheTime = Math.max(defaultedOptions.cacheTime, 1000);
    }
  }
};
const willFetch = (result, isRestoring) => result.isLoading && result.isFetching && !isRestoring;
const shouldSuspend = (defaultedOptions, result, isRestoring) => (defaultedOptions == null ? void 0 : defaultedOptions.suspense) && willFetch(result, isRestoring);
const fetchOptimistic = (defaultedOptions, observer, errorResetBoundary) => observer.fetchOptimistic(defaultedOptions).then(({
  data
}) => {
  defaultedOptions.onSuccess == null ? void 0 : defaultedOptions.onSuccess(data);
  defaultedOptions.onSettled == null ? void 0 : defaultedOptions.onSettled(data, null);
}).catch(error => {
  errorResetBoundary.clearReset();
  defaultedOptions.onError == null ? void 0 : defaultedOptions.onError(error);
  defaultedOptions.onSettled == null ? void 0 : defaultedOptions.onSettled(undefined, error);
});

export { ensureStaleTime, fetchOptimistic, shouldSuspend, willFetch };
//# sourceMappingURL=suspense.esm.js.map
