/// <reference types="./trigger-query-creator.d.ts" />
import { createSelectQueryBuilder, } from './query-builder/select-query-builder.js';
import { InsertQueryBuilder } from './query-builder/insert-query-builder.js';
import { DeleteQueryBuilder } from './query-builder/delete-query-builder.js';
import { UpdateQueryBuilder } from './query-builder/update-query-builder.js';
import { DeleteQueryNode } from './operation-node/delete-query-node.js';
import { InsertQueryNode } from './operation-node/insert-query-node.js';
import { SelectQueryNode } from './operation-node/select-query-node.js';
import { UpdateQueryNode } from './operation-node/update-query-node.js';
import { parseTable, parseTableExpression, parseTableExpressionOrList, } from './parser/table-parser.js';
import { createQueryId } from './util/query-id.js';
import { freeze } from './util/object-utils.js';
import { parseSelectArg, } from './parser/select-parser.js';
export class TriggerQueryCreator {
    #props;
    constructor(props) {
        this.#props = freeze(props);
    }
    selectFrom(from) {
        return createSelectQueryBuilder({
            queryId: createQueryId(),
            executor: this.#props.executor,
            queryNode: SelectQueryNode.createFrom(parseTableExpressionOrList(from), this.#props.withNode),
        });
    }
    selectNoFrom(selection) {
        return createSelectQueryBuilder({
            queryId: createQueryId(),
            executor: this.#props.executor,
            queryNode: SelectQueryNode.cloneWithSelections(SelectQueryNode.create(this.#props.withNode), parseSelectArg(selection)),
        });
    }
    insertInto(table) {
        return new InsertQueryBuilder({
            queryId: createQueryId(),
            executor: this.#props.executor,
            queryNode: InsertQueryNode.create(parseTable(table), this.#props.withNode),
        });
    }
    replaceInto(table) {
        return new InsertQueryBuilder({
            queryId: createQueryId(),
            executor: this.#props.executor,
            queryNode: InsertQueryNode.create(parseTable(table), this.#props.withNode, true),
        });
    }
    deleteFrom(tables) {
        return new DeleteQueryBuilder({
            queryId: createQueryId(),
            executor: this.#props.executor,
            queryNode: DeleteQueryNode.create(parseTableExpressionOrList(tables), this.#props.withNode),
        });
    }
    updateTable(table) {
        return new UpdateQueryBuilder({
            queryId: createQueryId(),
            executor: this.#props.executor,
            queryNode: UpdateQueryNode.create(parseTableExpression(table), this.#props.withNode),
        });
    }
    withPlugin(plugin) {
        return new TriggerQueryCreator({
            ...this.#props,
            executor: this.#props.executor.withPlugin(plugin),
        });
    }
    withoutPlugins() {
        return new TriggerQueryCreator({
            ...this.#props,
            executor: this.#props.executor.withoutPlugins(),
        });
    }
}
