/// <reference types="./drop-trigger-builder.d.ts" />
import { preventAwait } from '../util/prevent-await.js';
import { freeze } from '../util/object-utils.js';
import { DropTriggerNode } from '../operation-node/drop-trigger-node.js';
export class DropTriggerBuilder {
    #props;
    constructor(props) {
        this.#props = freeze(props);
    }
    ifExists() {
        return new DropTriggerBuilder({
            ...this.#props,
            node: DropTriggerNode.cloneWith(this.#props.node, {
                ifExists: true,
            }),
        });
    }
    cascade() {
        return new DropTriggerBuilder({
            ...this.#props,
            node: DropTriggerNode.cloneWith(this.#props.node, {
                cascade: true,
            }),
        });
    }
    /**
     * Simply calls the provided function passing `this` as the only argument. `$call` returns
     * what the provided function returns.
     */
    $call(func) {
        return func(this);
    }
    toOperationNode() {
        return this.#props.executor.transformQuery(this.#props.node, this.#props.queryId);
    }
    compile() {
        return this.#props.executor.compileQuery(this.toOperationNode(), this.#props.queryId);
    }
    async execute() {
        await this.#props.executor.executeQuery(this.compile(), this.#props.queryId);
    }
}
preventAwait(DropTriggerBuilder, "don't await DropTriggerBuilder instances directly. To execute the query you need to call `execute`");
