import { CreateTriggerNode } from '../operation-node/create-trigger-node.js';
import { OperationNodeSource } from '../operation-node/operation-node-source.js';
import { ComparisonOperatorExpression, OperandValueExpressionOrList } from '../parser/binary-operation-parser.js';
import { ReferenceExpression } from '../parser/reference-parser.js';
import { CompiledQuery } from '../query-compiler/compiled-query.js';
import { QueryExecutor } from '../query-executor/query-executor.js';
import { Compilable } from '../util/compilable.js';
import { QueryId } from '../util/query-id.js';
import { AnyColumn, AnyColumnWithTable, SqlBool } from '../util/type-utils.js';
import { TriggerEvent } from '../operation-node/trigger-event-node.js';
import { ExpressionOrFactory } from '../parser/expression-parser.js';
import { TriggerQueryCreator } from '../trigger-query-creator.js';
export type DatabaseWithOldNewTables<DB, TB extends keyof DB> = DB & {
    old: DB[TB];
    new: DB[TB];
};
/**
 * This builder can be used to create a `create table` query.
 */
export declare class CreateTriggerBuilder<DB, TB extends keyof DB> implements OperationNodeSource, Compilable {
    #private;
    constructor(props: CreateTriggerBuilderProps);
    before(): CreateTriggerBuilder<DB, TB>;
    after(): CreateTriggerBuilder<DB, TB>;
    insteadOf(): CreateTriggerBuilder<DB, TB>;
    addEvent<E extends TriggerEvent>(event: E, columns?: E extends 'update' ? AnyColumn<DB, TB>[] : never[]): CreateTriggerBuilder<DB, TB>;
    forEachRow(): CreateTriggerBuilder<DB, TB>;
    forEachStatement(): CreateTriggerBuilder<DB, TB>;
    follows(otherTriggerName: string): CreateTriggerBuilder<DB, TB>;
    precedes(otherTriggerName: string): CreateTriggerBuilder<DB, TB>;
    /**
     * Specifies the table for the trigger.
     */
    onTable<TE extends keyof DB & string>(table: TE, schema?: string): CreateTriggerBuilder<DB, TE>;
    /**
     * Adds the "temporary" modifier.
     *
     * Use this to create a temporary trigger.
     */
    temporary(): CreateTriggerBuilder<DB, TB>;
    /**
     * Adds the "if not exists" modifier.
     *
     * If the trigger already exists, no error is thrown if this method has been called.
     */
    ifNotExists(): CreateTriggerBuilder<DB, TB>;
    /**
     * Only supported on PostgreSQL
     */
    orReplace(): CreateTriggerBuilder<DB, TB>;
    /**
     * Adds a query to the trigger.
     */
    addQuery(build: QueryCreatorCallback<DB, TB>): CreateTriggerBuilder<DB, TB>;
    function(name: string, args: ReadonlyArray<ReferenceExpression<any, any>>): CreateTriggerBuilder<DB, TB>;
    when<RE extends AnyColumnWithTable<DatabaseWithOldNewTables<DB, TB>, 'old' | 'new'>>(lhs: RE, op: ComparisonOperatorExpression, rhs: OperandValueExpressionOrList<DB, TB, RE>): CreateTriggerBuilder<DB, TB>;
    when(factory: ExpressionOrFactory<DatabaseWithOldNewTables<DB, TB>, 'old' | 'new', SqlBool>): CreateTriggerBuilder<DB, TB>;
    $call<T>(func: (qb: this) => T): T;
    toOperationNode(): CreateTriggerNode;
    compile(): CompiledQuery;
    execute(): Promise<void>;
}
export interface CreateTriggerBuilderProps {
    readonly queryId: QueryId;
    readonly executor: QueryExecutor;
    readonly node: CreateTriggerNode;
}
export type QueryCreatorCallback<DB, TB extends keyof DB> = (creator: TriggerQueryCreator<DB, TB>) => OperationNodeSource;
