/// <reference types="./trigger-order-node.d.ts" />
import { freeze } from '../util/object-utils.js';
/**
 * @internal
 */
export const TriggerOrderNode = freeze({
    is(node) {
        return node.kind === 'TriggerOrderNode';
    },
    create(order, otherTriggerName) {
        return freeze({
            kind: 'TriggerOrderNode',
            order,
            otherTriggerName,
        });
    },
});
