import { OperationNode } from './operation-node.js';
export type TriggerEvent = 'delete' | 'update' | 'insert' | 'truncate';
export type TriggerEventNodeParams = Omit<TriggerEventNode, 'kind'>;
export interface TriggerEventNode extends OperationNode {
    readonly kind: 'TriggerEventNode';
    readonly event: TriggerEvent;
    readonly columns?: ReadonlyArray<OperationNode>;
}
/**
 * @internal
 */
export declare const TriggerEventNode: Readonly<{
    is(node: OperationNode): node is TriggerEventNode;
    create(event: TriggerEvent, columns?: ReadonlyArray<OperationNode>): TriggerEventNode;
}>;
