/// <reference types="./drop-trigger-node.d.ts" />
import { freeze } from '../util/object-utils.js';
/**
 * @internal
 */
export const DropTriggerNode = freeze({
    is(node) {
        return node.kind === 'DropTriggerNode';
    },
    create(name) {
        return freeze({
            kind: 'DropTriggerNode',
            name,
        });
    },
    cloneWith(dropTrigger, params) {
        return freeze({
            ...dropTrigger,
            ...params,
        });
    },
});
