import { OperationNode } from './operation-node.js';
import { SchemableIdentifierNode } from './schemable-identifier-node.js';
export type DropTriggerNodeParams = Omit<Partial<DropTriggerNode>, 'kind' | 'name'>;
export interface DropTriggerNode extends OperationNode {
    readonly kind: 'DropTriggerNode';
    readonly name: SchemableIdentifierNode;
    readonly ifExists?: boolean;
    readonly cascade?: boolean;
}
/**
 * @internal
 */
export declare const DropTriggerNode: Readonly<{
    is(node: OperationNode): node is DropTriggerNode;
    create(name: SchemableIdentifierNode): DropTriggerNode;
    cloneWith(dropTrigger: DropTriggerNode, params: DropTriggerNodeParams): DropTriggerNode;
}>;
