/// <reference types="./create-trigger-node.d.ts" />
import { freeze } from '../util/object-utils.js';
/**
 * @internal
 */
export const CreateTriggerNode = freeze({
    is(node) {
        return node.kind === 'CreateTriggerNode';
    },
    create(name) {
        return freeze({
            kind: 'CreateTriggerNode',
            name,
        });
    },
    cloneWithQuery(createTrigger, query) {
        return freeze({
            ...createTrigger,
            queries: freeze([...(createTrigger.queries || []), query]),
        });
    },
    cloneWithEvent(createTrigger, event) {
        return freeze({
            ...createTrigger,
            events: freeze([...(createTrigger.events || []), event]),
        });
    },
    cloneWith(createTrigger, params) {
        return freeze({
            ...createTrigger,
            ...params,
        });
    },
});
