"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TriggerQueryCreator = void 0;
const select_query_builder_js_1 = require("./query-builder/select-query-builder.js");
const insert_query_builder_js_1 = require("./query-builder/insert-query-builder.js");
const delete_query_builder_js_1 = require("./query-builder/delete-query-builder.js");
const update_query_builder_js_1 = require("./query-builder/update-query-builder.js");
const delete_query_node_js_1 = require("./operation-node/delete-query-node.js");
const insert_query_node_js_1 = require("./operation-node/insert-query-node.js");
const select_query_node_js_1 = require("./operation-node/select-query-node.js");
const update_query_node_js_1 = require("./operation-node/update-query-node.js");
const table_parser_js_1 = require("./parser/table-parser.js");
const query_id_js_1 = require("./util/query-id.js");
const object_utils_js_1 = require("./util/object-utils.js");
const select_parser_js_1 = require("./parser/select-parser.js");
class TriggerQueryCreator {
    #props;
    constructor(props) {
        this.#props = (0, object_utils_js_1.freeze)(props);
    }
    selectFrom(from) {
        return (0, select_query_builder_js_1.createSelectQueryBuilder)({
            queryId: (0, query_id_js_1.createQueryId)(),
            executor: this.#props.executor,
            queryNode: select_query_node_js_1.SelectQueryNode.createFrom((0, table_parser_js_1.parseTableExpressionOrList)(from), this.#props.withNode),
        });
    }
    selectNoFrom(selection) {
        return (0, select_query_builder_js_1.createSelectQueryBuilder)({
            queryId: (0, query_id_js_1.createQueryId)(),
            executor: this.#props.executor,
            queryNode: select_query_node_js_1.SelectQueryNode.cloneWithSelections(select_query_node_js_1.SelectQueryNode.create(this.#props.withNode), (0, select_parser_js_1.parseSelectArg)(selection)),
        });
    }
    insertInto(table) {
        return new insert_query_builder_js_1.InsertQueryBuilder({
            queryId: (0, query_id_js_1.createQueryId)(),
            executor: this.#props.executor,
            queryNode: insert_query_node_js_1.InsertQueryNode.create((0, table_parser_js_1.parseTable)(table), this.#props.withNode),
        });
    }
    replaceInto(table) {
        return new insert_query_builder_js_1.InsertQueryBuilder({
            queryId: (0, query_id_js_1.createQueryId)(),
            executor: this.#props.executor,
            queryNode: insert_query_node_js_1.InsertQueryNode.create((0, table_parser_js_1.parseTable)(table), this.#props.withNode, true),
        });
    }
    deleteFrom(tables) {
        return new delete_query_builder_js_1.DeleteQueryBuilder({
            queryId: (0, query_id_js_1.createQueryId)(),
            executor: this.#props.executor,
            queryNode: delete_query_node_js_1.DeleteQueryNode.create((0, table_parser_js_1.parseTableExpressionOrList)(tables), this.#props.withNode),
        });
    }
    updateTable(table) {
        return new update_query_builder_js_1.UpdateQueryBuilder({
            queryId: (0, query_id_js_1.createQueryId)(),
            executor: this.#props.executor,
            queryNode: update_query_node_js_1.UpdateQueryNode.create((0, table_parser_js_1.parseTableExpression)(table), this.#props.withNode),
        });
    }
    withPlugin(plugin) {
        return new TriggerQueryCreator({
            ...this.#props,
            executor: this.#props.executor.withPlugin(plugin),
        });
    }
    withoutPlugins() {
        return new TriggerQueryCreator({
            ...this.#props,
            executor: this.#props.executor.withoutPlugins(),
        });
    }
}
exports.TriggerQueryCreator = TriggerQueryCreator;
