import { SelectQueryBuilder } from './query-builder/select-query-builder.js';
import { InsertQueryBuilder } from './query-builder/insert-query-builder.js';
import { DeleteQueryBuilder } from './query-builder/delete-query-builder.js';
import { UpdateQueryBuilder } from './query-builder/update-query-builder.js';
import { TableExpression, From, FromTables, TableReference, ExtractTableAlias, AnyAliasedTable, PickTableWithAlias } from './parser/table-parser.js';
import { InsertResult } from './query-builder/insert-result.js';
import { DeleteResult } from './query-builder/delete-result.js';
import { UpdateResult } from './query-builder/update-result.js';
import { KyselyPlugin } from './plugin/kysely-plugin.js';
import { CallbackSelection, SelectCallback, SelectExpression, Selection } from './parser/select-parser.js';
import { QueryCreatorProps } from './query-creator.js';
import { DatabaseWithOldNewTables } from './schema/create-trigger-builder.js';
export declare class TriggerQueryCreator<DB, TB extends keyof DB> {
    #private;
    constructor(props: QueryCreatorProps);
    selectFrom<TE extends keyof DB & string>(from: TE[]): SelectQueryBuilder<DatabaseWithOldNewTables<DB, TB>, ExtractTableAlias<DB, TE> | 'new' | 'old', {}>;
    selectFrom<TE extends TableExpression<DB, keyof DB>>(from: TE[]): SelectQueryBuilder<From<DatabaseWithOldNewTables<DB, TB>, TE>, FromTables<DB, never, TE> | 'new' | 'old', {}>;
    selectFrom<TE extends keyof DB & string>(from: TE): SelectQueryBuilder<DatabaseWithOldNewTables<DB, TB>, ExtractTableAlias<DB, TE> | 'new' | 'old', {}>;
    selectFrom<TE extends AnyAliasedTable<DB>>(from: TE): SelectQueryBuilder<DatabaseWithOldNewTables<DB, TB> & PickTableWithAlias<DatabaseWithOldNewTables<DB, TB>, TE>, ExtractTableAlias<DB, TE> | 'new' | 'old', {}>;
    selectFrom<TE extends TableExpression<DB, keyof DB>>(from: TE): SelectQueryBuilder<From<DatabaseWithOldNewTables<DB, TB>, TE>, FromTables<DB, never, TE> | 'new' | 'old', {}>;
    selectNoFrom<SE extends SelectExpression<DB, never>>(selections: ReadonlyArray<SE>): SelectQueryBuilder<DB, never, Selection<DB, never, SE>>;
    selectNoFrom<CB extends SelectCallback<DB, never>>(callback: CB): SelectQueryBuilder<DB, never, CallbackSelection<DB, never, CB>>;
    selectNoFrom<SE extends SelectExpression<DB, never>>(selection: SE): SelectQueryBuilder<DB, never, Selection<DB, never, SE>>;
    insertInto<T extends keyof DB & string>(table: T): InsertQueryBuilder<DB, T, InsertResult>;
    replaceInto<T extends keyof DB & string>(table: T): InsertQueryBuilder<DB, T, InsertResult>;
    deleteFrom<TR extends keyof DB & string>(from: TR[]): DeleteQueryBuilder<DatabaseWithOldNewTables<DB, TB>, ExtractTableAlias<DB, TR> | 'new' | 'old', DeleteResult>;
    deleteFrom<TR extends TableReference<DB>>(tables: TR[]): DeleteQueryBuilder<From<DatabaseWithOldNewTables<DB, TB>, TR>, FromTables<DB, never, TR> | 'new' | 'old', DeleteResult>;
    deleteFrom<TR extends keyof DB & string>(from: TR): DeleteQueryBuilder<DatabaseWithOldNewTables<DB, TB>, ExtractTableAlias<DB, TR> | 'new' | 'old', DeleteResult>;
    deleteFrom<TR extends TableReference<DB>>(table: TR): DeleteQueryBuilder<From<DatabaseWithOldNewTables<DB, TB>, TR>, FromTables<DB, never, TR> | 'new' | 'old', DeleteResult>;
    updateTable<TR extends keyof DB & string>(table: TR): UpdateQueryBuilder<DB, ExtractTableAlias<DB, TR>, ExtractTableAlias<DB, TR>, UpdateResult>;
    updateTable<TR extends AnyAliasedTable<DB>>(table: TR): UpdateQueryBuilder<DB & PickTableWithAlias<DB, TR>, ExtractTableAlias<DB, TR>, ExtractTableAlias<DB, TR>, UpdateResult>;
    updateTable<TR extends TableReference<DB>>(table: TR): UpdateQueryBuilder<From<DB, TR>, FromTables<DB, never, TR>, FromTables<DB, never, TR>, UpdateResult>;
    withPlugin(plugin: KyselyPlugin): TriggerQueryCreator<DB, TB>;
    withoutPlugins(): TriggerQueryCreator<DB, TB>;
}
