import { OperationNodeSource } from '../operation-node/operation-node-source.js';
import { CompiledQuery } from '../query-compiler/compiled-query.js';
import { Compilable } from '../util/compilable.js';
import { QueryExecutor } from '../query-executor/query-executor.js';
import { QueryId } from '../util/query-id.js';
import { DropTriggerNode } from '../operation-node/drop-trigger-node.js';
export declare class DropTriggerBuilder implements OperationNodeSource, Compilable {
    #private;
    constructor(props: DropTriggerBuilderProps);
    ifExists(): DropTriggerBuilder;
    cascade(): DropTriggerBuilder;
    /**
     * Simply calls the provided function passing `this` as the only argument. `$call` returns
     * what the provided function returns.
     */
    $call<T>(func: (qb: this) => T): T;
    toOperationNode(): DropTriggerNode;
    compile(): CompiledQuery;
    execute(): Promise<void>;
}
export interface DropTriggerBuilderProps {
    readonly queryId: QueryId;
    readonly executor: QueryExecutor;
    readonly node: DropTriggerNode;
}
