"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TriggerOrderNode = void 0;
const object_utils_js_1 = require("../util/object-utils.js");
/**
 * @internal
 */
exports.TriggerOrderNode = (0, object_utils_js_1.freeze)({
    is(node) {
        return node.kind === 'TriggerOrderNode';
    },
    create(order, otherTriggerName) {
        return (0, object_utils_js_1.freeze)({
            kind: 'TriggerOrderNode',
            order,
            otherTriggerName,
        });
    },
});
