"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TriggerEventNode = void 0;
const object_utils_js_1 = require("../util/object-utils.js");
/**
 * @internal
 */
exports.TriggerEventNode = (0, object_utils_js_1.freeze)({
    is(node) {
        return node.kind === 'TriggerEventNode';
    },
    create(event, columns) {
        return (0, object_utils_js_1.freeze)({
            kind: 'TriggerEventNode',
            event,
            columns,
        });
    },
});
