"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DropTriggerNode = void 0;
const object_utils_js_1 = require("../util/object-utils.js");
/**
 * @internal
 */
exports.DropTriggerNode = (0, object_utils_js_1.freeze)({
    is(node) {
        return node.kind === 'DropTriggerNode';
    },
    create(name) {
        return (0, object_utils_js_1.freeze)({
            kind: 'DropTriggerNode',
            name,
        });
    },
    cloneWith(dropTrigger, params) {
        return (0, object_utils_js_1.freeze)({
            ...dropTrigger,
            ...params,
        });
    },
});
