"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateTriggerNode = void 0;
const object_utils_js_1 = require("../util/object-utils.js");
/**
 * @internal
 */
exports.CreateTriggerNode = (0, object_utils_js_1.freeze)({
    is(node) {
        return node.kind === 'CreateTriggerNode';
    },
    create(name) {
        return (0, object_utils_js_1.freeze)({
            kind: 'CreateTriggerNode',
            name,
        });
    },
    cloneWithQuery(createTrigger, query) {
        return (0, object_utils_js_1.freeze)({
            ...createTrigger,
            queries: (0, object_utils_js_1.freeze)([...(createTrigger.queries || []), query]),
        });
    },
    cloneWithEvent(createTrigger, event) {
        return (0, object_utils_js_1.freeze)({
            ...createTrigger,
            events: (0, object_utils_js_1.freeze)([...(createTrigger.events || []), event]),
        });
    },
    cloneWith(createTrigger, params) {
        return (0, object_utils_js_1.freeze)({
            ...createTrigger,
            ...params,
        });
    },
});
