"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSocketIntegration = void 0;
function getSocketIntegration(integrationType) {
    let resolvedSocketIntegration;
    switch (integrationType) {
        case 'wds': {
            resolvedSocketIntegration = require.resolve('../sockets/WDSSocket');
            break;
        }
        default: {
            resolvedSocketIntegration = require.resolve(integrationType);
            break;
        }
    }
    return resolvedSocketIntegration;
}
exports.getSocketIntegration = getSocketIntegration;
