import type { IntegrationType } from './utils/getSocketIntegration';
interface OverlayOptions {
    entry: string;
    module: string;
    sockIntegration: IntegrationType;
    sockHost?: string;
    sockPath?: string;
    sockPort?: string;
    sockProtocol?: string;
}
export type PluginOptions = {
    include?: string | RegExp | (string | RegExp)[] | null;
    exclude?: string | RegExp | (string | RegExp)[] | null;
    library?: string;
    forceEnable?: boolean;
    overlay?: boolean | OverlayOptions;
};
export interface NormalizedPluginOptions extends Required<PluginOptions> {
    overlay: false | OverlayOptions;
}
export declare function normalizeOptions(options: PluginOptions): NormalizedPluginOptions;
export {};
