/**
 * Determine if a given data URL is valid or not.
 *
 * @see {@link https://developer.mozilla.org/en-US/docs/data_URIs}
 * @see {@link http://tools.ietf.org/html/rfc2397}
 * @see {@link http://tools.ietf.org/html/rfc2396#section2}
 */
declare function validate(str: string): boolean;
interface DataURL {
    [k: string]: any;
    base64: boolean;
    contentType?: string;
    data: string;
    mediaType?: string;
    name?: string;
    toBuffer: () => Buffer;
}
/**
 * Parse a given data URL into its individual parts.
 *
 */
declare function parse(str: string): false | DataURL;

export { DataURL, parse, validate };
