'use strict';

// src/index.ts
var DATA_URL_REGEX = /^data:([a-z]+\/[a-z0-9-+.]+(;[a-z0-9-.!#$%*+.{}|~`]+=[a-z0-9-.!#$%*+.{}()_|~`]+)*)?(;base64)?,([a-z0-9!$&',()*+;=\-._~:@/?%\s<>]*?)$/i;
function validate(str) {
  return DATA_URL_REGEX.test((str || "").trim());
}
function parse(str) {
  if (!validate(str)) {
    return false;
  }
  const parts = str.trim().match(DATA_URL_REGEX);
  const parsed = {};
  if (parts[1]) {
    parsed.mediaType = parts[1].toLowerCase();
    const mediaTypeParts = parts[1].split(";").map((x) => {
      if (x.startsWith("name=")) {
        return x;
      }
      return x.toLowerCase();
    });
    parsed.contentType = mediaTypeParts[0];
    mediaTypeParts.slice(1).forEach((attribute) => {
      const p = attribute.split("=");
      parsed[p[0]] = p[1];
    });
  }
  parsed.base64 = !!parts[parts.length - 2];
  parsed.data = parts[parts.length - 1] || "";
  parsed.toBuffer = () => {
    const encoding = parsed.base64 ? "base64" : "utf8";
    return Buffer.from(parsed.data, encoding);
  };
  return parsed;
}

exports.parse = parse;
exports.validate = validate;
//# sourceMappingURL=out.js.map
//# sourceMappingURL=index.cjs.map