import { getI18n } from './server.mjs';
import { T as TransNoContext } from './shared/react.1807f7b5.mjs';
import React from 'react';

function TransRsc(props) {
  const ctx = getI18n();
  if (!ctx) {
    throw new Error(
      "You tried to use `Trans` in Server Component, but i18n instance for RSC hasn't been setup.\nMake sure to call `setI18n` in the root of your page."
    );
  }
  return /* @__PURE__ */ React.createElement(TransNoContext, { ...props, lingui: ctx });
}

function useLingui() {
  const ctx = getI18n();
  if (!ctx) {
    throw new Error(
      "You tried to use `useLingui` in a Server Component, but i18n instance for RSC hasn't been setup.\nMake sure to call `setI18n` in the root of your page."
    );
  }
  return ctx;
}

export { TransRsc as Trans, useLingui };
