import { Reader } from '@jsonjoy.com/buffers/lib/Reader';
import { XdrDecoder } from '../../xdr/XdrDecoder';
import { Nfsv3Proc } from './constants';
import * as msg from './messages';
export declare class Nfsv3Decoder {
    protected readonly xdr: XdrDecoder;
    constructor(reader?: Reader);
    decodeMessage(reader: Reader, proc: Nfsv3Proc, isRequest: boolean): msg.Nfsv3Message | undefined;
    private decodeRequest;
    private decodeResponse;
    private readFh;
    private readFilename;
    private readTime;
    private readSpecData;
    private readFattr;
    private readPostOpAttr;
    private readWccAttr;
    private readPreOpAttr;
    private readWccData;
    private readPostOpFh;
    private readSetMode;
    private readSetUid;
    private readSetGid;
    private readSetSize;
    private readSetAtime;
    private readSetMtime;
    private readSattr;
    private readSattrGuard;
    private readDirOpArgs;
    private readCreateHow;
    private readMknodData;
    private readEntry;
    private readEntryPlus;
    private readDirList;
    private readDirListPlus;
    private decodeGetattrRequest;
    private decodeGetattrResponse;
    private decodeSetattrRequest;
    private decodeSetattrResponse;
    private decodeLookupRequest;
    private decodeLookupResponse;
    private decodeAccessRequest;
    private decodeAccessResponse;
    private decodeReadlinkRequest;
    private decodeReadlinkResponse;
    private decodeReadRequest;
    private decodeReadResponse;
    private decodeWriteRequest;
    private decodeWriteResponse;
    private decodeCreateRequest;
    private decodeCreateResponse;
    private decodeMkdirRequest;
    private decodeMkdirResponse;
    private decodeSymlinkRequest;
    private decodeSymlinkResponse;
    private decodeMknodRequest;
    private decodeMknodResponse;
    private decodeRemoveRequest;
    private decodeRemoveResponse;
    private decodeRmdirRequest;
    private decodeRmdirResponse;
    private decodeRenameRequest;
    private decodeRenameResponse;
    private decodeLinkRequest;
    private decodeLinkResponse;
    private decodeReaddirRequest;
    private decodeReaddirResponse;
    private decodeReaddirplusRequest;
    private decodeReaddirplusResponse;
    private decodeFsstatRequest;
    private decodeFsstatResponse;
    private decodeFsinfoRequest;
    private decodeFsinfoResponse;
    private decodePathconfRequest;
    private decodePathconfResponse;
    private decodeCommitRequest;
    private decodeCommitResponse;
}
