"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reanimated4ModuleRules = exports.reanimated3ModuleRules = exports.reanimatedModuleRules = exports.createReanimatedModuleRules = void 0;
const repack_1 = require("@callstack/repack");
const createReanimatedModuleRules = (majorVersion, pluginOptions = {}) => {
    const workletsBabelPlugin = majorVersion < 4
        ? 'react-native-reanimated/plugin'
        : 'react-native-worklets/plugin';
    return {
        exclude: (0, repack_1.getModulePaths)([
            'react',
            'react-native',
            '@react-native',
            'react-native-macos',
            'react-native-windows',
            'react-native-tvos',
            '@callstack/react-native-visionos',
        ]),
        oneOf: [
            {
                test: /\.[cm]?ts$/,
                use: {
                    loader: '@callstack/repack-plugin-reanimated/loader',
                    options: {
                        babelPlugins: [
                            [
                                '@babel/plugin-syntax-typescript',
                                { isTSX: false, allowNamespaces: true },
                            ],
                            [workletsBabelPlugin, pluginOptions],
                        ],
                    },
                },
            },
            {
                test: /\.[cm]?tsx$/,
                use: {
                    loader: '@callstack/repack-plugin-reanimated/loader',
                    options: {
                        babelPlugins: [
                            [
                                '@babel/plugin-syntax-typescript',
                                { isTSX: true, allowNamespaces: true },
                            ],
                            [workletsBabelPlugin, pluginOptions],
                        ],
                    },
                },
            },
            {
                test: /\.[cm]?jsx?$/,
                use: {
                    loader: '@callstack/repack-plugin-reanimated/loader',
                    options: {
                        babelPlugins: [
                            'babel-plugin-syntax-hermes-parser',
                            [workletsBabelPlugin, pluginOptions],
                        ],
                    },
                },
            },
        ],
    };
};
exports.createReanimatedModuleRules = createReanimatedModuleRules;
const reanimated3ModuleRules = (0, exports.createReanimatedModuleRules)(3);
exports.reanimated3ModuleRules = reanimated3ModuleRules;
const reanimated4ModuleRules = (0, exports.createReanimatedModuleRules)(4);
exports.reanimated4ModuleRules = reanimated4ModuleRules;
// backwards compatibility export
const reanimatedModuleRules = reanimated3ModuleRules;
exports.reanimatedModuleRules = reanimatedModuleRules;
