import type { Compiler as RspackCompiler } from '@rspack/core';
import type { Compiler as WebpackCompiler } from 'webpack';
interface ReanimatedPluginOptions {
    /**
     * Custom options passed to 'react-native-reanimated/plugin' or 'react-native-worklets/plugin' babel plugins.
     */
    babelPluginOptions?: Record<string, any>;
    /**
     * Disable adding transformation rules for reanimated / worklets babel plugin.
     * This is useful when handling using `babel-swc-loader` or `babel-loader` and
     * you have already added the babel plugin to your babel config.
     */
    unstable_disableTransform?: boolean;
}
export declare class ReanimatedPlugin {
    private options;
    constructor(options?: ReanimatedPluginOptions);
    apply(compiler: RspackCompiler): void;
    apply(compiler: WebpackCompiler): void;
    private ensureDependencyInstalled;
    private getReanimatedVersion;
}
export {};
