//
//  NotesWidget.swift
//  NotesWidget
//
//  Created by Ammar Ahmed on 25/02/2021.
//

import WidgetKit
import SwiftUI

struct Provider: TimelineProvider {
  func placeholder(in context: Context) -> SimpleEntry {
    SimpleEntry(date: Date())
  }
  
  func getSnapshot(in context: Context, completion: @escaping (SimpleEntry) -> ()) {
    let entry = SimpleEntry(date: Date())
    completion(entry)
  }
  
  func getTimeline(in context: Context, completion: @escaping (Timeline<Entry>) -> ()) {
    var entries: [SimpleEntry] = []
    
    // Generate a timeline consisting of five entries an hour apart, starting from the current date.
    let currentDate = Date()
    for hourOffset in 0 ..< 5 {
      let entryDate = Calendar.current.date(byAdding: .day, value: hourOffset, to: currentDate)!
      let entry = SimpleEntry(date: entryDate)
      entries.append(entry)
    }
    
    let timeline = Timeline(entries: entries, policy: .atEnd)
    completion(timeline)
  }
}

struct SimpleEntry: TimelineEntry {
  let date: Date
}

struct NotesWidgetEntryView : View {
  var entry: Provider.Entry
  
  
  
  var body: some View {
    ZStack {
      VStack {
        Image(systemName: "plus").font(.system(size: 50)).offset(x: 0, y: 5)
        Text("Add a quick note").font(.system(size: 14)).offset(x: 0, y: 30)
      }
      
    }.widgetURL(URL(string: "ShareMedia://QuickNoteWidget"))
  }
  
  
}

@main
struct NotesWidget: Widget {
  let kind: String = "NotesWidget"

  var body: some WidgetConfiguration {
    StaticConfiguration(kind: kind, provider: Provider()) { entry in
      NotesWidgetEntryView(entry: entry)
    }
    .configurationDisplayName("Quick Note")
    .description("A widget to add notes quickly.")
  }
}

struct NotesWidget_Previews: PreviewProvider {
  static var previews: some View {
    NotesWidgetEntryView(entry: SimpleEntry(date: Date()))
      .previewContext(WidgetPreviewContext(family: .systemSmall))
  }
}
