/*
This file is part of the Notesnook project (https://notesnook.com/)

Copyright (C) 2023 Streetwriters (Private) Limited

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

import { TestBuilder } from "./utils";

describe("Search", () => {
  it("Search for a note", async () => {
    await TestBuilder.create()
      .prepare()
      .createNote()
      .waitAndTapById("search-header")
      .typeTextById("search-input", "Test")
      .wait(1000)
      .isVisibleByText("1")
      .waitAndTapById("clear-search")
      .wait(2000)
      .isNotVisibleByText("1")
      .run();
  });
});
