/*
This file is part of the Notesnook project (https://notesnook.com/)

Copyright (C) 2023 Streetwriters (Private) Limited

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

export const LAUNCH_ROCKET = (color) =>
  `<svg xmlns="http://www.w3.org/2000/svg" data-name="Layer 1" width="748.82965" height="557.20035" viewBox="0 0 748.82965 557.20035" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M276.60133,642.057c-3.59968,0-7.20676.1709-10.72934.51563l-.51267.0498c-23.36542,2.37793-40.45611,16.17286-39.75323,32.08985l.13588,2.87793c.08961,1.81933.18508,3.77539.26367,5.94531.04255,1.07031,1.31106,1.8916,2.88946,1.8916H803.62751c40.52148-.2832,80.89606-.63965,119.9956-1.05957a177.65216,177.65216,0,0,0,21.95374-1.30957c10.86591-1.48047,18.40759-4.415,23.05841-8.97168h.00147c5.78332-5.65039,5.96551-12.76562,5.6159-20.80469-.71246-16.23242-1.419-33.28515-2.12414-50.28613-.62281-14.9834-1.24274-29.92676-1.86261-44.2334-.38343-8.49023-1.23536-15.98437-7.80317-21.71191-7.11865-6.19434-20.10137-9.334-38.58831-9.334-.22333,0-.44507,0-.67133.001-57.9361.23731-115.34192,23.1709-142.8454,57.06732-3.16711,3.90332-6.11822,8.082-8.97247,12.124a158.91584,158.91584,0,0,1-13.7804,17.66406,66.94863,66.94863,0,0,1-9.10321,8.16894c-.22326.17774-.47888.36817-.7492.54883-.61847.46387-1.26477.91114-1.895,1.30957a62.04148,62.04148,0,0,1-11.60926,6.07617l-.40692.15723c-.30627.126-.6383.252-.97027.36719a68.20886,68.20886,0,0,1-7.17,2.20605c-10.484,2.66016-22.40545,3.29785-35.43151,1.89356a151.75182,151.75182,0,0,1-35.2295-8.26465c-12.06244-4.38867-23.3529-9.86035-34.27173-15.15137-4.79614-2.32519-9.75683-4.72851-14.711-7.00586-.93134-.42871-1.84723-.84765-2.7771-1.2666-6.05066-2.71484-11.5365-4.957-16.77045-6.85449a146.28118,146.28118,0,0,0-39.96478-8.52149c-14.40918-.9082-27.10688.80469-37.73191,5.07911a60.6496,60.6496,0,0,0-8.53469,4.23339c-12.58466,7.52344-20.343,18.627-27.845,29.36524-9.33233,13.35644-18.98275,27.16894-38.0382,34.3291-21.98825,8.26953-54.08371,4.834-76.791-1.14062-7.13919-1.87891-14.26956-4.04-21.16565-6.13086q-4.17768-1.26719-8.36136-2.51661c-5.48071-1.6289-9.96621-2.877-14.116-3.93066l-1.31253-.33594c-.73008-.18261-1.46088-.36523-2.20493-.53906-4.92911-1.19141-9.51892-2.12891-14.03891-2.86621l-1.06943-.17969c-2.144-.32519-4.14834-.5957-6.11526-.82324l-.78516-.08984A109.23844,109.23844,0,0,0,276.60133,642.057Z" transform="translate(-225.58517 -171.39982)" fill="#f2f2f2"/><path d="M343.64,685.3514a1.19069,1.19069,0,0,1,1.18683-1.19452h510.294a1.19069,1.19069,0,0,1,0,2.38135h-510.294A1.19066,1.19066,0,0,1,343.64,685.3514Z" transform="translate(-225.58517 -171.39982)" fill="#cacaca"/><path d="M746.00469,214.43986a42.86006,42.86006,0,0,1-11.46,29.24c-.56.61-1.15,1.2-1.75,1.77a650.40347,650.40347,0,0,0-69.84-46.89c.3-.76.62-1.51.97-2.25a43.04295,43.04295,0,0,1,82.08,18.13Z" transform="translate(-225.58517 -171.39982)" fill="#ff6584"/><path d="M780.91466,302.03984l-.04.45q-42.465-2.925-84.92-5.86c-20.45-1.41-41.61-3.01-59.68-12.69-6.86005-3.67-13.54-8.57-21.32-8.91-9.65-.43-18.07,6.32-24.69,13.36-39.13,41.68-50.46,105.41-94.36,142.02a1394.13755,1394.13755,0,0,1,98.86-197.31c7.04-11.65,15.39-24.09,28.46-27.89,12.47-3.63,25.23,1.67,36.71,8.47,2.46,1.46,4.86,2.99,7.18,4.51q26.535,17.36994,52.2,36.06995Q750.82971,277.19487,780.91466,302.03984Z" transform="translate(-225.58517 -171.39982)" fill="#f2f2f2"/><path d="M872.47466,390.43986a670.65125,670.65125,0,0,0-104.75-116.27q-16.965-14.91-34.93-28.72a650.40347,650.40347,0,0,0-69.84-46.89q-11.94-6.93-24.16-13.31c-6.33-3.29-13.07-6.3-20.37-5.83a27.10218,27.10218,0,0,0-14.07,5.41c-8.97,6.55-14.91,16.78-19.8,26.53-4.28,8.55-8.27,17.27-12.34,25.94-1.73,3.69-3.46,7.37-5.25,11.03q-9.36008,19.23-19.16,38.25-12.63,24.51-25.99,48.65-28.065,50.745-59.23,99.66-45.81006,71.895-98.02,139.43c-4.27,5.51-6.03,6.79-10.36,12.26-1,1.28-2.78-.52-1.79-1.79,36.11005-45.64,67.55005-88.76,99.25-137.58q35.85-55.215,67.76-112.88,10.245-18.49494,20.06-37.22,15.885-30.315,30.67-61.2,3.9-8.13,7.72-16.32c8.09-17.33,19.87-43.1,42.62-42.75,6.69.1,12.9,2.81,18.76,5.81,5.97,3.07,11.83,6.33,17.68,9.64q3.51,1.98,6.99,4.02,13.785,8.00994,27.16,16.69,22.32,14.47494,43.46,30.68,10.035,7.695,19.77,15.74a673.54712,673.54712,0,0,1,109.09,114.31q5.74493,7.635,11.25,15.44C875.59472,390.49986,873.40472,391.75981,872.47466,390.43986Z" transform="translate(-225.58517 -171.39982)" fill="#e4e4e4"/><path d="M769.97685,261.4421c1.32186-1.47358,2.63549-2.94715,3.966-4.42072C784.43462,245.418,795.6924,233.94944,810.1,227.2973a52.4571,52.4571,0,0,1,21.97735-5.09434c7.86453.02529,15.55227,2.08825,22.819,4.97649,3.43559,1.37253,6.79554,2.93029,10.10449,4.58908,3.781,1.903,7.4945,3.93237,11.19076,5.97852q10.40791,5.75957,20.54571,12.02432,20.17137,12.46641,39.07925,26.83584,9.80167,7.45209,19.19878,15.39253,8.74029,7.37624,17.127,15.14831c1.19563,1.10307,2.98086-.68205,1.78523-1.78512-1.47357-1.37253-2.964-2.73664-4.45443-4.08388q-6.31532-5.70906-12.8329-11.19919-11.885-10.0287-24.38547-19.2827-19.43869-14.39893-40.21568-26.84427-10.38264-6.21425-21.051-11.90647c-2.14745-1.14516-4.32-2.26509-6.51759-3.32607a103.89918,103.89918,0,0,0-15.49347-6.30688,55.11725,55.11725,0,0,0-23.40035-2.29875,60.92335,60.92335,0,0,0-21.59005,7.46889c-14.14612,7.90678-25.11773,20.13318-35.795,32.06494C767.11358,260.86109,768.89058,262.65464,769.97685,261.4421Z" transform="translate(-225.58517 -171.39982)" fill="#e4e4e4"/><path d="M480.12667,381.68342l-33.89782-12.39828-16.83038-6.15579c-5.48137-2.00484-10.94957-4.28719-16.616-5.72275a26.21362,26.21362,0,0,0-15.03952.19162,34.66256,34.66256,0,0,0-11.73046,7.27166,95.19524,95.19524,0,0,0-9.62144,10.275c-3.66428,4.40365-7.27444,8.85345-10.90079,13.28835q-22.45,27.45558-44.6064,55.14948-22.1559,27.69344-44.01554,55.62218-21.91307,27.997-43.52474,56.22818-2.64747,3.45842-5.2904,6.92031c-.97346,1.275-3.16844.018-2.18124-1.275q21.77112-28.515,43.84571-56.79666,22.1289-28.3492,44.56359-56.45793,22.43425-28.10817,45.17171-55.97256,5.66458-6.94185,11.34787-13.86842c3.196-3.89521,6.356-7.83243,9.86155-11.45793,6.43462-6.65486,14.47386-12.536,24.09692-12.69554,5.65786-.09382,11.13345,1.70155,16.3902,3.60326,5.667,2.05012,11.32041,4.1386,16.98015,6.20868l34.13486,12.485,8.53372,3.12124c1.51441.55391.8602,2.99613-.67154,2.43589Z" transform="translate(-225.58517 -171.39982)" fill="#e4e4e4"/><path d="M814.56088,241.89784c17.22612-8.85335,39.28657-7.11936,55.11616,3.94157a786.11526,786.11526,0,0,0-89.43729,20.87423C792.44014,259.5639,801.98377,248.36189,814.56088,241.89784Z" transform="translate(-225.58517 -171.39982)" fill="#f2f2f2"/><path d="M869.84659,245.80893l3.31625,2.69552c-1.12172-.94344-2.28786-1.828-3.4858-2.665C869.73362,245.82965,869.79,245.8187,869.84659,245.80893Z" transform="translate(-225.58517 -171.39982)" fill="#f2f2f2"/><path d="M387.28886,381.80727c3.33682-4.06177,6.94448-8.31469,11.93551-9.96449l4.65975.18379A528.5525,528.5525,0,0,1,263.10428,532.971Q325.19657,457.38918,387.28886,381.80727Z" transform="translate(-225.58517 -171.39982)" fill="#f2f2f2"/><path d="M736.79357,610.34291l-28.21714-12.44874V587.19183l10.0561-.05651a7.46918,7.46918,0,0,0,7.044-5.10714l7.06437-21.193a7.46924,7.46924,0,0,0-7.08594-9.83122h-17.0785v-9.959h21.44024a7.46925,7.46925,0,0,0,7.27937-5.79584l4.865-21.16286a7.46923,7.46923,0,0,0-7.27937-9.14265H708.57643v-2.48975a4.97949,4.97949,0,0,0-9.959,0v2.48975H522.26028v-2.48975a4.9795,4.9795,0,0,0-9.959,0v2.48975h-20.9108a7.46923,7.46923,0,0,0-7.27937,9.14265l4.865,21.16286a7.46925,7.46925,0,0,0,7.27937,5.79584h16.04578v9.959H500.617a7.46923,7.46923,0,0,0-7.10927,9.76L500.7181,583.141a7.46925,7.46925,0,0,0,7.15123,5.17837l4.432-.0249v9.59968l-22.82269,12.44874a7.46922,7.46922,0,0,0-7.46924,7.46922v0a7.46925,7.46925,0,0,0,7.46924,7.46925h22.82269v54.77446a4.9795,4.9795,0,0,0,9.959,0V625.2814H698.61744v54.77446a4.9795,4.9795,0,0,0,9.959,0V625.2814h28.21714a7.46925,7.46925,0,0,0,7.46925-7.46925v0A7.46922,7.46922,0,0,0,736.79357,610.34291Zm-214.53329-69.298H698.61744v9.959H522.26028Zm0,56.84925v-9.65563l176.35716-.99076v10.64639Z" transform="translate(-225.58517 -171.39982)" fill="#ccc"/><path d="M315.95555,589.21408l7.98486-26.00457a87.77022,87.77022,0,0,0-35.0839-23.50552c13.12443,21.74329.40683,50.10772,5.70643,74.94591a52.79391,52.79391,0,0,0,28.27717,35.97783l12.11706,15.0135a88.46589,88.46589,0,0,0,6.50218-73.78667,85.453,85.453,0,0,0-9.89442-19.0176C324.36444,581.302,315.95555,589.21408,315.95555,589.21408Z" transform="translate(-225.58517 -171.39982)" fill="#f2f2f2"/><path d="M272.05023,592.53665l-4.45075-26.83629a87.7702,87.7702,0,0,0-41.8846-5.39169c21.444,13.60792,22.71121,44.6671,38.53194,64.53481a52.79391,52.79391,0,0,0,41.3547,19.59061l17.541,8.03374a88.466,88.466,0,0,0-27.08773-68.942,85.45248,85.45248,0,0,0-17.3374-12.60883C276.04789,581.70478,272.05023,592.53665,272.05023,592.53665Z" transform="translate(-225.58517 -171.39982)" fill="#f2f2f2"/><path d="M902.5106,479.11845,885.044,458.26383a87.77019,87.77019,0,0,1,23.18573-35.29606c-3.63882,25.13524,19.10562,46.32412,23.87929,71.26873a52.79386,52.79386,0,0,1-12.06557,44.141l-5.327,18.54322a88.4659,88.4659,0,0,1-34.67683-65.45432,85.45238,85.45238,0,0,1,1.72257-21.36823C891.68721,475.0979,902.5106,479.11845,902.5106,479.11845Z" transform="translate(-225.58517 -171.39982)" fill="#f2f2f2"/><path d="M944.2538,465.1105,937.92125,438.655a87.77005,87.77005,0,0,1,36.49358-21.25108c-14.46674,20.87426-3.55934,49.98279-10.41151,74.43825a52.79393,52.79393,0,0,1-30.48523,34.127l-13.03785,14.2212a88.46591,88.46591,0,0,1-1.84586-74.0496,85.45328,85.45328,0,0,1,11.0716-18.35724C936.35949,456.68492,944.2538,465.1105,944.2538,465.1105Z" transform="translate(-225.58517 -171.39982)" fill="#f2f2f2"/><polygon points="373.867 536.045 362.393 541.58 335.583 499.958 352.517 491.789 373.867 536.045" fill="#ffb6b6"/><path d="M600.74559,539.92239,590.54818,555.309s-60.63447,40.15326-58.10323,55.09015c.88547,5.22518,4.73286,16.21626,9.68184,28.46477,1.52072,3.76372,8.6663,11.24446,10.34108,15.11482,8.45541,19.54026,12.66545,35.17435,16.72606,37.26588,4.50965,2.33785,4.0477.48289,6.81076,4.74524l16-6s2.492-5.59411,3.72976-8.36482-.70312-4.14914-.70312-4.14914-2.34884,1.25171-1.9409-1.37838.26732-3.45993-.70312-4.14914-4.72555-7.73579-4.72555-7.73579a69.82223,69.82223,0,0,1-8.19389-16.23385c-.89266-2.521-.8037-8.56182-2-11-2.52046-5.13691-3.41208-8.92851-7.48445-11.59957,0,0,51.26687-24.90725,56.0774-36.82s-.13917-51.19588-.13917-51.19588Z" transform="translate(-225.58517 -171.39982)" fill="#2f2e41"/><path d="M605.53555,713.49,566.738,728.60018l-.19114-.49072A16.2068,16.2068,0,0,1,575.766,707.127l.001-.00038,4.99263-8.13674,15.31681.227,3.38679-1.319Z" transform="translate(-225.58517 -171.39982)" fill="#2f2e41"/><polygon points="470.462 475.448 489.209 474.029 486.873 523.483 474.17 524.444 470.462 475.448" fill="#ffb6b6"/><path d="M593.02692,553.52922c-4.3106-18.98155,7.83714,37.61669,20.4366,48.19854,4.95423,4.16091,25.69256-.14621,42.8621,1.16619a87.67112,87.67112,0,0,1,30.31954,8.23641c-2.73885,4.99134.12692,12.43982.6598,19.13657.97215,12.21694,1.951,23.45149,1.951,23.45149s-.00949,7.98466-.54308,9.04866-.26835,1.86279,1.326,3.99393-1.06716,2.12794-1.06716,2.12794-1.06715,2.128,1.326,3.99393,8.07377,7.30057,8.07377,7.30057l15.2371-1.353c.44-5.06062,1.75485-5.72611,4.64021-9.90671,2.74584-3.95613,2.11713-27.69491.18239-49.97665-.13112-1.5101,1.975-6.26147,1.83251-7.75157-1.42952-14.95072-5.64132-25.31417-7.49858-30.90816-1.28141-3.85954-7.43466-7.18789-15.75192-9.99213-1.26923-.42794-2.58886-.84367-3.94927-1.24722-22.9351-6.80347-57.45854-10.145-57.45854-10.145l-18.87706-16.79029Z" transform="translate(-225.58517 -171.39982)" fill="#2f2e41"/><path d="M698.047,693.13029l3.44938-1.14538,11.64877-9.948,9.036,3.07948.001-.00032a16.2068,16.2068,0,0,1,20.48676,10.27369l.16594.49981-39.51465,13.1209Z" transform="translate(-225.58517 -171.39982)" fill="#2f2e41"/><path d="M610.42386,444.23228l-11.34,8.635-13.676,4.20263s-5.65377,79.52833-10.74813,84.62269-.49987,5.23128-1.52352,11.84916-3.51168,20.18377-3.51168,20.18377c34.38707,18.20258,64.03233,18.69086,87.845-2.60926a5.93117,5.93117,0,0,0-3.23608-6.69462c-4.43194-2.35163,4.08556-13.32756.4636-15.16273s1.47241-17.755,1.47241-17.755l-3.34187-33.21557,2.64024-5.30957-6.44317-32.48858-11.18013-4.083-4.466-10.76026Z" transform="translate(-225.58517 -171.39982)" fill="${color}"/><circle cx="396.44756" cy="245.59574" r="22.43078" fill="#ffb6b6"/><path d="M603.31993,585.581a9.8303,9.8303,0,0,0-11.20736-10.08022l-15.98166-31.06366L567.227,560.25692l16.54148,27.07327a9.88361,9.88361,0,0,0,19.55136-1.74918Z" transform="translate(-225.58517 -171.39982)" fill="#ffb6b6"/><path d="M576.40552,577.98205l-34.27838-53.12743.11315-.24444c.12942-.28007,7.89169-17.0446,15.413-32.39983,1.15826-2.36467,2.31081-4.69592,3.42889-6.9284q.72381-1.44525,1.42605-2.83006c3.159-6.22783,5.919-11.37528,7.56649-13.8204A29.01536,29.01536,0,0,1,585.45,456.96784l.15859-.04078.15141.06312a14.72433,14.72433,0,0,1,8.76284,16.19753,104.296,104.296,0,0,1-19.35291,43.755l-5.557,7.32473,19.31154,41.98522Z" transform="translate(-225.58517 -171.39982)" fill="${color}"/><path d="M665.672,597.791v1.42726a3.15238,3.15238,0,0,1-3.1517,3.15168H557.69779a3.15237,3.15237,0,0,1-3.1517-3.15168V597.791a3.15235,3.15235,0,0,1,3.1517-3.15167H559.559a2.65083,2.65083,0,0,1-.10157-.70776V540.43129a2.645,2.645,0,0,1,2.64324-2.64334h96.01673a2.645,2.645,0,0,1,2.64325,2.64334v53.50028a2.49845,2.49845,0,0,1-.10158.70776h1.8612A3.15235,3.15235,0,0,1,665.672,597.791Z" transform="translate(-225.58517 -171.39982)" fill="#3f3d56"/><path d="M612.17439,568.01513a5.99072,5.99072,0,1,1,5.99071-5.99072A5.99747,5.99747,0,0,1,612.17439,568.01513Zm0-10.94882a4.95811,4.95811,0,1,0,4.9581,4.9581A4.96375,4.96375,0,0,0,612.17439,557.06631Z" transform="translate(-225.58517 -171.39982)" fill="#fff"/><circle cx="384.52404" cy="388.55935" r="5.47437" fill="#fff"/><path d="M694.27889,374.33627a9.83029,9.83029,0,0,0,2.35881,14.888l-7.14559,34.1951,16.87861-6.68267,4.19795-31.44773A9.88361,9.88361,0,0,0,694.279,374.33631Z" transform="translate(-225.58517 -171.39982)" fill="#ffb6b6"/><path d="M710.402,397.18741l-6.82552,62.85653-.24182.11865c-.19928.09793-8.84664,4.33935-19.46132,9.3906-1.79066.85213-1.534,4.54333-3.40547,5.42554-1.28914.60769-4.69342-1.5973-5.996-.98816-11.6023,5.42574-23.33421,10.70159-28.00981,12.13114a29.01531,29.01531,0,0,1-19.2887-.621l-.14887-.06818-.07788-.14438a14.72433,14.72433,0,0,1,3.39225-18.10082,104.29609,104.29609,0,0,1,42.58656-21.80405l8.92931-2.19087,11.43611-44.77622Z" transform="translate(-225.58517 -171.39982)" fill="${color}"/><path d="M672.18567,373.68221l2.56841,23.30916A2.84507,2.84507,0,0,0,677.47344,399h11.83939a2.84516,2.84516,0,0,0,2.71966-2.00863l2.12733-17.86534A4.32088,4.32088,0,1,0,695.274,370.998a2.8198,2.8198,0,0,0-2.15867-.998h-18.21A2.84558,2.84558,0,0,0,672.18567,373.68221Zm22.34593,4.23569,1.303-4.23569a2.8158,2.8158,0,0,0,.04308-1.506c.05574-.003.10816-.01661.1645-.01661a3.08511,3.08511,0,0,1,0,6.17022A3.04612,3.04612,0,0,1,694.5316,377.9179Z" transform="translate(-225.58517 -171.39982)" fill="#3f3d56"/><path d="M640.30289,397.72555c-1.84465-5.36654-11.02746-9.08881-25.91418-9.60638s-18.66227,17.02576-18.66227,17.02576c-9.938,8.06174,10.61182,29.64505,11.606,28.86767l-.447-4.05508C606.1452,423.24079,603,418,607,411l3.841.0441q7.441,1.43086,14.882,2.8617l-5.87291-5.17092.1656-.25624a22.7265,22.7265,0,0,0,8.01667,2.43412c3.15652.18554,6.6074-1.0707,8.11933-3.84781a6.46562,6.46562,0,0,0,.72539-2.46008c4.25656,1.70064,6.203,6.94811,6.203,6.94811S642.14753,403.09209,640.30289,397.72555Z" transform="translate(-225.58517 -171.39982)" fill="#2f2e41"/></svg>`;

export const COMMUNITY_SVG = (color) => `
  <svg xmlns="http://www.w3.org/2000/svg" data-name="Layer 1" viewBox="0 0 1135 713"><defs/><path fill="${color}" d="M1128 491c-11 27-35 52-61 76q-33 31-72 59l-22 16-5 4-13 9-1 1-14 9a375 375 0 01-67 35l-11 4a199 199 0 01-41 8 303 303 0 01-110-11l-4-1c-39-9-77-23-116-32l-42-9-21-3a614 614 0 00-118 0l-9 1-10 3a187 187 0 00-27 11l-5 3-16 8a200 200 0 01-30 13 157 157 0 01-17 4 252 252 0 01-71 4h-1a361 361 0 01-44-5c-41-6-80-17-111-34-42-24-69-59-65-94 3-25 21-48 38-71 32-43 61-86 77-132 13-38 17-77 46-111 9-11 21-20 35-29a225 225 0 0133-16 282 282 0 0139-13 314 314 0 0136-7l19-2 15-1h11a437 437 0 0168 7l41 8 24 6 8 2c57 15 107 36 162 54a338 338 0 0035 9 503 503 0 0067 9h3l61 5 21 2 13 2 9 1 10 1a443 443 0 0144 7l22 4 16 3 12 3c31 8 61 18 86 32 65 36 95 96 73 148z" opacity=".1"/><circle cx="249" cy="68.8" r="21.6" fill="${color}" opacity=".1"/><circle cx="691.1" cy="21.6" r="21.6" fill="${color}" opacity=".1"/><circle cx="953.3" cy="70.1" r="21.6" fill="${color}" opacity=".1"/><circle cx="36.3" cy="121.1" r="36.3" fill="${color}" opacity=".1"/><circle cx="71" cy="300.1" r="36.3" fill="${color}" opacity=".1"/><circle cx="1043.9" cy="234.2" r="36.3" fill="${color}" opacity=".1"/><path fill="#be6f72" d="M354 239a39 39 0 010 9c-2 10-11 16-19 21s-17 9-22 18c-6 9-4 23 3 32s18 15 29 17c21 4 43-2 58-16s23-36 20-57c-9 1-16-6-19-14s-2-17-3-25a9 9 0 00-1-4c-1-2-3-2-5-3-10-3-26-8-36-6-9 2-5 21-5 28z"/><path d="M354 239a39 39 0 010 9c-2 10-11 16-19 21s-17 9-22 18c-6 9-4 23 3 32s18 15 29 17c21 4 43-2 58-16s23-36 20-57c-9 1-16-6-19-14s-2-17-3-25a9 9 0 00-1-4c-1-2-3-2-5-3-10-3-26-8-36-6-9 2-5 21-5 28z" opacity=".1"/><path fill="#be6f72" d="M343 682a200 200 0 01-30 13 157 157 0 01-17 4 108 108 0 011-23l2-13a34 34 0 00-4-19c12-1 22-4 33-3h1a12 12 0 014 1 11 11 0 014 4 26 26 0 012 2c3 6 4 12 4 18a121 121 0 010 16zM401 657l-10 3a187 187 0 00-27 11 40 40 0 01-1-8 46 46 0 0135-7 5 5 0 012 1 3 3 0 011 0z"/><path fill="#3f3d56" d="M418 607c0 7-1 13-4 19-2 7-6 13-6 20l2 10-9 1-10 3a187 187 0 00-27 11l-5 3h-3c-5-1-10-4-13-8a11 11 0 01-1-3c-2-4 0-11-3-14h-1a34 34 0 01-6 4 41 41 0 01-33 3 36 36 0 01-6-2c-5-3-9-7-9-13l2-8-3-6c-7-12 1-27-3-40v-1l-1-3-3-5a33 33 0 01-1-6 63 63 0 01-1-15c0-13 2-27 6-40l2-9a70 70 0 013-11c2-4 5-8 9-9 5-1 14 1 20 2l22 3 45 5a49 49 0 0123 7 25 25 0 015 5l1 2a42 42 0 014 7c6 13 6 28 6 43s0 30-2 45z"/><path d="M332 653l-4-14a188 188 0 01-4-21c-1-13-3-30 2-42 4 2 8 8 9 13 7 15 0 34 6 49a8 8 0 011 3 7 7 0 01-1 4l-3 4z" opacity=".1"/><path fill="#be6f72" d="M476 178c8-12 18-24 17-38l-3-15a94 94 0 01-1-43 49 49 0 0136 8c3 2 6 5 7 8 2 4 1 8 1 11 0 9-1 18-6 24l-5 6c-3 3-4 7-5 10l-17 47c-9 23-18 47-37 63-1 1-14-18-15-20-5-8-3-12 3-18 10-13 16-29 25-43z"/><path fill="#fbbebe" d="M281 572a77 77 0 01-1 10v4c-4 18-12 35-18 52-8 23-11 43-14 65h-24l-8-1c3-21-2-43 3-64 1-9 4-17 6-26a72 72 0 001-7l2-7a5 5 0 010-1 17 17 0 014-4 88 88 0 0143-21h6z"/><path d="M281 572a77 77 0 01-1 10v4c-4 18-12 35-18 52-8 23-11 43-14 65h-24l-8-1c3-21-2-43 3-64 1-9 4-17 6-26a72 72 0 001-7l2-7a5 5 0 010-1 17 17 0 014-4 88 88 0 0143-21h6z" opacity=".1"/><path fill="#fbbebe" d="M231 617a157 157 0 01-2 17l-5 69a361 361 0 01-44-5l3-15 2-19-3-18c-3-13-5-26-9-38a50 50 0 00-11-18c18-8 36-8 57-7a7 7 0 014 1 7 7 0 012 3 78 78 0 015 23 75 75 0 011 7z"/><circle cx="381.6" cy="195.2" r="39" fill="#be6f72"/><path fill="#e3e8f4" d="M390 286c5-8 9-19 19-21 5-2 11 0 16 2a8 8 0 014 2 8 8 0 011 5 271 271 0 010 53l-4 37c0 17 3 35 2 52-1 13-4 26-7 39l-12 54a9 9 0 01-2 4 9 9 0 01-3 2 132 132 0 01-107-8c-4-2-8-5-11-9-4-6-5-14-3-21l6-20c3-10 3-21 4-32 1-14 2-29 0-43l-5-29a323 323 0 01-4-45c0-9 0-18 6-25 3-3 7-5 11-6 7-3 15-4 22-2s12 9 11 17l-4 9c-1 4 2 9 5 12 18 16 46-11 55-27z"/><path fill="#3f3d56" d="M391 246a29 29 0 0117-1c4 1 8 3 11 1l3-2c4-1 8 1 11-2 2-1 2-3 3-6a53 53 0 0118-26c-1 7-2 16 3 22 2 3 5 4 9 6s10 3 15 2 9-5 10-10c0 7-7 13-9 20l-2 8c-1 7-6 13-10 19a132 132 0 00-27 63 31 31 0 01-1 8 50 50 0 01-4 6c-7 12-5 28-2 42a604 604 0 0019 76c-1 8-10 12-18 16a86 86 0 00-21 15c-2 2-5 4-5 7l-2 9c-1 3-5 4-6 2-3-8 1-17 1-25l-2-17c-1-7 1-13 3-19 6-18 13-35 15-53s-2-37-15-50c-15-16-23-36-39-50-3-3-6-5-5-9a9 9 0 011-4l19-22c6-8 11-16 10-26zM338 263l-3 3a9 9 0 01-5 1 145 145 0 01-17 2c-5 0-11-1-15 1-7 2-12 7-16 13s-5 13-6 20a266 266 0 00-5 46 121 121 0 0022-23c5-6 9-14 16-18l10-5c7-4 11-11 16-17 3-5 12-14 13-20 1-5-7-8-10-3zM373 168a32 32 0 013 3c7 5 16 4 24 3l7-2c4-2 6-7 5-11l-5-11a40 40 0 00-27-15 18 18 0 00-8 1l-9 6c-9 5-22 3-28 12-4 6-1 15-3 22-1 5-6 10-5 16l4 8a37 37 0 015 20c3 3 9-1 10-6l1-14c1-8 8-14 12-21 2-6 6-15 14-11z"/><path fill="#fbbebe" d="M278 257l1 6c2 3 6 2 10 2 5 1 9 6 11 12s-1 11-2 16q-5 19-12 37c-11-1-24-6-30-16-6-9-6-21-9-31-3-8-7-14-12-20 7 1 13-8 13-15s-2-15 0-22c0-2 29 4 32 5 8 6-1 18-2 26z"/><path d="M278 257l1 6c2 3 6 2 10 2 5 1 9 6 11 12s-1 11-2 16q-5 19-12 37c-11-1-24-6-30-16-6-9-6-21-9-31-3-8-7-14-12-20 7 1 13-8 13-15s-2-15 0-22c0-2 29 4 32 5 8 6-1 18-2 26z" opacity=".1"/><circle cx="271.6" cy="206.2" r="39" fill="#fbbebe"/><path fill="#3f3d56" d="M260 252v-8l3-3a13 13 0 004-5 57 57 0 005-38c-1-4-1-10 2-12a7 7 0 014 0c7 0 14 5 21 3a12 12 0 009-11c0-6-5-12-9-16-9-8-22-10-34-10h-21c-7 0-15 0-20 5-7 7-3 19-4 29a30 30 0 01-11 20c-5 3-11 7-11 13l1 5c3 8 1 16-4 23s-10 11-17 16c-3 2-7 4-9 7a23 23 0 00-5 13 17 17 0 002 11c4 6 14 7 21 4s11-12 14-19c2-5 4-10 8-12 5-2 12 2 15 7s6 10 10 14c7 6 20 5 26-2 4-5 5-12 5-19a28 28 0 00-5-15z"/><path fill="#f86d70" d="M274 302c-5 1-10-1-13-4l-8-11a196 196 0 00-20-28c-6-7-16-15-25-13a24 24 0 00-9 5 65 65 0 00-24 58l3 19a122 122 0 010 16c0 16-1 33-9 46-14 21-21 46-31 69-5 13-8 26-11 39l-6 23-12 51c-1 6-3 11-1 16 2 8 9 14 17 16s16 2 24 2c15 0 31 2 45 7 5 2 9 4 13 4l13-2c11-5 21-12 31-19a124 124 0 0121-9c3-2 7-3 10-6l3-8c3-16 1-32 0-48s-11-33-3-47c2-3 4-6 4-9l1-12 4-9c2-5 2-11 2-16a179 179 0 00-4-36c-3-15 7-30 13-44 3-6 6-10 7-16l-1-15a130 130 0 01-2-23c0-6 1-13-1-20s-6-13-13-15a5 5 0 00-4 1 6 6 0 00-2 3c-2 6-2 14-3 21s-3 13-9 14z"/><path fill="#be6f72" d="M179 345c1-2-1-6-3-6-3 0-4 3-4 6s0 6-2 7c-1 2-4 2-6 3a5 5 0 00-2 4l1 5c0 2-1 3-3 2a6 6 0 001 8l2 2a6 6 0 010 2c0 3 2 6 4 7-1 1-1 3 1 5s3 1 5 1a33 33 0 0012-3 8 8 0 004-2 3 3 0 000-4c2 0 4 1 5-1 2-2 0-5-2-7a4 4 0 002-7l-2-2c-1-1 1-1 1-2 1-1 0-3-2-4l-11-4c-3-2-1-7-1-10z"/><path fill="#3f3d56" d="M386 194a47 47 0 01-8 0 2 2 0 00-2 1l-4 35a14 14 0 01-3 7 15 15 0 00-4 12v59s0 8 6 8a88 88 0 0022 0s5-1 5-9v-58a14 14 0 00-3-11 15 15 0 01-3-7l-5-36a2 2 0 00-1-1z"/><path d="M386 194a47 47 0 01-8 0 2 2 0 00-2 1l-4 35a14 14 0 01-3 7 15 15 0 00-4 12v59s0 8 6 8a88 88 0 0022 0s5-1 5-9v-58a14 14 0 00-3-11 15 15 0 01-3-7l-5-36a2 2 0 00-1-1z" opacity=".1"/><rect width="29.5" height="49.8" x="367" y="250" fill="${color}" rx="11.1"/><path fill="#3f3d56" d="M485 43a46 46 0 01-7 3 2 2 0 00-1 2l9 34a14 14 0 010 7 15 15 0 001 12l23 55s3 7 8 5a87 87 0 0021-8s4-3 1-10l-23-54a14 14 0 00-7-9 15 15 0 01-5-5l-18-31a2 2 0 00-2-1z"/><rect width="29.5" height="49.8" x="530" y="188" fill="${color}" rx="11.1" transform="rotate(-23 295 247)"/><path fill="#fbbebe" d="M204 253c-11 4-15 18-13 29s11 21 18 30l21 25c5 7 12 15 20 17 13 4 26-4 37-12a552 552 0 01105-55c4-1 8-2 11-5 6-5 7-15 4-22s-11-12-20-12-15 4-20 11l-6 9c-6 8-15 13-24 17a589 589 0 01-64 28c-4 2-8 3-12 1l-5-5a140 140 0 01-15-32c-3-9-5-18-12-24-9-9-26-7-33 4 0 0-8 12-3 17s11-21 11-21zM765 211l1 13c0 5-1 11-6 13-3 1-7 0-10 2s-3 7-2 11c1 11 3 22 9 31l11 13c9 8 19 15 30 18a12 12 0 006 0 12 12 0 005-3c6-6 10-15 14-22 3-6 7-11 9-18a30 30 0 00-10-30l-6-5c-5-4-7-11-9-17s-1-13 0-20c-10-1-20 0-30 2l-14 4c-5 2 1 5 2 8z"/><path d="M765 211l1 13c0 5-1 11-6 13-3 1-7 0-10 2s-3 7-2 11c1 11 3 22 9 31l11 13c9 8 19 15 30 18a12 12 0 006 0 12 12 0 005-3c6-6 10-15 14-22 3-6 7-11 9-18a30 30 0 00-10-30l-6-5c-5-4-7-11-9-17s-1-13 0-20c-10-1-20 0-30 2l-14 4c-5 2 1 5 2 8z" opacity=".1"/><path fill="#fbbebe" d="M709 241c-16-6-24-28-41-30l-8-1c-10-2-14-14-17-23-9-32-22-64-40-92-7-12-19-22-24-35-2-3-2-7-4-9s-7-3-9 0a7 7 0 000 3l1 13-20-2a12 12 0 00-6 0 10 10 0 00-4 5c-7 13 0 30 13 38 14 10 34 11 43 25 6 9 6 20 10 29l6 13 9 27a231 231 0 0035 60l17 11c14 8 31 16 46 9 1-13-2-28-7-41zM758 671c-1 13-9 25-11 38l-36-8-4-1c7-18 1-38 3-57l1-5c15-5 28-12 44-10l1 9 2 19a78 78 0 010 15zM863 704a199 199 0 01-42 8c0-14-10-27-11-41a60 60 0 010-11v-4l3-29a44 44 0 017 0c13 0 25 6 38 10a90 90 0 011 19c-1 15-3 31 2 45l2 3z"/><path fill="#f86d70" d="M694 485c1 13-5 26-9 40-2 8-2 18-2 27l-2 54c0 6 0 11 2 16 3 11 13 18 24 21s22 1 33-1c5 0 11-1 15-4 6-5 9-12 11-19l7-20c7 17 4 35 9 53a10 10 0 002 5 225 225 0 0067 2c4-2 10-3 14-7 4-5 5-12 5-18-1-22-8-43-10-64l-1-28a186 186 0 00-2-21 28 28 0 00-2-9c-3-5-10-9-16-11-45-18-96-18-145-16z"/><circle cx="778.6" cy="173.2" r="43" fill="#fbbebe"/><path fill="#e3e8f4" d="M816 249c-3 7-8 14-16 16-6 1-14-2-19-7s-8-11-12-17c-2-5-5-9-9-12-6-4-14-4-21-3s-14 3-21 3c-9-1-18-5-26-2 3 12 2 25 1 38a17 17 0 01-1 5 18 18 0 01-2 5l-8 10c8 7 16 15 19 25l1 18c-1 18 3 36 2 54-1 21-10 41-14 61a160 160 0 00-2 54c45 15 91 23 138 26 9 0 18 1 25-4 5-4 9-11 10-18s0-14-1-21l-6-56-2-32 4-24 10-48c2-7 3-14 6-20l8-15a67 67 0 006-19 13 13 0 000-6c-1-4-4-6-7-7a215 215 0 00-59-21c-2 6-1 11-4 17z"/><path fill="#3f3d56" d="M812 220c5-9 14-16 20-26a38 38 0 001-35c-2-3-5-7-6-11l-4-14c-2-7-8-11-14-14s-13-3-20-4l-23-3h-10c-3 1-6 3-6 7-1 4 3 7 2 11l-1 4a4 4 0 002 2c6 3 12 3 18 5s12 7 11 13c0 4-2 7-1 10 2 3 5 3 8 4 9 3 16 13 15 23l-2 9c-1 10 1 13 9 19z"/><path fill="#be6f72" d="M870 266a15 15 0 01-1 6c-3 6-12 6-19 10-8 4-9 15-10 24-1 10-1 21 1 31s7 20 15 26c11 7 25 7 37 3s21-13 30-22c8-9 15-19 20-30l1-6c-1-3-5-4-7-6-6-4-11-10-13-17s-2-15-2-22 0-16-5-21-13-8-21-8c-6 0-23 1-27 6s2 19 1 26z"/><path d="M870 266a15 15 0 01-1 6c-3 6-12 6-19 10-8 4-9 15-10 24-1 10-1 21 1 31s7 20 15 26c11 7 25 7 37 3s21-13 30-22c8-9 15-19 20-30l1-6c-1-3-5-4-7-6-6-4-11-10-13-17s-2-15-2-22 0-16-5-21-13-8-21-8c-6 0-23 1-27 6s2 19 1 26z" opacity=".1"/><path fill="#be6f72" d="M817 534a9 9 0 002 4 8 8 0 003 2c33 9 68 5 102 1-4-14-9-28-10-43-1-12 0-25-5-36-1-4-75 12-83 13-4 1-8 1-11 4s-3 12-3 16c-1 13 1 26 5 39zM892 693l-19 7-10 4-19 5-11-28-7-20a128 128 0 01-4-15 103 103 0 012-50l41 7 22 3 2 15 2 22 1 50z"/><path d="M892 693l-19 7-10 4-19 5-11-28-7-20a128 128 0 01-4-15 103 103 0 012-50l41 7 22 3 2 15 2 22 1 50z" opacity=".1"/><path fill="#be6f72" d="M969 649l-3 18-1 1a16 16 0 01-9-7 19 19 0 01-2-5l-14 9a375 375 0 01-67 35l-4-14a131 131 0 01-3-15 75 75 0 014-33v-2a74 74 0 017-13c2-4 7-4 12-2l7 1c13 3 26 0 40 1a48 48 0 0118 5c7 3 12 8 14 15a22 22 0 010 3 27 27 0 011 3zM728 189c-21-20-44-37-68-53a187 187 0 01-18-13c-6-5-11-11-18-15s-14-8-22-6-14 8-13 16c1 7 7 11 13 15 10 8 21 15 33 21a103 103 0 0111 6c7 5 13 12 18 19a260 260 0 0074 63s12-26 12-29c-1-8-16-19-22-24z"/><path fill="#3f3d56" d="M905 512c-16 1-32 6-47 10s-33 4-47-2l9 60v10l-2 9c0 5 5 9 9 11a85 85 0 0043 10l-4 13c7 8 19 9 30 11l23 7a100 100 0 0029 5c7-1 14-1 19-6 7-5 9-13 10-22 1-4 2-9 1-13 0-5-2-10-4-15l-14-33-8-18c-10-19-26-38-47-37z"/><path fill="${color}" d="M917 304a15 15 0 0116-9c4 0 7 2 11 5l19 12a83 83 0 019 6c13 11 18 29 19 46s0 34 4 51l-25 19-12 11-7 11a26 26 0 01-17 10c4 3 6 8 8 12s1 10 2 15c2 7 6 13 7 20l1 14c1 25 21 46 20 71a107 107 0 01-26-13l-10-9-26-20c-12-10-25-20-35-33l-17-24c-6-7-14-15-23-19l-6 6a4 4 0 000 1 5 5 0 000 3 57 57 0 012 12l1 8a26 26 0 010 6c-1 6-7 11-14 12a6 6 0 01-2 0l-4-4c-2-9 2-18 2-27a64 64 0 000-7l-1-8c-6-2-9-8-11-14-4-15-8-31-6-47 1-4 2-8 1-13s-5-10-7-15c-7-18 8-37 7-55-1-8-6-15-9-22a62 62 0 00-6-12c-3-5-7-8-11-12a428 428 0 01-35-34 26 26 0 01-15-7c-3-3-5-6-5-10s2-7 6-7l6 1c7 1 13-3 16-9s3-13 3-20a19 19 0 0117 6c5 5 8 11 11 17a26 26 0 006 6c4 4 11 5 16 9l5 8c5 7 15 8 23 12s12 13 21 16l9 2c7 3 11 10 12 17s-1 15-2 22l-4 16c-1 4-2 9 1 11a11 11 0 005 3c7 2 14 4 21 1l8-7c9-11 16-27 21-41z"/><path fill="#be6f72" d="M996 644c-2 9-7 18-15 23a21 21 0 01-16 1 16 16 0 01-9-7 19 19 0 01-2-5v-1a44 44 0 01-1-10 141 141 0 011-17 91 91 0 013-14l7-19 3-10 2-6v-1-1l4-17c6-12 18-9 20 2a20 20 0 010 3c0 14-6 28-3 42a98 98 0 003 10l2 9a53 53 0 011 18z"/><path fill="${color}" d="M1001 487l1 18c3 13 13 25 12 39 0 3-1 7-4 8s-8 2-9 5v3c-1 2-3 3-5 3l-6-1c-7 1-10 10-17 14-4 2-10 1-13-3s-5-8-5-13l2-11v-20c-1-9-2-19-5-28l-5-13c-2-6-2-13-2-19-1-13 0-28 8-39 6-8 15-15 22-22 4-5 6-6 10-2 4 3 8 7 9 12 1 11 0 23 2 34s5 23 5 35z"/><circle cx="897.6" cy="216.2" r="51" fill="#be6f72"/><path fill="#3f3d56" d="M944 314c1-2 3-4 5-4a8 8 0 014 1l13 6a44 44 0 006-20l1-13 6-18c1-5-1-10-1-15-3-16 0-32-1-48s-8-33-22-40l-13-5c-9-3-17-9-26-13s-20-5-29-1-14 17-8 25l7 6c5 4 11 9 12 15 2 12-10 21-13 33a28 28 0 00-1 14c2 6 5 13 5 20 0 8-4 14-5 22l-1 8a43 43 0 01-3 11c-8 20-16 40-28 58a77 77 0 0037-8 61 61 0 01-10 21 69 69 0 0029-10 93 93 0 01-9 22l8-3a14 14 0 005-6c4-6 6-13 9-19a287 287 0 0123-39zM558 8a47 47 0 01-8 0 2 2 0 00-2 1l-4 35a14 14 0 01-3 7 15 15 0 00-4 12v59s0 8 6 8a88 88 0 0022 0s5-1 5-9V63a14 14 0 00-3-11 15 15 0 01-3-7l-5-36a2 2 0 00-1-1z"/><rect width="29.5" height="49.8" x="539" y="64" fill="${color}" rx="11.1"/><path fill="#3f3d56" d="M627 59a47 47 0 01-8 0 2 2 0 00-2 1l-4 35a14 14 0 01-3 7 15 15 0 00-4 12v59s0 8 6 8a88 88 0 0022 0s5-1 5-9v-58a14 14 0 00-3-11 15 15 0 01-3-7l-5-36a2 2 0 00-1-1z"/><rect width="29.5" height="49.8" x="608" y="115" fill="${color}" rx="11.1"/><g opacity=".2"><path fill="#3f3d56" d="M549 656a19 19 0 010 3l-21-3a17 17 0 012-9c2-3 5-5 9-5s6 2 8 6a17 17 0 012 8z"/><ellipse cx="571.2" cy="732.3" fill="#3f3d56" rx="14" ry="10.7" transform="rotate(-88 507 702)"/><ellipse cx="571.8" cy="715.2" fill="#3f3d56" rx="14" ry="10.7" transform="rotate(-88 507 685)"/><ellipse cx="572.3" cy="698.1" fill="#3f3d56" rx="14" ry="10.7" transform="rotate(-88 508 668)"/><ellipse cx="572.8" cy="681" fill="#3f3d56" rx="14" ry="10.7" transform="rotate(-88 508 651)"/><path fill="${color}" d="M504 469a50 50 0 01-4-6l29-4h-31a51 51 0 010-41l41 22-37-29a51 51 0 1183 60 51 51 0 015 10l-37 18 39-12a51 51 0 01-9 48 51 51 0 11-81-3 51 51 0 012-63z"/><path d="M595 504a51 51 0 01-12 31 51 51 0 11-81-3c-7-9 93-34 93-28z" opacity=".1"/></g></svg>
  `;

export const SUPPORT_SVG = () =>
  '<svg data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" width="979.32677" height="424.8366" viewBox="0 0 979.32677 424.8366" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M993.71816,412.83936H419.142a9.19888,9.19888,0,0,0,0,18.39776H435.417V651.3026a9.19888,9.19888,0,0,0,18.39776,0l.1398-220.06548h461.1557l42.52,220.06548a9.19887,9.19887,0,1,0,18.39775,0l2.67633-220.06548h15.01383a9.19888,9.19888,0,0,0,0-18.39776Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M518.73716,371.85047v38.9547H421.141a19.48915,19.48915,0,1,1-1.35523-38.95474q.67739-.02358,1.35523,0Z" transform="translate(-110.33661 -237.5817)" fill="#f2f2f2"/><path d="M521.13449,410.50552a1.49881,1.49881,0,0,1-1.49822,1.49822H419.40273a20.52615,20.52615,0,0,1,0-41.05229H519.63627a1.49827,1.49827,0,1,1,0,2.99653H419.40273a17.52964,17.52964,0,0,0,0,35.05924H519.63627A1.49883,1.49883,0,0,1,521.13449,410.50552Z" transform="translate(-110.33661 -237.5817)" fill="#000000"/><path d="M518.73716,380.84H413.85905a.29966.29966,0,0,1-.00552-.59929H518.73716a.29966.29966,0,0,1,0,.59929Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M518.73716,388.03169H413.85905a.29966.29966,0,0,1-.00552-.59929H518.73716a.29966.29966,0,0,1,0,.59929Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M518.73716,395.22332H413.85905a.29966.29966,0,0,1-.00552-.59929H518.73716a.29966.29966,0,0,1,0,.59929Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M518.73716,402.41487H413.85905a.29966.29966,0,0,1-.00552-.59929H518.73716a.29966.29966,0,0,1,0,.59929Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M500.33941,330.80932v38.95474H402.74324a19.48915,19.48915,0,0,1-1.35522-38.95474q.67737-.02358,1.35522,0Z" transform="translate(-110.33661 -237.5817)" fill="#f2f2f2"/><path d="M502.73673,369.46442a1.49885,1.49885,0,0,1-1.49822,1.49826H401.005a20.52614,20.52614,0,0,1,0-41.05229H501.23851a1.49826,1.49826,0,1,1,0,2.99652H401.005a17.52964,17.52964,0,0,0,0,35.05928H501.23851A1.49884,1.49884,0,0,1,502.73673,369.46442Z" transform="translate(-110.33661 -237.5817)" fill="#3f3d56"/><path d="M500.33941,339.79886H395.4613a.29966.29966,0,0,1-.00553-.59929H500.33941a.29966.29966,0,0,1,0,.59929Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M500.33941,346.99054H395.4613a.29966.29966,0,0,1-.00553-.59929H500.33941a.29966.29966,0,0,1,0,.59929Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M500.33941,354.18217H395.4613a.29966.29966,0,0,1-.00553-.59929H500.33941a.29966.29966,0,0,1,0,.59929Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M500.33941,361.37376H395.4613a.29966.29966,0,0,1-.00553-.59929H500.33941a.29966.29966,0,0,1,0,.59929Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M613.87355,550.68347V516.71838a5.661,5.661,0,0,0-5.66085-5.66085H479.4284a5.661,5.661,0,0,0-5.66084,5.66085v33.96509Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><rect x="363.43092" y="325.83868" width="140.10602" height="43.87158" fill="#ccc"/><path d="M473.76756,620.02887V653.994a5.661,5.661,0,0,0,5.66084,5.66084H608.2127a5.661,5.661,0,0,0,5.66085-5.66084V620.02887Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><circle cx="432.77633" cy="294.70402" r="4.24564" fill="#fff"/><circle cx="432.77633" cy="351.3125" r="4.24564" fill="#fff"/><circle cx="433.00385" cy="406.72228" r="4.24564" fill="#fff"/><path d="M597.989,472.33053v38.9547H500.39287a19.48916,19.48916,0,0,1-1.35647-38.9547q.678-.02358,1.35647,0Z" transform="translate(-110.33661 -237.5817)" fill="#f2f2f2"/><path d="M600.38637,510.98558a1.49881,1.49881,0,0,1-1.49822,1.49822H498.65461a20.52615,20.52615,0,0,1-.0247-41.05229H598.88815a1.49827,1.49827,0,1,1,0,2.99653H498.65461a17.52963,17.52963,0,0,0,0,35.05923H598.88815A1.49885,1.49885,0,0,1,600.38637,510.98558Z" transform="translate(-110.33661 -237.5817)" fill="#3f3d56"/><path d="M597.989,481.32H493.111a.29966.29966,0,0,1-.00553-.59929H597.98913a.29966.29966,0,0,1,0,.59929Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M597.989,488.51175H493.111a.29966.29966,0,0,1-.00553-.59929H597.98913a.29966.29966,0,0,1,0,.59929Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M597.989,495.70338H493.111a.29966.29966,0,0,1-.00553-.59929H597.98913a.29966.29966,0,0,1,0,.59929Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M597.989,502.89493H493.111a.29966.29966,0,0,1-.00553-.59929H597.98913a.29966.29966,0,0,1,0,.59929Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M483.36747,317.81415H438.90162a2.74745,2.74745,0,0,0-1.21689.28306l-11.22288,5.61835a2.0452,2.0452,0,0,0,0,3.76443l11.22288,5.61835a2.74718,2.74718,0,0,0,1.21689.28306h44.46585a2.33381,2.33381,0,0,0,2.4628-2.16532v-11.2367A2.3338,2.3338,0,0,0,483.36747,317.81415Z" transform="translate(-110.33661 -237.5817)" fill="#3f3d56"/><path d="M485.83027,319.97947v11.2367a2.33383,2.33383,0,0,1-2.4628,2.16532h-8.8589V317.81415h8.8589A2.33383,2.33383,0,0,1,485.83027,319.97947Z" transform="translate(-110.33661 -237.5817)" fill="#000000"/><path d="M216.78083,537.99332a35.33951,35.33951,0,0,0,34.12552-6.01134c11.95262-10.03214,15.70013-26.56,18.74934-41.864q4.50949-22.63308,9.019-45.26617l-18.88217,13.00153c-13.57891,9.34993-27.46375,18.99939-36.86572,32.54233S209.42082,522.42587,216.975,537.08" transform="translate(-110.33661 -237.5817)" fill="#e6e6e6"/><path d="M218.39489,592.79741c-1.91113-13.92071-3.87625-28.0202-2.53572-42.09016,1.19057-12.4956,5.00277-24.70032,12.764-34.70734a57.73582,57.73582,0,0,1,14.81307-13.42309c1.48131-.935,2.84468,1.41257,1.36983,2.34348a54.88844,54.88844,0,0,0-21.71125,26.19626c-4.72684,12.02273-5.48591,25.12848-4.67135,37.90006.4926,7.72345,1.53656,15.39627,2.58859,23.05926a1.40615,1.40615,0,0,1-.94781,1.66928,1.3653,1.3653,0,0,1-1.6693-.94781Z" transform="translate(-110.33661 -237.5817)" fill="#f2f2f2"/><path d="M236.80246,568.16434a26.01425,26.01425,0,0,0,22.6665,11.69871c11.47417-.54466,21.04-8.55293,29.651-16.15584l25.46969-22.48783-16.85671-.80672c-12.12234-.58011-24.55745-1.12124-36.10356,2.617s-22.19457,12.73508-24.30583,24.68624" transform="translate(-110.33661 -237.5817)" fill="#e6e6e6"/><path d="M212.99392,600.79976c9.19853-16.27621,19.86805-34.36538,38.93262-40.14695A43.445,43.445,0,0,1,268.3022,558.962c1.73863.14991,1.30448,2.82994-.431,2.6803a40.36111,40.36111,0,0,0-26.133,6.91386c-7.36852,5.01554-13.10573,11.98848-17.96161,19.383-2.97439,4.52936-5.63867,9.25082-8.30346,13.966-.85161,1.50687-3.34078.41915-2.47922-1.10534Z" transform="translate(-110.33661 -237.5817)" fill="#f2f2f2"/><path d="M198.25523,617.93168a19.69836,19.69836,0,0,1,12.0709-16.49847v-9.40956h15.782v9.70608a19.68812,19.68812,0,0,1,11.41362,16.202l3.711,43.13835H194.54417Z" transform="translate(-110.33661 -237.5817)" fill="#f2f2f2"/><path d="M734.973,411.955l-4.69488-1.97685-3.22067-23.53551h-42.889l-3.491,23.43936-4.20031,2.10013a.99744.99744,0,0,0,.44611,1.88955h57.66283A.99739.99739,0,0,0,734.973,411.955Z" transform="translate(-110.33661 -237.5817)" fill="#e6e6e6"/><path d="M811.1898,389.574H600.50692a4.174,4.174,0,0,1-4.16467-4.174V355.69092H815.35446V385.4A4.17408,4.17408,0,0,1,811.1898,389.574Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/><path d="M815.57469,369.73213H596.15V242.61337a5.0375,5.0375,0,0,1,5.03186-5.03167h209.361a5.03755,5.03755,0,0,1,5.03191,5.03167Z" transform="translate(-110.33661 -237.5817)" fill="#3f3d56"/><path d="M802.46932,360.50584h-193.214a3.88344,3.88344,0,0,1-3.87919-3.87908V250.68707a3.88365,3.88365,0,0,1,3.87919-3.87932h193.214a3.88366,3.88366,0,0,1,3.8792,3.87932V356.62676A3.88345,3.88345,0,0,1,802.46932,360.50584Z" transform="translate(-110.33661 -237.5817)" fill="#fff"/><path d="M751.57964,397.88662a11.6159,11.6159,0,0,1,17.666,2.27241l26.13446-4.64642,6.69716,15.19317-36.99908,6.04328a11.67883,11.67883,0,0,1-13.49855-18.86244Z" transform="translate(-110.33661 -237.5817)" fill="#ffb6b6"/><path d="M775.77611,417.286l27.24571-.33963,3.44882-.04668,55.43253-.69843s15.05312-14.3609,28.16068-29.1465l-1.83719-13.28833A54.29159,54.29159,0,0,0,870.023,340.1519C851.24988,352.696,840.363,377.52559,840.363,377.52559l-34.37018,8.22071-3.43848.82227-21.35608,5.10326Z" transform="translate(-110.33661 -237.5817)" fill="#000000"/><path d="M915.25011,498.96167H864.39249c0,2.17915-55.59414,3.94772-55.59414,3.94772a20.30858,20.30858,0,0,0-3.33166,3.15818,19.59694,19.59694,0,0,0-4.58,12.63271v3.15818a19.74588,19.74588,0,0,0,19.73861,19.73861h94.62478a19.75579,19.75579,0,0,0,19.73862-19.73861v-3.15818A19.76607,19.76607,0,0,0,915.25011,498.96167Z" transform="translate(-110.33661 -237.5817)" fill="#e4e4e4"/><rect x="747.4019" y="303.23122" width="20.52816" height="118.48951" fill="#e4e4e4"/><path d="M799.31222,658.58132c0,2.218,31.10721.858,69.47992.858s69.47991,1.36012,69.47991-.858-31.1072-19.807-69.47991-19.807S799.31222,656.36323,799.31222,658.58132Z" transform="translate(-110.33661 -237.5817)" fill="#e4e4e4"/><polygon points="675.186 407.461 659.908 407.46 652.64 348.531 675.188 348.532 675.186 407.461" fill="#ffb6b6"/><path d="M789.41863,659.852l-49.2623-.00183v-.62309a19.17528,19.17528,0,0,1,19.17426-19.17395h.00122l30.08773.00122Z" transform="translate(-110.33661 -237.5817)" fill="#2f2e41"/><polygon points="630.031 407.461 614.753 407.46 607.485 348.531 630.033 348.532 630.031 407.461" fill="#ffb6b6"/><path d="M744.2636,659.852l-49.2623-.00183v-.62309a19.1753,19.1753,0,0,1,19.17426-19.17395h.00122l30.08773.00122Z" transform="translate(-110.33661 -237.5817)" fill="#2f2e41"/><circle cx="766.88656" cy="41.63615" r="26.56401" fill="#ffb6b6"/><path d="M920.21655,461.22417s8.91308,47.1307-24.99958,53.13247-82.86639,10.21993-82.86639,10.21993L790.36706,627.14324l-29.53443-2.63675s3.928-123.46737,13.5876-133.127,70.71212-38.58282,70.71212-38.58282Z" transform="translate(-110.33661 -237.5817)" fill="#2f2e41"/><path d="M853.98286,441.47135,839.151,456.35062s-107.0941,17.25-111.22553,41.9852c-6.23747,37.34427-13.60493,118.552-13.60493,118.552l32.1988-2.41491,12.62647-92.31123,51.5182-11.71874L869.27729,478.5Z" transform="translate(-110.33661 -237.5817)" fill="#2f2e41"/><path d="M902.78526,263.36115c-2.6223-4.94751-5.95413-14.80785-11.24679-16.63657a42.07731,42.07731,0,0,0-9.05841-1.92972l-8.99618,3.46009,4.89616-3.808q-1.42988-.08519-2.85817-.13928l-6.0699,2.33453,3.10542-2.41532c-5.65883-.05808-11.5.53031-15.88468,3.9752-3.73817,2.93677-7.44169,14.06185-8.04057,18.77753a35.9171,35.9171,0,0,0,.6603,13.53055l1.53716,1.46166a18.85936,18.85936,0,0,0,1.206-3.83883,18.18056,18.18056,0,0,1,8.70263-11.80641l.08368-.0472c2.5782-1.451,5.7065-1.3841,8.66308-1.27769l14.04158.50527c3.37829.12158,7.01608.33533,9.64978,2.45443a15.888,15.888,0,0,1,3.85826,5.58929c1.30868,2.6414,3.8661,12.60418,3.8661,12.60418s1.44689-1.88062,2.1404-.48092a48.39766,48.39766,0,0,0,2.01437-11.23347A22.00877,22.00877,0,0,0,902.78526,263.36115Z" transform="translate(-110.33661 -237.5817)" fill="#2f2e41"/><path d="M995.69426,290.88349A11.61582,11.61582,0,0,0,985.181,305.26136l-21.3614,15.75722,6.40951,15.31674,29.8539-22.67594a11.67883,11.67883,0,0,0-4.38876-22.77589Z" transform="translate(-110.33661 -237.5817)" fill="#ffb6b6"/><path d="M992.25627,323.052l-53.551,59.4744s-25.60913-8.19816-45.41466-17.08624l-8.8977-27.32787a54.34329,54.34329,0,0,1-2.60112-19.66442c27.45606-7.306,59.391,19.87863,59.391,19.87863l40.08517-31.39877Z" transform="translate(-110.33661 -237.5817)" fill="#000000"/><path d="M867.301,465.6169c-9.554-3.30029-19.43312-6.71277-30.08912-7.99385l-.45773-.05533.12632-.443c11.03073-38.7308,8.27761-63.50657,2.87195-100.72306a37.59072,37.59072,0,0,1,21.5483-39.50121l.06542-.02958,30.43436-1.93391.06935-.00423,22.13437,6.50989a15.18313,15.18313,0,0,1,10.86724,14.83111c-.23987,12.23937.26868,25.9043.80711,40.37114,1.20787,32.45569,2.45686,66.01647-4.63045,87.79166l-.03718.11412-.09462.07416a36.09883,36.09883,0,0,1-23.08086,8.10758C887.90057,472.73235,877.76186,469.23034,867.301,465.6169Z" transform="translate(-110.33661 -237.5817)" fill="#000000"/><path d="M1088.24817,662.4183H111.75183a1.41521,1.41521,0,1,1,0-2.83042h976.49634a1.41521,1.41521,0,1,1,0,2.83042Z" transform="translate(-110.33661 -237.5817)" fill="#ccc"/></svg>';

export const WELCOME_SVG = (color) =>
  `<svg data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" width="613.35286" height="700.56123" viewBox="0 0 613.35286 700.56123" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M587.667,756.93133l-.78168-17.57606q-.12187-.06468-.24405-.12879c-8.37606-4.39513-17.97576,3.561-15.3004,12.63392,2.51722,8.5366,4.20846,17.73958,8.81613,25.21162a34.14441,34.14441,0,0,0,25.03847,15.77861l10.64166,6.51555a57.21525,57.21525,0,0,0-12.05953-46.36368,55.2668,55.2668,0,0,0-10.157-9.4375C591.07189,750.28541,587.667,756.93133,587.667,756.93133Z" transform="translate(-293.32357 -99.71938)" fill="#f2f2f2"/><path d="M492.3909,578.56387c-20.48783-21.12931-50.17767-33.24712-81.45666-33.24712l-1.20652.00324a116.3146,116.3146,0,0,1-58.63546-15.83485l-1.85205-1.07912,1.49167-1.537a113.37272,113.37272,0,0,0,19.99317-28.30616,34.28239,34.28239,0,0,1-27.66751,8.93789,35.10416,35.10416,0,0,1-25.77016-16.50626c-10.93231-17.73787-23.96381-42.90658-23.96381-62.0803a116.66888,116.66888,0,0,1,38.0631-86.091,72.65143,72.65143,0,0,0,23.99981-54.17137l-.00607-1.45284a164.77416,164.77416,0,0,1,4.8908-39.87268l.33005-1.31694,1.355.04732a111.39121,111.39121,0,0,0,26.04681-2.1821,87.918,87.918,0,0,1-23.35954-6.213l-1.45769-.58971.4947-1.4937C397.78172,214.464,474.7579,225.398,519.43718,123.17462,555.666,40.28535,683.49348,196.75549,683.49348,287.199c0,9.2287-9.13324,21.42423-2.29615,27.52391,73.90979,65.93827,22.91308,108.27972,6.83466,150.88534-3.81479,10.10871,4.45682,21.20613,4.45682,32.14249,0,1.85569-.04732,3.77124-.14076,5.69327l-.14237,2.955-2.46441-1.63971a81.62563,81.62563,0,0,1-13.47964-11.05649,71.13531,71.13531,0,0,1-2.25612,61.41172c-7.74552,14.619-15.23907,25.085-22.27193,31.10507a116.2904,116.2904,0,0,1-159.34268-7.65574Z" transform="translate(-293.32357 -99.71938)" fill="#e6e6e6"/><path d="M616.13152,798.499a2.09333,2.09333,0,0,0,2.06993-1.79837c.08893-.62489,8.80049-63.45379.97652-146.956-7.22548-77.11632-30.4294-188.191-99.9393-279.41478a2.0935,2.0935,0,1,0-3.33028,2.53775c68.90954,90.436,91.9264,200.69567,99.10094,277.2675,7.77849,83.01636-.86476,145.3553-.953,145.97542a2.09519,2.09519,0,0,0,2.0752,2.38851Z" transform="translate(-293.32357 -99.71938)" fill="#3f3d56"/><path d="M559.40732,499.0052a2.09343,2.09343,0,0,0,1.23242-3.78686c-.25231-.18331-25.681-18.50562-63.69657-32.425-35.14253-12.86589-88.582-24.5297-143.597-7.02036a2.0932,2.0932,0,1,0,1.26956,3.98925c53.88785-17.14953,106.35862-5.67858,140.88784,6.96312,37.47293,13.72044,62.427,31.7,62.67472,31.87988A2.08515,2.08515,0,0,0,559.40732,499.0052Z" transform="translate(-293.32357 -99.71938)" fill="#3f3d56"/><path d="M655.2196,260.37275a2.09343,2.09343,0,0,0-3.68827-1.50192c-.201.23845-20.307,24.28166-36.928,61.19609-15.36327,34.12475-30.84523,86.58548-17.34326,142.71855a2.09319,2.09319,0,1,0,4.07031-.979c-13.22427-54.983,1.99558-106.49141,17.09108-140.02058,16.38342-36.38756,36.11335-59.982,36.31062-60.21616A2.0852,2.0852,0,0,0,655.2196,260.37275Z" transform="translate(-293.32357 -99.71938)" fill="#3f3d56"/><path d="M652.38648,368.31675c1.76623,14.25037,11.64059,26,26,26a26,26,0,0,0,26-26c0-14.3594-11.70215-24.67241-26-26C663.21558,340.90809,650.11884,350.02107,652.38648,368.31675Z" transform="translate(-293.32357 -99.71938)" fill="#2f2e41"/><polygon points="397.105 687.328 407.006 687.327 411.716 649.137 397.103 649.138 397.105 687.328" fill="#ffb6b6"/><path d="M690.08055,797.37579l30.447-.00116v-.385A11.85149,11.85149,0,0,0,708.67674,785.139H708.676l-5.56152-4.21923-10.37659,4.21991-2.65783.00006Z" transform="translate(-293.32357 -99.71938)" fill="#2f2e41"/><polygon points="358.105 687.328 368.006 687.327 372.716 649.137 358.103 649.138 358.105 687.328" fill="#ffb6b6"/><path d="M651.08055,797.37579l30.447-.00116v-.385A11.85149,11.85149,0,0,0,669.67674,785.139H669.676l-5.56152-4.21923-10.37659,4.21991-2.65783.00006Z" transform="translate(-293.32357 -99.71938)" fill="#2f2e41"/><path d="M724.50065,547.85614l7,24L723.25419,673.501s4.24646,6.35511,1.24646,6.35511-6.84686,1.40942-4.4234,5.20471-5.86,17.4209-5.86,17.4209l-11.71661,72.37439-14.92914-.22046s-7.59009-4.22833-3.3305-8.504,7.25958-4.27557,3.25958-8.27557-4-2.79529-4-5.89765-4.00751-41.01574,5.49628-55.559l-2.86365-59.29529-6.74457,58.16144-13.888,77.59052-14.38171-.11847s-6.64276-6.40271-6.6305-11.14209,4.10419-5.13312,1.05823-7.93628-3.046-45.86615,5.954-69.80316c0,0,5.09108-13.37393-.01155-17.95666s-.00631-9.82652-.00631-9.82652,8.08172-2.92145-.0073-11.33883-.04369-67.94913-.04369-67.94913-8.84271-24.03067.1131-33.47977S724.50065,547.85614,724.50065,547.85614Z" transform="translate(-293.32357 -99.71938)" fill="#2f2e41"/><path d="M599.82611,589.20574l12.48925-30.1823,9.84,5.46667-5.94253,30.70307a10.93464,10.93464,0,1,1-16.38671-5.98744Z" transform="translate(-293.32357 -99.71938)" fill="#ffb6b6"/><path d="M809.4002,350.535l-19.00315,26.56751-8.34544-7.554,12.7447-28.5581A10.93464,10.93464,0,1,1,809.4002,350.535Z" transform="translate(-293.32357 -99.71938)" fill="#ffb6b6"/><path d="M726.38648,550.31675c12.32568,19.11831-49.63137,43.38055-73.40448,33.64-4.1628-1.7056-18.48212-7.33918-8.69439-15.14958s-1.1348-8.90952-1.393-13.99392c-.1726-3.39918,2.45917-10.85592-.28674-10.5362s-5.95975-4.3811.0205-6.404.06411-3.86767.11651-5.78787c.57186-20.95538,16.64979-54.2869,16.64979-54.2869l-28.971,74.05682s.214,12.81223-3.48049,8.897-3.42565,8.75675-3.42565,8.75675-5.49354,3.83389-2.33452,5.9676-3.401,8.6937-3.401,8.6937l-15.30666-1.09334s.23964-11.37068,2.85315-13.88533,1.32975-6.47144,1.32975-6.47144,6.80457-6.02348,2.24268-10.91429c-5.86712-6.29013,15.52417-112.52993,22.90637-111.47784a28.12048,28.12048,0,0,1,20.08017-21.45161l16.53221-4.55191,2.93564-11.64749h23.27852l4.0548,7.65333,17.69783,7.98657c3.33362-4.70352,5.82477-9.65991,19.47546-11.26657,0,0,36.78255-33.46683,34.98668-36.08s3.906-8.73109,3.906-8.73109,4.86956-1.59377,2.12179-2.44467,2.446-2.81826,2.446-2.81826,4.81028-1.264,2.54157-2.92832,7.57128-2.75765,7.57128-2.75765l12.767,10.4168-2.58037,4.37541s1.5733,5.958-.48,3.78289-2.43983,4.1371-2.43983,4.1371-1.0486,6.912-7.26682,8.99446S778.502,404.8635,778.502,404.8635c-14.6648,19.0673-31.97132,33.9415-52.48,43.73331C734.01483,457.77113,726.38648,550.31675,726.38648,550.31675Z" transform="translate(-293.32357 -99.71938)" fill="${color}"/><circle cx="387.93692" cy="273.08556" r="23.0557" fill="#ffb6b6"/><path d="M657.38648,375.31675c.73,5.01,5,12,4,12s-8.11-20.65332-1-22c5.15722-.97681,6.31-.12,11.13-2.21l-.68.64c3.19,2.32,7.63.89,11.27-.62,3.65-1.5,8.08-2.93,11.28-.62,2.01,1.45,2.86,3.97,4.11,6.11,1.25,2.15,3.56,4.18,5.94,3.52,1.91-.53,3.01-2.67005,3-4.65s-2.58825-3.86355-1.72-5.64c2.57319-5.26444.25916-8.85275-5.35-11.33q-3.06-.465-6.12-.95a17.35842,17.35842,0,0,1,3.84-3.86,8.77436,8.77436,0,0,0-3.1-3.97c-1.63-.97-3.65-.9-5.54-.8q-6.33.33-12.65.66c-3.12.16-6.35.35-9.13995,1.78-3.48,1.79-5.76,5.28-7.42005,8.83C655.51648,360.18675,656.10645,366.60679,657.38648,375.31675Z" transform="translate(-293.32357 -99.71938)" fill="#2f2e41"/><path d="M561.476,799.97328l226.75.30734a1.19068,1.19068,0,1,0,0-2.38137l-226.75-.30733a1.19068,1.19068,0,0,0,0,2.38136Z" transform="translate(-293.32357 -99.71938)" fill="#cacaca"/><ellipse cx="471.98821" cy="695.09416" rx="5.25681" ry="7.55666" transform="translate(-577.14417 962.36498) rotate(-81.72174)" fill="#e6e6e6"/><ellipse cx="521.15973" cy="690.29611" rx="5.2568" ry="7.55666" transform="translate(-530.30434 1006.91693) rotate(-81.72174)" fill="#3f3d56"/><ellipse cx="458.5236" cy="655.286" rx="5.25681" ry="7.55666" transform="translate(-549.27676 914.96411) rotate(-81.72174)" fill="#ff6584"/><ellipse cx="441.31304" cy="640.04291" rx="4.77581" ry="3.3223" transform="translate(-495.37215 976.78425) rotate(-89.56675)" fill="#e6e6e6"/><ellipse cx="434.06731" cy="609.6713" rx="4.77581" ry="3.3223" transform="translate(-472.19234 939.39678) rotate(-89.56675)" fill="#3f3d56"/><ellipse cx="490.41248" cy="663.12322" rx="4.77581" ry="3.3223" transform="translate(-469.72363 1048.78806) rotate(-89.56675)" fill="#e6e6e6"/><ellipse cx="466.65067" cy="674.98721" rx="4.77581" ry="3.3223" transform="translate(-505.16941 1036.80122) rotate(-89.56675)" fill="#ff6584"/><ellipse cx="499.72794" cy="696.91495" rx="4.77581" ry="3.3223" transform="translate(-494.26937 1091.63947) rotate(-89.56675)" fill="#3f3d56"/><ellipse cx="849.98821" cy="541.09416" rx="5.25681" ry="7.55666" transform="translate(-101.17347 1204.59943) rotate(-81.72174)" fill="#e6e6e6"/><ellipse cx="899.15973" cy="536.29611" rx="5.2568" ry="7.55666" transform="translate(-54.33364 1249.15138) rotate(-81.72174)" fill="#3f3d56"/><ellipse cx="836.5236" cy="501.286" rx="5.25681" ry="7.55666" transform="matrix(0.14398, -0.98958, 0.98958, 0.14398, -73.30606, 1157.19856)" fill="#ff6584"/><ellipse cx="819.31304" cy="486.04292" rx="4.77581" ry="3.3223" transform="translate(33.76519 1201.93792) rotate(-89.56675)" fill="#e6e6e6"/><ellipse cx="812.06731" cy="455.6713" rx="4.77581" ry="3.3223" transform="translate(56.94499 1164.55045) rotate(-89.56675)" fill="#3f3d56"/><ellipse cx="868.41248" cy="509.12322" rx="4.77581" ry="3.3223" transform="translate(59.41371 1273.94173) rotate(-89.56675)" fill="#e6e6e6"/><ellipse cx="844.65067" cy="520.98721" rx="4.77581" ry="3.3223" transform="translate(23.96793 1261.95489) rotate(-89.56675)" fill="#ff6584"/><ellipse cx="877.72794" cy="542.91495" rx="4.77581" ry="3.3223" transform="translate(34.86796 1316.79314) rotate(-89.56675)" fill="#3f3d56"/><ellipse cx="666.98821" cy="256.09416" rx="5.25681" ry="7.55666" transform="translate(24.20544 779.54069) rotate(-81.72174)" fill="#fff"/><ellipse cx="716.15973" cy="251.29611" rx="5.2568" ry="7.55666" transform="translate(71.04527 824.09264) rotate(-81.72174)" fill="#3f3d56"/><ellipse cx="653.5236" cy="216.286" rx="5.25681" ry="7.55666" transform="translate(52.07285 732.13983) rotate(-81.72174)" fill="#ff6584"/><ellipse cx="636.31304" cy="201.04292" rx="4.77581" ry="3.3223" transform="translate(137.1408 736.09819) rotate(-89.56675)" fill="#e6e6e6"/><ellipse cx="629.06731" cy="170.6713" rx="4.77581" ry="3.3223" transform="translate(160.32061 698.71071) rotate(-89.56675)" fill="#3f3d56"/><ellipse cx="685.41248" cy="224.12322" rx="4.77581" ry="3.3223" transform="translate(162.78933 808.102) rotate(-89.56675)" fill="#e6e6e6"/><ellipse cx="661.65067" cy="235.98721" rx="4.77581" ry="3.3223" transform="translate(127.34354 796.11516) rotate(-89.56675)" fill="#ff6584"/><ellipse cx="694.72794" cy="257.91495" rx="4.77581" ry="3.3223" transform="translate(138.24358 850.95341) rotate(-89.56675)" fill="#3f3d56"/></svg>`;

export const NOTESNOOK_LOGO_SVG = `<svg width="1024" height="1024" viewBox="0 0 1024 1024" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_24_33)">
<path d="M1024 0H0V1024H1024V0Z" fill="black"/>
<path d="M724.985 682.919C707.73 733.33 673.15 775.984 627.397 803.291C581.645 830.598 527.687 840.787 475.128 832.044C422.568 823.301 374.814 796.194 340.365 755.546C305.916 714.898 287.006 663.347 287 610.064V499.814L366.121 532.867V610.019C366.114 630.798 370.555 651.337 379.145 670.256C387.735 689.176 400.276 706.037 415.925 719.707C418.895 722.294 421.978 724.814 425.161 727.166C448.518 744.554 476.563 754.518 505.655 755.763C506.645 755.763 507.601 755.842 508.58 755.864C509.559 755.887 510.83 755.864 511.955 755.864C513.08 755.864 514.205 755.864 515.33 755.864C516.455 755.864 517.265 755.864 518.255 755.763C547.336 754.515 575.371 744.56 598.726 727.188C601.899 724.837 604.981 722.328 607.963 719.741C628.519 701.761 643.619 678.375 651.545 652.241L724.985 682.919Z" fill="white"/>
<path d="M737 414V610.065C737 612.596 737 615.139 736.842 617.67L657.879 584.651V414C657.866 376.316 643.272 340.099 617.154 312.934C591.035 285.77 555.419 269.766 517.765 268.274C480.11 266.782 443.339 279.918 415.154 304.931C386.968 329.944 369.554 364.893 366.56 402.457C366.279 406.26 366.121 410.119 366.121 414V462.712L287 429.637V189H512C571.674 189 628.903 212.705 671.099 254.901C713.295 297.097 737 354.326 737 414Z" fill="white"/>
</g>
<defs>
<clipPath id="clip0_24_33">
<rect width="1024" height="1024" rx="200" fill="white"/>
</clipPath>
</defs>
</svg>`;

export const ANDROID_POLICE_SVG = `<svg id="Layer_2" data-name="Layer 2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 140 84.34">
  <defs>
    <style>
      .cls-1 {
        fill: #f00;
        stroke-width: 0px;
      }
    </style>
  </defs>
  <g id="Layer_1-2" data-name="Layer 1">
    <g>
      <path class="cls-1" d="M44.18,55.74l7.41,12.99H3.42c-2.62,0-4.27-2.83-2.96-5.11L35.93,1.66c1.26-2.2,4.43-2.21,5.71-.02l36.36,62.46c1.19,2.05-.29,4.63-2.66,4.63l-12.93-.1-23.57-42.46-16.8,29.44,22.15.13Z"/>
      <path class="cls-1" d="M108,49.31l7.59,12.88,23.95-41.79c1.3-2.28-.34-5.11-2.96-5.11l-71.4-.04c-2.54,0-4.12,2.74-2.86,4.94l36.11,62.61c1.19,2.06,4.16,2.05,5.34,0l6.35-11.26-25.11-41.57,33.9.06-10.91,19.28Z"/>
    </g>
  </g>
</svg>`;

export const APPLE_INSIDER_SVG = `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1080" height="300" viewBox="190 316.67 1080 300" xml:space="preserve">
<desc>Created with Fabric.js 5.2.4</desc>
<defs>
</defs>
<rect x="0" y="0" width="100%" height="100%" fill="transparent"></rect>
<g transform="matrix(1 0 0 1 540 150)" id="5dcc1cd7-5787-4f32-b637-d599b35b1af0"  >
<rect style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1; visibility: hidden;" vector-effect="non-scaling-stroke"  x="-540" y="-150" rx="0" ry="0" width="1080" height="300" />
</g>
<g transform="matrix(Infinity NaN NaN Infinity 0 0)" id="b497d6a8-4f2c-4700-9634-868d954af08f"  >
</g>
<g transform="matrix(1.78 0 0 1.78 986.07 451.06)"  >
<path style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(106,115,125); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  transform=" translate(-458.95, -310)" d="M 588.4 347.8 L 588.4 312.40000000000003 C 588.4 304.6 588.4 299.50000000000006 588.1 295.00000000000006 L 602.2 295.00000000000006 L 602.8000000000001 304.6000000000001 L 603.1 304.6000000000001 C 605.8000000000001 296.80000000000007 612.1 293.50000000000006 617.5 293.50000000000006 C 619 293.50000000000006 619.9 293.50000000000006 621.1 293.80000000000007 L 621.1 309.4000000000001 C 619.9 309.1000000000001 618.4 309.1000000000001 616.6 309.1000000000001 C 610.6 309.1000000000001 606.4 312.4000000000001 605.5 317.50000000000006 C 605.2 318.70000000000005 605.2 319.90000000000003 605.2 321.1000000000001 L 605.2 347.80000000000007 C 605.2 347.8 588.4 347.8 588.4 347.8 z M 577.9 326.5 L 543.6999999999999 326.5 C 543.9999999999999 333.4 550.9 336.7 558.6999999999999 336.7 C 564.4 336.7 568.9 335.8 573.4 334.3 L 575.5 345.40000000000003 C 570.1 347.8 563.5 348.70000000000005 556.3 348.70000000000005 C 538.3 348.70000000000005 528.0999999999999 338.20000000000005 528.0999999999999 321.70000000000005 C 528.0999999999999 308.20000000000005 536.4999999999999 293.50000000000006 554.8 293.50000000000006 C 571.9 293.50000000000006 578.5 306.70000000000005 578.5 319.90000000000003 C 578.5 322.9 578.2 325.3 577.9 326.5 z M 543.7 315.4 L 563.2 315.4 C 563.2 311.5 561.4000000000001 304.59999999999997 553.9000000000001 304.59999999999997 C 547 304.6 544.3 310.9 543.7 315.4 z M 501.7 271 L 518.2 271 L 518.2 331.9 C 518.2 337.9 518.5 344.2 518.5 347.79999999999995 L 503.8 347.79999999999995 L 503.2 339.99999999999994 L 502.9 339.99999999999994 C 499.59999999999997 345.69999999999993 493.29999999999995 348.99999999999994 486.4 348.99999999999994 C 473.79999999999995 348.99999999999994 463.9 338.19999999999993 463.9 321.69999999999993 C 463.9 303.69999999999993 475 293.49999999999994 487.59999999999997 293.49999999999994 C 494.2 293.49999999999994 499.29999999999995 295.8999999999999 501.7 299.49999999999994 L 502 299.49999999999994 L 502 271 L 501.7 271 z M 501.7 324.1 L 501.7 317.20000000000005 C 501.7 316.30000000000007 501.7 315.1 501.4 314.20000000000005 C 500.5 310.00000000000006 496.9 306.1 491.79999999999995 306.1 C 484.29999999999995 306.1 480.4 312.70000000000005 480.4 321.1 C 480.4 330.1 484.9 335.8 491.5 335.8 C 496.3 335.8 500.2 332.5 501.1 328 C 501.4 326.8 501.7 325.6 501.7 324.1 z M 445.6 271.9 C 451 271.9 454 275.5 454.3 280 C 454.3 284.5 451 288.1 445.3 288.1 C 440.2 288.1 436.90000000000003 284.5 436.90000000000003 280 C 436.6 275.5 440.2 271.9 445.6 271.9 z M 453.7 347.8 L 437.2 347.8 L 437.2 295 L 453.7 295 L 453.7 347.8 z M 387.1 345.1 L 390.1 333.40000000000003 C 393.1 335.20000000000005 399.40000000000003 337.3 404.20000000000005 337.3 C 409.30000000000007 337.3 411.1 335.8 411.1 333.1 C 411.1 330.40000000000003 409.6 328.90000000000003 403.3 326.8 C 392.2 323.2 388 317.2 388.3 310.90000000000003 C 388.3 301.00000000000006 396.7 293.50000000000006 409.90000000000003 293.50000000000006 C 416.20000000000005 293.50000000000006 421.6 295.00000000000006 424.6 296.50000000000006 L 421.90000000000003 307.90000000000003 C 419.50000000000006 306.70000000000005 415.00000000000006 304.90000000000003 410.50000000000006 304.90000000000003 C 406.6000000000001 304.90000000000003 404.20000000000005 306.40000000000003 404.20000000000005 309.1 C 404.20000000000005 311.8 406.30000000000007 313 412.6 315.40000000000003 C 422.8 319.00000000000006 426.70000000000005 324.1 427 331.6 C 427 341.5 419.2 348.70000000000005 404.2 348.70000000000005 C 397.3 349 391.3 347.5 387.1 345.1 z M 326.8 347.8 L 326.8 311.8 C 326.8 305.2 326.5 299.8 326.5 295 L 340.9 295 L 341.79999999999995 302.5 L 342.09999999999997 302.5 C 344.2 298.9 349.59999999999997 294.1 358.29999999999995 294.1 C 369.09999999999997 294.1 377.19999999999993 301.3 377.19999999999993 316.90000000000003 L 377.19999999999993 348.1 L 360.69999999999993 348.1 L 360.69999999999993 318.70000000000005 C 360.69999999999993 311.80000000000007 358.29999999999995 307.30000000000007 352.29999999999995 307.30000000000007 C 347.79999999999995 307.30000000000007 345.09999999999997 310.30000000000007 343.9 313.6000000000001 C 343.59999999999997 314.80000000000007 343.29999999999995 316.30000000000007 343.29999999999995 317.80000000000007 L 343.29999999999995 348.4000000000001 L 326.79999999999995 348.4000000000001 L 326.79999999999995 347.8 z M 305.5 271.9 C 310.9 271.9 313.9 275.5 314.2 280 C 314.2 284.5 310.9 288.1 305.2 288.1 C 300.09999999999997 288.1 296.8 284.5 296.8 280 C 296.8 275.5 300.4 271.9 305.5 271.9 z M 313.6 347.8 L 297.1 347.8 L 297.1 295 L 313.6 295 L 313.6 347.8 z" stroke-linecap="round" />
</g>
<g transform="matrix(1.78 0 0 1.78 443.7 469.76)"  >
<path style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(57,65,74); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  transform=" translate(-154.45, -320.5)" d="M 68.2 316.9 L 68.2 335.5 C 68.2 340.6 68.5 345.4 69.10000000000001 348.4 L 54.4 348.4 L 53.5 343 L 53.2 343 C 49.6 347.2 44.2 349.6 38.2 349.6 C 27.400000000000002 349.6 21.1 341.8 21.1 333.1 C 20.8 319.3 33.1 313 51.7 313 L 51.7 312.4 C 51.7 309.4 50.2 305.5 42.1 305.5 C 36.7 305.5 31 307.3 27.400000000000002 309.4 L 24.400000000000002 298.59999999999997 C 28.000000000000004 296.49999999999994 35.2 293.79999999999995 45.1 293.79999999999995 C 62.8 293.8 68.2 304.3 68.2 316.9 z M 52.3 328.9 L 52.3 323.2 C 43.599999999999994 323.2 37 325.3 37 331.59999999999997 C 37 335.79999999999995 39.7 337.9 43.6 337.9 C 47.5 337.9 51.1 335.2 52 331.9 C 52.3 331 52.3 330.1 52.3 328.9 z M 81.4 370 L 81.4 313 C 81.4 306.1 81.10000000000001 300.1 81.10000000000001 295 L 95.50000000000001 295 L 96.40000000000002 302.5 L 96.70000000000002 302.5 C 100.60000000000002 296.8 106.60000000000002 293.8 114.40000000000002 293.8 C 126.10000000000002 293.8 136.3 304 136.3 320.8 C 136.3 340.3 124.00000000000001 349.3 112.30000000000001 349.3 C 106.00000000000001 349.3 100.9 346.6 98.50000000000001 343.3 L 98.20000000000002 343.3 L 98.20000000000002 370 L 81.4 370 z M 97.9 318.1 L 97.9 325.3 C 97.9 326.5 97.9 327.7 98.2 328.90000000000003 C 99.4 333.40000000000003 103 336.70000000000005 107.8 336.70000000000005 C 115 336.70000000000005 119.2 330.70000000000005 119.2 321.70000000000005 C 119.2 313.30000000000007 115.3 306.70000000000005 108.10000000000001 306.70000000000005 C 103.30000000000001 306.70000000000005 99.4 310.30000000000007 98.2 315.1 C 97.9 316 97.9 317.2 97.9 318.1 z M 146.2 370 L 146.2 313 C 146.2 306.1 145.89999999999998 300.1 145.89999999999998 295 L 160.29999999999998 295 L 161.2 302.5 L 161.5 302.5 C 164.8 296.8 170.8 293.8 178.6 293.8 C 190.29999999999998 293.8 200.5 304 200.5 320.8 C 200.5 340.3 188.2 349.3 176.5 349.3 C 170.2 349.3 165.1 346.6 162.7 343.3 L 162.39999999999998 343.3 L 162.39999999999998 370 L 146.2 370 z M 162.4 318.1 L 162.4 325.3 C 162.4 326.5 162.4 327.7 162.70000000000002 328.90000000000003 C 163.9 333.40000000000003 167.50000000000003 336.70000000000005 172.3 336.70000000000005 C 179.5 336.70000000000005 183.70000000000002 330.70000000000005 183.70000000000002 321.70000000000005 C 183.70000000000002 313.30000000000007 179.8 306.70000000000005 172.60000000000002 306.70000000000005 C 167.8 306.70000000000005 163.90000000000003 310.30000000000007 162.70000000000002 315.1 C 162.7 316 162.4 317.2 162.4 318.1 z M 210.7 348.4 L 227.2 348.4 L 227.2 271 L 210.7 271 C 210.7 271 210.7 348.4 210.7 348.4 z M 287.2 327.1 L 253.29999999999998 327.1 C 253.6 334 260.5 337.3 268.29999999999995 337.3 C 273.99999999999994 337.3 278.49999999999994 336.40000000000003 282.99999999999994 334.90000000000003 L 284.79999999999995 346.00000000000006 C 279.4 348.40000000000003 272.79999999999995 349.30000000000007 265.59999999999997 349.30000000000007 C 247.59999999999997 349.30000000000007 237.39999999999998 338.80000000000007 237.39999999999998 322.30000000000007 C 237.39999999999998 308.80000000000007 245.79999999999998 293.80000000000007 264.09999999999997 293.80000000000007 C 281.2 293.80000000000007 287.79999999999995 307.30000000000007 287.79999999999995 320.50000000000006 C 287.8 323.2 287.5 325.9 287.2 327.1 z M 253 315.7 L 272.5 315.7 C 272.5 311.8 270.7 304.9 263.2 304.9 C 256.3 304.9 253.6 311.2 253 315.7 z" stroke-linecap="round" />
</g>
</svg>`;

export const FREEDOM_PRESS_SVG = `
<svg viewBox="0 0 562 86" class="logo " fill="none" aria-hidden="true" xmlns="http://www.w3.org/2000/svg">
<path d="M83.7452 0.571289H0V23.5009H83.7452V0.571289Z" fill="white"></path>
<path d="M114.652 0.570801H91.7227V23.5004H114.652V0.570801Z" fill="#DA0A08"></path>
<path d="M114.656 31.478H45.8633V54.4077H114.656V31.478Z" fill="white"></path>
<path d="M114.652 62.3843H0V85.3139H114.652V62.3843Z" fill="white"></path>
<path d="M156.232 5.55482H139.481V16.0221H153.739V20.7078H139.481V35.2636H134.297V0.869141H156.229L156.232 5.55482Z" fill="white"></path>
<path d="M174.874 0.869141C181.354 0.869141 185.541 5.05605 185.541 10.9395C185.541 15.8254 182.549 19.0183 178.664 20.0123L186.539 35.1652H180.459L173.17 20.7078H166.7V35.1652H161.516V0.869141H174.874ZM166.7 5.55482V16.3242H174.378C177.866 16.3242 180.262 14.3291 180.262 10.9395C180.262 7.54993 177.968 5.55482 174.48 5.55482H166.7Z" fill="white"></path>
<path d="M214.158 5.55482H197.407V15.5233H211.664V20.209H197.407V30.4796H214.155V35.1652H192.223V0.869141H214.155L214.158 5.55482Z" fill="white"></path>
<path d="M242.272 5.55531H225.506V15.5238H239.764V20.2095H225.506V30.48H242.254V35.1657H220.336V0.869629H242.268L242.272 5.55531Z" fill="white"></path>
<path d="M260.515 0.869141C264.804 0.869141 267.891 2.27414 270.287 5.25626C272.781 8.34726 272.879 12.6325 272.879 18.1191C272.879 23.6056 272.781 27.8908 270.287 30.9818C267.895 33.9745 264.804 35.369 260.515 35.369H248.453V0.869141H260.515ZM253.638 5.55482V30.4936H259.928C262.422 30.4936 264.414 29.8965 265.812 28.1999C267.508 26.3067 267.607 23.1138 267.607 18.0137C267.607 12.9135 267.508 9.73822 265.812 7.82741C264.407 6.13087 262.422 5.53375 259.928 5.53375L253.638 5.55482Z" fill="white"></path>
<path d="M299.6 4.05823C302.99 7.4478 303.088 10.8374 303.088 18.0169C303.088 25.1965 302.99 28.5861 299.6 31.9756C297.408 34.1674 294.514 35.4635 290.728 35.4635C286.941 35.4635 284.054 34.1674 281.855 31.9756C278.466 28.5861 278.367 25.1965 278.367 18.0169C278.367 10.8374 278.466 7.4478 281.855 4.05823C284.047 1.86643 286.938 0.570312 290.724 0.570312C294.511 0.570312 297.405 1.86643 299.6 4.05823ZM285.642 7.34945C283.945 9.14434 283.646 11.2378 283.646 18.0169C283.646 24.7961 283.945 26.8895 285.642 28.6844C286.937 30.0894 288.632 30.7919 290.728 30.7919C291.674 30.8036 292.613 30.6229 293.487 30.2606C294.362 29.8983 295.153 29.362 295.814 28.6844C297.514 26.8895 297.805 24.7961 297.805 18.0029C297.805 11.2097 297.507 9.02842 295.81 7.3354C294.515 5.9304 292.82 5.22789 290.724 5.22789C288.628 5.22789 286.934 5.93508 285.642 7.34945Z" fill="white"></path>
<path d="M340.177 35.1652H334.992V12.2356L327.019 28.9832H323.127L315.048 12.2356V35.1652H309.867V0.869141H315.052L325.122 22.2181L334.992 0.869141H340.177V35.1652Z" fill="white"></path>
<path d="M378.757 4.05823C382.146 7.4478 382.244 10.8374 382.244 18.0169C382.244 25.1965 382.146 28.5861 378.757 31.9756C376.565 34.1674 373.67 35.4635 369.884 35.4635C366.097 35.4635 363.21 34.1674 361.011 31.9756C357.622 28.5861 357.523 25.1965 357.523 18.0169C357.523 10.8374 357.622 7.4478 361.011 4.05823C363.196 1.86643 366.097 0.570312 369.87 0.570312C373.642 0.570312 376.565 1.86643 378.757 4.05823ZM364.798 7.34945C363.101 9.14434 362.803 11.2378 362.803 18.0169C362.803 24.7961 363.101 26.8895 364.798 28.6844C366.093 30.0894 367.788 30.7919 369.884 30.7919C370.83 30.8036 371.769 30.6229 372.643 30.2606C373.518 29.8983 374.309 29.362 374.97 28.6844C376.667 26.8895 376.965 24.7961 376.965 18.0169C376.965 11.2378 376.667 9.04247 374.97 7.34945C373.675 5.94445 371.98 5.24194 369.884 5.24194C367.788 5.24194 366.094 5.94445 364.801 7.34945H364.798Z" fill="#C0C7CF"></path>
<path d="M410.966 5.55482H394.212V16.0221H408.469V20.7078H394.212V35.2636H389.027V0.869141H410.966V5.55482Z" fill="#C0C7CF"></path>
<path d="M447.949 5.55531H438.465V35.2641H433.281V5.55531H423.797V0.869629H447.924L447.949 5.55531Z" fill="#C0C7CF"></path>
<path d="M477.355 35.1657H472.17V20.2095H458.212V35.1657H453.027V0.869629H458.212V15.5238H472.17V0.869629H477.355V35.1657Z" fill="#C0C7CF"></path>
<path d="M507.272 5.55482H490.524V15.5233H504.782V20.209H490.524V30.4796H507.272V35.1652H485.34V0.869141H507.272V5.55482Z" fill="#C0C7CF"></path>
<path d="M147.258 50.5181C153.932 50.5181 158.224 55.0035 158.224 60.9853C158.224 66.9671 153.935 71.3542 147.258 71.3542H139.481V84.9125H134.297V50.5181H147.258ZM139.481 55.2037V66.6686H146.959C150.648 66.6686 153.04 64.5611 153.04 60.9853C153.04 57.2972 150.648 55.2037 146.959 55.2037H139.481Z" fill="white"></path>
<path d="M176.967 50.5181C183.447 50.5181 187.634 54.705 187.634 60.5884C187.634 65.4743 184.642 68.6672 180.757 69.6612L188.625 84.8142H182.552L175.372 70.3567H168.891V84.8142H163.707V50.5181H176.967ZM168.888 55.2037V65.9696H176.566C180.054 65.9696 182.45 63.9745 182.45 60.5849C182.45 57.1953 180.058 55.2002 176.566 55.2002L168.888 55.2037Z" fill="white"></path>
<path d="M216.252 55.2037H199.515V65.2741H213.772V69.9598H199.515V80.2304H216.263V84.916H194.316V50.5181H216.248L216.252 55.2037Z" fill="white"></path>
<path d="M242.666 54.1078L239.374 57.399C237.267 55.4039 234.787 54.7084 231.798 54.7084C227.709 54.7084 225.616 56.9002 225.616 60.0931C225.616 61.3892 225.915 62.4851 226.912 63.2825C227.808 64.0798 228.805 64.5786 230.702 64.7788L234.791 65.3759C237.882 65.8747 239.677 66.5737 241.173 67.9681C242.968 69.6647 243.965 72.0567 243.965 75.0458C243.965 81.3262 238.879 85.1162 231.601 85.1162C226.417 85.1162 222.729 83.9184 219.438 80.6307L222.827 77.2412C225.321 79.735 228.212 80.5324 231.7 80.5324C236.185 80.5324 238.777 78.6391 238.777 75.2636C238.777 73.7673 238.377 72.4712 237.372 71.6738C236.477 70.8765 235.377 70.4761 233.582 70.1775L229.494 69.5804C226.701 69.18 224.51 68.2843 223.013 66.7879C221.317 65.2916 220.421 62.998 220.421 60.209C220.421 54.2378 224.808 50.1387 231.886 50.1387C236.586 50.2195 239.775 51.4172 242.666 54.1078Z" fill="white"></path>
<path d="M269.986 54.1078L266.695 57.399C264.587 55.4039 262.107 54.7084 259.118 54.7084C255.03 54.7084 252.936 56.9002 252.936 60.0931C252.936 61.3892 253.235 62.4851 254.232 63.2825C255.128 64.0798 256.126 64.5786 258.022 64.7788L262.111 65.3759C265.202 65.8747 266.997 66.5737 268.493 67.9681C270.288 69.6647 271.286 72.0567 271.286 75.0458C271.286 81.3262 266.2 85.1162 258.922 85.1162C253.737 85.1162 250.049 83.9184 246.758 80.6307L250.147 77.2412C252.641 79.735 255.532 80.5324 259.02 80.5324C263.505 80.5324 266.098 78.6391 266.098 75.2636C266.098 73.7673 265.697 72.4712 264.693 71.6738C263.797 70.8765 262.698 70.4761 260.903 70.1775L256.814 69.5804C254.022 69.18 251.83 68.2843 250.334 66.7879C248.637 65.2916 247.741 62.998 247.741 60.209C247.741 54.2378 252.128 50.1387 259.206 50.1387C263.902 50.2195 266.993 51.4172 269.986 54.1078Z" fill="white"></path>
<path d="M309.768 55.2037H293.016V65.671H307.274V70.3567H293.016V84.916H287.832V50.5181H309.764L309.768 55.2037Z" fill="white"></path>
<path d="M334.092 53.7076C337.482 57.0972 337.58 60.4868 337.58 67.6663C337.58 74.8459 337.482 78.2355 334.092 81.625C331.901 83.8168 329.006 85.113 325.22 85.113C321.433 85.113 318.546 83.8168 316.347 81.625C312.958 78.2355 312.859 74.8459 312.859 67.6663C312.859 60.4868 312.958 57.0972 316.347 53.7076C318.539 51.5158 321.433 50.2197 325.22 50.2197C329.006 50.2197 331.901 51.5158 334.092 53.7076ZM320.137 56.9918C318.441 58.7867 318.142 60.8802 318.142 67.6593C318.142 74.4384 318.441 76.5319 320.137 78.3268C321.432 79.7318 323.128 80.4343 325.223 80.4343C326.17 80.446 327.109 80.2652 327.983 79.9029C328.857 79.5407 329.649 79.0044 330.309 78.3268C332.006 76.5319 332.305 74.4384 332.305 67.6593C332.305 60.8802 332.006 58.6849 330.309 56.9918C329.015 55.5868 327.319 54.8843 325.223 54.8843C323.128 54.8843 321.432 55.5868 320.137 56.9918Z" fill="white"></path>
<path d="M368.483 73.251C368.483 80.3287 363.099 85.1162 356.119 85.1162C349.14 85.1162 343.871 80.3287 343.871 73.251V50.5181H349.056V73.0508C349.056 77.6381 351.848 80.5289 356.133 80.5289C360.418 80.5289 363.313 77.6381 363.313 73.0508V50.5181H368.497V73.251H368.483Z" fill="white"></path>
<path d="M401.883 84.8142H397.099L381.247 60.6868V84.8142H376.062V50.5181H380.847L396.698 74.6455V50.5181H401.883V84.8142Z" fill="white"></path>
<path d="M421.933 50.5181C426.222 50.5181 429.309 51.9231 431.705 54.9052C434.199 57.9962 434.297 62.2814 434.297 67.768C434.297 73.2545 434.199 77.5398 431.705 80.6308C429.313 83.6234 426.222 85.0179 421.933 85.0179H409.871V50.5181H421.933ZM415.056 55.2037V80.2268H421.336C423.83 80.2268 425.821 79.6297 427.219 77.9332C428.916 76.0399 429.014 72.8471 429.014 67.7469C429.014 62.6467 428.916 59.4714 427.219 57.5606C425.814 55.8641 423.83 55.267 421.336 55.267H415.056V55.2037Z" fill="white"></path>
<path d="M465.896 84.8144H460.314L457.922 77.9369H444.364L441.972 84.8144H436.391L448.951 50.4199H453.117L465.896 84.8144ZM445.857 73.5498H456.426L451.157 58.295L445.857 73.5498Z" fill="white"></path>
<path d="M487.73 55.2037H478.246V84.916H473.062V55.2037H463.578V50.5181H487.706L487.73 55.2037Z" fill="white"></path>
<path d="M497.895 84.8142H492.711V50.5181H497.895V84.8142Z" fill="white"></path>
<path d="M525.913 53.7076C529.302 57.0972 529.401 60.4868 529.401 67.6663C529.401 74.8459 529.302 78.2355 525.913 81.625C523.721 83.8168 520.827 85.113 517.04 85.113C513.254 85.113 510.366 83.8168 508.168 81.625C504.778 78.2355 504.68 74.8459 504.68 67.6663C504.68 60.4868 504.778 57.0972 508.168 53.7076C510.359 51.5158 513.254 50.2197 517.04 50.2197C520.827 50.2197 523.717 51.5158 525.913 53.7076ZM511.863 56.9989C510.166 58.7938 509.868 60.8872 509.868 67.6663C509.868 74.4455 510.166 76.5389 511.863 78.3338C513.158 79.7388 514.853 80.4413 516.949 80.4413C517.895 80.453 518.834 80.2723 519.708 79.91C520.583 79.5477 521.374 79.0114 522.035 78.3338C523.731 76.5389 524.03 74.4455 524.03 67.6663C524.03 60.8872 523.731 58.6919 522.035 56.9989C520.74 55.5939 519.045 54.8914 516.949 54.8914C516.001 54.8743 515.06 55.0519 514.184 55.4132C513.308 55.7745 512.516 56.3118 511.856 56.9918L511.863 56.9989Z" fill="white"></path>
<path d="M562 84.8142H557.216L541.364 60.6868V84.8142H536.18V50.5181H540.964L556.816 74.6455V50.5181H562V84.8142Z" fill="white"></path>
</svg>
`;

export const PRIVACY_GUIDES_SVG = `
<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="100%" height="100%" version="1.1" viewBox="0 0 33 34" xml:space="preserve" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M4.581,4.337c-0.113,0.379 -0.049,0.822 0.077,1.707l1.604,11.224c0.277,1.939 0.415,2.909 0.782,3.775c0.325,0.768 0.781,1.474 1.346,2.087c0.638,0.691 1.465,1.217 3.117,2.269l2.349,1.495c1.126,0.716 1.69,1.075 2.295,1.214c0.465,0.108 0.947,0.121 1.416,0.042c-0.388,-0.887 -0.603,-1.867 -0.603,-2.897c0,-3.996 3.24,-7.236 7.236,-7.236c1.166,0 2.268,0.276 3.243,0.766c0.069,-0.432 0.14,-0.929 0.223,-1.514l0,-0.001l1.604,-11.224c0.126,-0.885 0.19,-1.328 0.077,-1.707c-0.099,-0.334 -0.292,-0.632 -0.557,-0.859c-0.3,-0.257 -0.73,-0.38 -1.59,-0.626l-9.441,-2.697c-0.296,-0.085 -0.444,-0.127 -0.594,-0.144c-0.134,-0.015 -0.268,-0.015 -0.402,0c-0.15,0.017 -0.298,0.059 -0.594,0.144l-9.441,2.697c-0.86,0.246 -1.29,0.369 -1.59,0.626c-0.265,0.227 -0.458,0.525 -0.557,0.859Z" style="fill:#ffd06f"/><path d="M13.246,2.719c0.066,-0.007 0.134,-0.007 0.201,0c0.057,0.007 0.122,0.022 0.446,0.114l9.44,2.698c0.444,0.126 0.727,0.208 0.94,0.287c0.202,0.075 0.274,0.124 0.311,0.156c0.132,0.113 0.229,0.262 0.278,0.429c0.014,0.047 0.03,0.133 0.016,0.348c-0.015,0.226 -0.056,0.518 -0.122,0.974l-1.346,9.426c-4.125,0.397 -7.351,3.873 -7.351,8.102c0,0.835 0.126,1.641 0.36,2.4l-0.451,0.286c-1.183,0.753 -1.594,1.001 -2.012,1.097c-0.401,0.092 -0.818,0.092 -1.22,0c-0.417,-0.096 -0.829,-0.344 -2.012,-1.097l-2.349,-1.494c-1.693,-1.078 -2.398,-1.535 -2.938,-2.12c-0.495,-0.536 -0.894,-1.153 -1.178,-1.825c-0.31,-0.733 -0.436,-1.564 -0.72,-3.551l-1.603,-11.224c-0.066,-0.456 -0.107,-0.748 -0.121,-0.974c-0.015,-0.215 0.001,-0.301 0.015,-0.348c0.05,-0.167 0.146,-0.316 0.279,-0.429c0.036,-0.032 0.109,-0.081 0.31,-0.156c0.213,-0.079 0.496,-0.161 0.94,-0.287l9.44,-2.698c0.324,-0.092 0.389,-0.107 0.447,-0.114Zm13.306,5.231l-1.318,9.228c4.007,0.508 7.106,3.93 7.106,8.075c0,4.496 -3.644,8.141 -8.14,8.141c-3.01,0 -5.639,-1.634 -7.048,-4.064l-0.212,0.136l-0.135,0.085c-0.996,0.634 -1.683,1.072 -2.443,1.248c-0.668,0.154 -1.364,0.154 -2.032,0c-0.76,-0.176 -1.447,-0.614 -2.443,-1.248l-0.134,-0.085l-2.466,-1.57l0,0c-1.541,-0.98 -2.461,-1.565 -3.179,-2.344c-0.637,-0.689 -1.149,-1.483 -1.515,-2.347c-0.413,-0.976 -0.567,-2.054 -0.825,-3.863l-1.628,-11.392c-0.059,-0.416 -0.111,-0.778 -0.131,-1.081c-0.021,-0.323 -0.012,-0.648 0.087,-0.98c0.148,-0.501 0.439,-0.949 0.835,-1.289c0.264,-0.226 0.557,-0.366 0.86,-0.478c0.285,-0.106 0.636,-0.206 1.04,-0.322l0.031,-0.009l9.44,-2.697l0.05,-0.014c0.247,-0.071 0.465,-0.133 0.693,-0.159c0.2,-0.022 0.402,-0.022 0.603,0c0.227,0.026 0.445,0.088 0.692,0.159l0.05,0.014l9.471,2.706c0.404,0.116 0.755,0.216 1.04,0.322c0.304,0.112 0.596,0.252 0.86,0.478c0.397,0.34 0.687,0.788 0.835,1.289c0.099,0.332 0.108,0.657 0.087,0.98c-0.02,0.303 -0.072,0.665 -0.131,1.08l0,0.001Zm-2.352,10.972c-3.497,0 -6.332,2.835 -6.332,6.331c0,3.497 2.835,6.332 6.332,6.332c3.497,0 6.331,-2.835 6.331,-6.332c0,-3.496 -2.834,-6.331 -6.331,-6.331Zm4.313,4.197c0.319,-0.384 0.268,-0.954 -0.116,-1.274c-0.384,-0.32 -0.954,-0.268 -1.274,0.116l-3.888,4.666l-2.013,-2.013c-0.354,-0.353 -0.926,-0.353 -1.28,0c-0.353,0.353 -0.353,0.926 0,1.279l2.714,2.713c0.18,0.18 0.427,0.276 0.68,0.264c0.254,-0.011 0.492,-0.129 0.654,-0.324l4.523,-5.427Zm-19.689,-10.529c0,-2.497 2.024,-4.522 4.522,-4.522c2.498,0 4.522,2.025 4.522,4.522c0,1.48 -0.71,2.794 -1.809,3.619l0,3.617c0,1.499 -1.214,2.714 -2.713,2.714c-1.499,0 -2.713,-1.215 -2.713,-2.714l0,-3.617c-1.099,-0.825 -1.809,-2.139 -1.809,-3.619Zm5.426,4.523l-1.808,0l0,2.713c0,0.5 0.405,0.905 0.904,0.905c0.5,0 0.904,-0.405 0.904,-0.905l0,-2.713Zm-0.904,-1.809c1.499,0 2.713,-1.215 2.713,-2.714c0,-1.498 -1.214,-2.713 -2.713,-2.713c-1.499,0 -2.713,1.215 -2.713,2.713c0,1.499 1.214,2.714 2.713,2.714Z" style="fill:#28323f"/></svg>`;

export const TECHLORE_SVG = `
<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 40 40"><g clip-path="url(#a)"><path fill="#EE5128" d="M19.998 39.995c11.044 0 19.997-8.953 19.997-19.997C39.995 8.953 31.042 0 19.998 0 8.953 0 0 8.953 0 19.998c0 11.044 8.953 19.997 19.998 19.997Z"></path><mask id="b" width="40" height="40" x="0" y="0" maskUnits="userSpaceOnUse" style="mask-type:luminance"><path fill="#fff" d="M19.998 39.995c11.044 0 19.997-8.953 19.997-19.997C39.995 8.953 31.042 0 19.998 0 8.953 0 0 8.953 0 19.998c0 11.044 8.953 19.997 19.998 19.997Z"></path></mask><g fill-rule="evenodd" clip-rule="evenodd" mask="url(#b)"><path fill="#FAB314" d="M-2.39 42.446 42.447-2.389l18.566 18.565-44.836 44.836-18.565-18.566Z"></path><path fill="#7CBB41" d="M19.998-2.39v19.072l.061 3.316L37.175 2.882l-9.748-5.271h-7.43Z"></path><path fill="#279AD5" d="M45.429 19.998h-25.37L38.34 1.717l7.09 18.28Z"></path></g><path fill="#000" d="M19.998 37.631c9.738 0 17.633-7.895 17.633-17.633 0-9.739-7.895-17.634-17.633-17.634-9.739 0-17.634 7.895-17.634 17.634 0 9.738 7.895 17.633 17.634 17.633Z"></path><mask id="c" width="36" height="36" x="2" y="2" maskUnits="userSpaceOnUse" style="mask-type:luminance"><path fill="#fff" d="M19.998 37.631c9.738 0 17.633-7.895 17.633-17.633 0-9.739-7.895-17.634-17.633-17.634-9.739 0-17.634 7.895-17.634 17.634 0 9.738 7.895 17.633 17.634 17.633Z"></path></mask><g mask="url(#c)"><path fill="#fff" d="M19.998 85.794c16.843 0 30.496-13.654 30.496-30.497 0-16.842-13.653-30.496-30.496-30.496C3.155 24.8-10.5 38.455-10.5 55.297c0 16.843 13.654 30.497 30.497 30.497Z"></path><path fill="#FAB314" fill-rule="evenodd" d="M20.218 32.033a.469.469 0 0 1-.44 0c-.618-.342-2.417-1.457-3.878-3.54-1.09-1.552-1.584-3.308-1.785-4.238a.643.643 0 0 1 .508-.768c.7-.137 1.864-.42 2.845-.916a9.381 9.381 0 0 0 2.204-1.587.469.469 0 0 1 .651 0 9.38 9.38 0 0 0 2.204 1.587c.981.497 2.145.779 2.845.916a.646.646 0 0 1 .508.768c-.2.93-.695 2.686-1.784 4.238-1.462 2.083-3.26 3.198-3.878 3.54Z" clip-rule="evenodd"></path><path fill="#fff" fill-rule="evenodd" d="M19.589 10.517a.47.47 0 0 0 .818 0c.775-1.387 1.998-2.43 3.532-2.84 3.355-.9 6.936 1.565 7.99 5.5 1.055 3.935-.814 7.86-4.17 8.759-2.846.762-5.854-.895-7.345-3.816a.468.468 0 0 0-.833 0c-1.49 2.921-4.499 4.578-7.345 3.816-3.356-.9-5.224-4.824-4.17-8.759 1.055-3.935 4.635-6.4 7.99-5.5 1.534.41 2.758 1.453 3.533 2.84Z" clip-rule="evenodd"></path><path class="logo-eye logo-eye--left" fill="#000" d="M16.42 18.093a1.951 1.951 0 1 0 0-3.902 1.951 1.951 0 0 0 0 3.902Z"></path><path class="logo-eye logo-eye--right" fill="#000" d="M23.575 18.093a1.951 1.951 0 1 0 0-3.902 1.951 1.951 0 0 0 0 3.902Z"></path></g></g><defs><clipPath id="a"><path fill="#fff" d="M0 0h40v40H0z"></path></clipPath></defs></svg>`;

export const XDA_SVG = `<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 113.8 33.6" style="enable-background:new 0 0 113.8 33.6;" xml:space="preserve">
<style type="text/css">
	.st0{fill:#2DAAE9;}
	.st1{fill:#E43F64;}
	.st2{fill:#BCBCBC;}
</style>
<g>
	<g>
		<path class="st0" d="M16,4.4V0.1h10.9v24.5H16v-4.2h6.4v-16H16z"/>
	</g>
	<polygon class="st1" points="10.9,4.4 10.9,0.1 0,0.1 0,24.6 5.5,24.6 10.9,33.6 10.9,20.4 4.5,20.4 4.5,4.4  "/>
	<polygon class="st2" points="58.1,1.3 58.2,1 59.2,0 53.8,0 46,9.2 38.3,0 32.8,0 33.8,1.1 43.3,12.4 33.8,23.8 32.8,24.8    38.3,24.8 46,15.6 53.8,24.8 59.2,24.8 58.3,23.8 48.7,12.4  "/>
	<path class="st2" d="M81.6,0H61.5v24.8h20.2c1.3,0,2.4-0.5,3.3-1.4c0.9-0.9,1.4-2,1.4-3.3V4.6c0-1.3-0.5-2.4-1.4-3.3   C84,0.5,82.9,0,81.6,0z M65.6,4.6c0-0.1,0-0.2,0.1-0.3c0.1-0.1,0.2-0.1,0.3-0.1h15.5c0.1,0,0.2,0,0.3,0.1c0.1,0.1,0.1,0.2,0.1,0.3   v15.5c0,0.1,0,0.2-0.1,0.3c-0.1,0.1-0.2,0.1-0.3,0.1H66.1c-0.1,0-0.2,0-0.3-0.1c-0.1-0.1-0.1-0.2-0.1-0.3V4.6z"/>
	<path class="st2" d="M112.4,1.4c-0.9-0.9-2-1.4-3.3-1.4H93.6c-1.3,0-2.4,0.5-3.3,1.4c-0.9,0.9-1.4,2-1.4,3.3v20.2h4.1v-8.5h16.5   v8.5h4.1V4.6C113.8,3.4,113.3,2.3,112.4,1.4z M93.1,4.6c0-0.1,0-0.2,0.1-0.3c0.1-0.1,0.2-0.1,0.3-0.1h15.5c0.1,0,0.2,0,0.3,0.1   c0.1,0.1,0.1,0.2,0.1,0.3v7.5H93.1V4.6z"/>
</g>
</svg>`;

export const NESS_LABS_PNG = `data:image/png;base64,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`;

export const ITS_FOSS_NEWS_PNG = `data:image/png;base64,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`;

export const APPLE_INSIDER_PNG = `data:image/png;base64,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`;
