'use strict';

const server = require('./server.cjs');
const TransNoContext = require('./shared/react.3eab4fb8.cjs');
const React = require('react');

function _interopDefaultCompat (e) { return e && typeof e === 'object' && 'default' in e ? e.default : e; }

const React__default = /*#__PURE__*/_interopDefaultCompat(React);

function TransRsc(props) {
  const ctx = server.getI18n();
  if (!ctx) {
    throw new Error(
      "You tried to use `Trans` in Server Component, but i18n instance for RSC hasn't been setup.\nMake sure to call `setI18n` in the root of your page."
    );
  }
  return /* @__PURE__ */ React__default.createElement(TransNoContext.TransNoContext, { ...props, lingui: ctx });
}

function useLingui() {
  const ctx = server.getI18n();
  if (!ctx) {
    throw new Error(
      "You tried to use `useLingui` in a Server Component, but i18n instance for RSC hasn't been setup.\nMake sure to call `setI18n` in the root of your page."
    );
  }
  return ctx;
}

exports.Trans = TransRsc;
exports.useLingui = useLingui;
