import * as React from 'react';
import { useCallback, memo } from 'react';
import Animated from 'react-native-reanimated';
import { LegendList } from '@legendapp/list';

// src/integrations/reanimated.tsx

// src/utils/helpers.ts
function isFunction(obj) {
  return typeof obj === "function";
}

// src/hooks/useCombinedRef.ts
var useCombinedRef = (...refs) => {
  const callback = useCallback((element) => {
    for (const ref of refs) {
      if (!ref) {
        continue;
      }
      if (isFunction(ref)) {
        ref(element);
      } else {
        ref.current = element;
      }
    }
  }, refs);
  return callback;
};

// src/integrations/reanimated.tsx
var typedMemo = memo;
var LegendListForwardedRef = typedMemo(
  React.forwardRef(function LegendListForwardedRef2(props, ref) {
    const { refLegendList, ...rest } = props;
    const refFn = useCallback(
      (r) => {
        refLegendList(r);
      },
      [refLegendList]
    );
    return /* @__PURE__ */ React.createElement(LegendList, { ref: refFn, refScrollView: ref, ...rest });
  })
);
var AnimatedLegendListComponent = Animated.createAnimatedComponent(LegendListForwardedRef);
var AnimatedLegendList = typedMemo(
  React.forwardRef(function AnimatedLegendList2(props, ref) {
    const { refScrollView, ...rest } = props;
    const refLegendList = React.useRef(null);
    const combinedRef = useCombinedRef(refLegendList, ref);
    return /* @__PURE__ */ React.createElement(AnimatedLegendListComponent, { ref: refScrollView, refLegendList: combinedRef, ...rest });
  })
);

export { AnimatedLegendList };
